/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Equal;
import com.thaiopensource.validate.nrl.ContextMap;
import com.thaiopensource.validate.nrl.Mode;
import java.util.Enumeration;
import java.util.Vector;

class ModeUsage {
    private final Mode mode;
    private final Mode currentMode;
    private ContextMap modeMap;
    private int attributeProcessing = -1;

    ModeUsage(Mode mode, Mode currentMode) {
        this(mode, currentMode, null);
    }

    private ModeUsage(Mode mode, Mode currentMode, ContextMap modeMap) {
        this.mode = mode;
        this.currentMode = currentMode;
        this.modeMap = modeMap;
    }

    ModeUsage changeCurrentMode(Mode currentMode) {
        return new ModeUsage(this.mode, currentMode, this.modeMap);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModeUsage)) {
            return false;
        }
        ModeUsage other = (ModeUsage)obj;
        return this.mode == other.mode && this.currentMode == other.currentMode && Equal.equal(this.modeMap, other.modeMap);
    }

    public int hashCode() {
        int hc = this.mode.hashCode() ^ this.currentMode.hashCode();
        if (this.modeMap != null) {
            hc ^= this.modeMap.hashCode();
        }
        return hc;
    }

    private Mode resolve(Mode mode) {
        return mode == Mode.CURRENT ? this.currentMode : mode;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.resolve(this.mode).getAttributeProcessing();
            if (this.modeMap != null) {
                Enumeration enumeration = this.modeMap.values();
                while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                    this.attributeProcessing = Math.max(this.resolve((Mode)enumeration.nextElement()).getAttributeProcessing(), this.attributeProcessing);
                }
            }
        }
        return this.attributeProcessing;
    }

    boolean isContextDependent() {
        return this.modeMap != null;
    }

    Mode getMode(Vector context) {
        Mode m;
        if (this.modeMap != null && (m = (Mode)this.modeMap.get(context)) != null) {
            return this.resolve(m);
        }
        return this.resolve(this.mode);
    }

    boolean addContext(boolean isRoot, Vector names, Mode mode) {
        if (this.modeMap == null) {
            this.modeMap = new ContextMap();
        }
        return this.modeMap.put(isRoot, names, mode);
    }
}

