/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.nrl.SchemaImpl;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String NRL_SCHEMA = "nrl.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final boolean attributesSchema;
    private final SchemaReader autoSchemaReader;
    private Schema nrlSchema = null;
    private static final PropertyId[] subSchemaProperties = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, SchemaReceiverFactory.PROPERTY};
    static /* synthetic */ Class class$com$thaiopensource$validate$nrl$SchemaReceiverImpl;

    public SchemaReceiverImpl(PropertyMap properties) {
        this.attributesSchema = properties.contains(NrlProperty.ATTRIBUTES_SCHEMA);
        PropertyMapBuilder builder = new PropertyMapBuilder();
        for (int i = 0; i < subSchemaProperties.length; ++i) {
            Object value = properties.get(subSchemaProperties[i]);
            if (value == null) continue;
            builder.put(subSchemaProperties[i], value);
        }
        this.properties = builder.toPropertyMap();
        this.autoSchemaReader = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(properties));
    }

    public SchemaFuture installHandlers(XMLReader xr) {
        PropertyMapBuilder builder = new PropertyMapBuilder(this.properties);
        if (this.attributesSchema) {
            NrlProperty.ATTRIBUTES_SCHEMA.add(builder);
        }
        return new SchemaImpl(builder.toPropertyMap()).installHandlers(xr, this);
    }

    Schema getNrlSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.nrlSchema == null) {
            String className = (class$com$thaiopensource$validate$nrl$SchemaReceiverImpl == null ? (class$com$thaiopensource$validate$nrl$SchemaReceiverImpl = SchemaReceiverImpl.class$("com.thaiopensource.validate.nrl.SchemaReceiverImpl")) : class$com$thaiopensource$validate$nrl$SchemaReceiverImpl).getName();
            String resourceName = className.substring(0, className.lastIndexOf(46)).replace('.', '/') + "/resources/" + NRL_SCHEMA;
            URL nrlSchemaUrl = SchemaReceiverImpl.getResource(resourceName);
            this.nrlSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(nrlSchemaUrl.toString()), this.properties);
        }
        return this.nrlSchema;
    }

    private static URL getResource(String resourceName) {
        ClassLoader cl = (class$com$thaiopensource$validate$nrl$SchemaReceiverImpl == null ? (class$com$thaiopensource$validate$nrl$SchemaReceiverImpl = SchemaReceiverImpl.class$("com.thaiopensource.validate.nrl.SchemaReceiverImpl")) : class$com$thaiopensource$validate$nrl$SchemaReceiverImpl).getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(resourceName);
        }
        return cl.getResource(resourceName);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(InputSource inputSource, String schemaType, PropertyMap options, boolean isAttributesSchema) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader reader = SchemaReceiverImpl.isRnc(schemaType) ? CompactSchemaReader.getInstance() : this.autoSchemaReader;
        PropertyMapBuilder builder = new PropertyMapBuilder(this.properties);
        if (isAttributesSchema) {
            NrlProperty.ATTRIBUTES_SCHEMA.add(builder);
        }
        int len = options.size();
        for (int i = 0; i < len; ++i) {
            builder.put(options.getKey(i), options.get(options.getKey(i)));
        }
        return reader.createSchema(inputSource, builder.toPropertyMap());
    }

    Option getOption(String uri) {
        Option option = this.autoSchemaReader.getOption(uri);
        if (option != null) {
            return option;
        }
        return CompactSchemaReader.getInstance().getOption(uri);
    }

    private static boolean isRnc(String schemaType) {
        if (schemaType == null) {
            return false;
        }
        schemaType = schemaType.trim();
        return schemaType.equals(RNC_MEDIA_TYPE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

