/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.schematron.OutputHandler;
import com.thaiopensource.validate.schematron.XMLReaderImpl;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ValidatorImpl
extends DelegatingContentHandler
implements Validator {
    private final Transformer transformer;
    private Locator locator;
    private TransformerException transformerException;
    private final Object contentHandlerMonitor = new Object();
    private final Object parseMonitor = new Object();
    private final Object transformMonitor = new Object();
    private Thread transformThread;
    private final ContentHandler outputHandler;

    ValidatorImpl(Templates templates, PropertyMap properties) {
        ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
        this.outputHandler = new OutputHandler(eh);
        try {
            this.transformer = templates.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("could not create transformer");
        }
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.transformThread != null) {
            Object object = this.transformMonitor;
            synchronized (object) {
                this.transformThread.interrupt();
                try {
                    this.transformMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.transformThread = null;
            }
        }
        this.transformerException = null;
        this.locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDocument() throws SAXException {
        final SAXSource source = new SAXSource(new BlockingReader(), new InputSource(""));
        this.transformThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        ValidatorImpl.this.transformer.transform(source, new SAXResult(ValidatorImpl.this.outputHandler));
                    }
                    catch (TransformerException e) {
                        ValidatorImpl.this.transformerException = e;
                        Object var3_2 = null;
                        Object object2 = ValidatorImpl.this.transformMonitor;
                        synchronized (object2) {
                            ValidatorImpl.this.transformMonitor.notify();
                            return;
                        }
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    Object object = ValidatorImpl.this.transformMonitor;
                    synchronized (object) {
                        ValidatorImpl.this.transformMonitor.notify();
                        throw throwable;
                    }
                }
                Object object = ValidatorImpl.this.transformMonitor;
                synchronized (object) {
                    ValidatorImpl.this.transformMonitor.notify();
                    return;
                }
            }
        }, "Transform");
        Object object = this.contentHandlerMonitor;
        synchronized (object) {
            this.transformThread.start();
            try {
                this.contentHandlerMonitor.wait();
            }
            catch (InterruptedException e) {
                throw new SAXException(e);
            }
        }
        if (this.locator != null) {
            super.setDocumentLocator(this.locator);
        }
        super.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        super.endDocument();
        Object object = this.transformMonitor;
        synchronized (object) {
            Object object2 = this.parseMonitor;
            synchronized (object2) {
                this.parseMonitor.notify();
            }
            try {
                this.transformMonitor.wait();
            }
            catch (InterruptedException e) {
                throw new SAXException(e);
            }
            finally {
                this.transformThread = null;
            }
        }
        if (this.transformerException != null) {
            throw ValidatorImpl.toSAXException(this.transformerException);
        }
    }

    static SAXException toSAXException(TransformerException transformerException) {
        Throwable wrapped = transformerException.getException();
        if (wrapped instanceof SAXException) {
            return (SAXException)wrapped;
        }
        if (wrapped instanceof RuntimeException) {
            throw (RuntimeException)wrapped;
        }
        if (wrapped instanceof Exception) {
            return new SAXException((Exception)wrapped);
        }
        return new SAXException(transformerException);
    }

    class BlockingReader
    extends XMLReaderImpl {
        BlockingReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(InputSource in) throws SAXException {
            Object object = ValidatorImpl.this.parseMonitor;
            synchronized (object) {
                Object object2 = ValidatorImpl.this.contentHandlerMonitor;
                synchronized (object2) {
                    ValidatorImpl.this.contentHandlerMonitor.notify();
                }
                try {
                    ValidatorImpl.this.parseMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new SAXException(e);
                }
            }
        }

        public void setContentHandler(ContentHandler handler) {
            ValidatorImpl.this.setDelegate(handler);
        }

        public ContentHandler getContentHandler() {
            return ValidatorImpl.this.getDelegate();
        }
    }
}

