/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValidatorImpl
extends ParserConfigurationSettings
implements Validator,
ContentHandler,
DTDHandler,
XMLLocator,
XMLEntityResolver,
EntityState {
    private final XMLSchemaValidator schemaValidator = new XMLSchemaValidator();
    private final XMLErrorReporter errorReporter = new XMLErrorReporter();
    private final ValidationManager validationManager = new ValidationManager();
    private final NamespaceContext namespaceContext = new NamespaceSupport();
    private final XMLAttributes attributes = new XMLAttributesImpl();
    private final SymbolTable symbolTable;
    private final XMLComponent[] components;
    private Locator locator;
    private final Hashtable entityTable = new Hashtable();
    private boolean pushedContext = false;
    private static final String[] recognizedFeatures = new String[]{"http://apache.org/xml/features/validation/schema/augment-psvi", "http://apache.org/xml/features/validation/schema-full-checking", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema"};
    private static final String[] recognizedProperties = new String[]{"http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/entity-resolver"};

    ValidatorImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool, PropertyMap properties) {
        this.symbolTable = symbolTable;
        ErrorHandlerWrapper errorHandlerWrapper = new ErrorHandlerWrapper(ValidateProperty.ERROR_HANDLER.get(properties));
        this.components = new XMLComponent[]{this.errorReporter, this.schemaValidator};
        for (int i = 0; i < this.components.length; ++i) {
            this.addRecognizedFeatures(this.components[i].getRecognizedFeatures());
            this.addRecognizedProperties(this.components[i].getRecognizedProperties());
        }
        this.addRecognizedFeatures(recognizedFeatures);
        this.addRecognizedProperties(recognizedProperties);
        this.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", false);
        this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
        this.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        this.errorReporter.setDocumentLocator(this);
        this.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.errorReporter);
        this.setProperty("http://apache.org/xml/properties/internal/error-handler", errorHandlerWrapper);
        this.setProperty("http://apache.org/xml/properties/internal/validation-manager", this.validationManager);
        this.setProperty("http://apache.org/xml/properties/internal/entity-manager", this);
        this.setProperty("http://apache.org/xml/properties/internal/entity-resolver", this);
        this.reset();
    }

    public void reset() {
        this.validationManager.reset();
        this.namespaceContext.reset();
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].reset(this);
        }
        this.validationManager.setEntityState(this);
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        this.entityTable.put(name, name);
    }

    public boolean isEntityDeclared(String name) {
        return this.entityTable.get(name) != null;
    }

    public boolean isEntityUnparsed(String name) {
        return this.entityTable.get(name) != null;
    }

    public void startDocument() throws SAXException {
        try {
            this.schemaValidator.startDocument(this.locator == null ? null : this, null, this.namespaceContext, null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.schemaValidator.endDocument(null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
            } else {
                this.pushedContext = false;
            }
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                this.attributes.addAttribute(this.makeQName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i)), this.symbolTable.addSymbol(atts.getType(i)), atts.getValue(i));
            }
            this.schemaValidator.startElement(this.makeQName(namespaceURI, localName, qName), this.attributes, null);
            this.attributes.removeAllAttributes();
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.schemaValidator.endElement(this.makeQName(namespaceURI, localName, qName), null);
            this.namespaceContext.popContext();
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
                this.pushedContext = true;
            }
            prefix = prefix == null ? XMLSymbols.EMPTY_STRING : this.symbolTable.addSymbol(prefix);
            if (uri != null) {
                uri = uri.equals("") ? null : this.symbolTable.addSymbol(uri);
            }
            this.namespaceContext.declarePrefix(prefix, uri);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.schemaValidator.characters(new XMLString(ch, start, length), null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.schemaValidator.ignorableWhitespace(new XMLString(ch, start, length), null);
        }
        catch (XNIException e) {
            throw ValidatorImpl.toSAXException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private QName makeQName(String namespaceURI, String localName, String qName) {
        String prefix;
        localName = this.symbolTable.addSymbol(localName);
        if (namespaceURI.equals("")) {
            namespaceURI = null;
            prefix = XMLSymbols.EMPTY_STRING;
            qName = localName;
        } else {
            namespaceURI = this.symbolTable.addSymbol(namespaceURI);
            if (qName.equals("")) {
                prefix = this.namespaceContext.getPrefix(namespaceURI);
                qName = prefix == XMLSymbols.EMPTY_STRING ? localName : (prefix == null ? localName : this.symbolTable.addSymbol(prefix + ":" + localName));
            } else {
                int colon = (qName = this.symbolTable.addSymbol(qName)).indexOf(58);
                prefix = colon > 0 ? this.symbolTable.addSymbol(qName.substring(0, colon)) : XMLSymbols.EMPTY_STRING;
            }
        }
        return new QName(prefix, localName, qName, namespaceURI);
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        return null;
    }

    public String getPublicId() {
        return this.locator.getPublicId();
    }

    public String getEncoding() {
        return null;
    }

    public String getBaseSystemId() {
        return null;
    }

    public String getLiteralSystemId() {
        return null;
    }

    public String getExpandedSystemId() {
        return this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    static SAXException toSAXException(XNIException e) {
        if (e instanceof XMLParseException) {
            XMLParseException pe = (XMLParseException)e;
            return new SAXParseException(pe.getMessage(), pe.getPublicId(), pe.getExpandedSystemId(), pe.getLineNumber(), pe.getColumnNumber(), pe.getException());
        }
        Exception nested = e.getException();
        if (nested == null) {
            return new SAXException(e.getMessage());
        }
        if (nested instanceof SAXException) {
            return (SAXException)nested;
        }
        if (nested instanceof RuntimeException) {
            throw (RuntimeException)nested;
        }
        return new SAXException(nested);
    }
}

