/*
 * Decompiled with CFR 0.152.
 */
package org.relaxng.datatype.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

public class DatatypeLibraryLoader
implements DatatypeLibraryFactory {
    private final Service service = new Service(class$org$relaxng$datatype$DatatypeLibraryFactory == null ? (class$org$relaxng$datatype$DatatypeLibraryFactory = DatatypeLibraryLoader.class$("org.relaxng.datatype.DatatypeLibraryFactory")) : class$org$relaxng$datatype$DatatypeLibraryFactory);
    static /* synthetic */ Class class$org$relaxng$datatype$DatatypeLibraryFactory;
    static /* synthetic */ Class class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader;
    static /* synthetic */ Class class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader2;

    public DatatypeLibrary createDatatypeLibrary(String uri) {
        Enumeration e = this.service.getProviders();
        while (e.hasMoreElements()) {
            DatatypeLibraryFactory factory = (DatatypeLibraryFactory)e.nextElement();
            DatatypeLibrary library = factory.createDatatypeLibrary(uri);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Service {
        private final Class serviceClass;
        private final Enumeration configFiles;
        private Enumeration classNames = null;
        private final Vector providers = new Vector();
        private Loader loader;
        private static final int START = 0;
        private static final int IN_NAME = 1;
        private static final int IN_COMMENT = 2;

        public Service(Class cls) {
            try {
                this.loader = new Loader2();
            }
            catch (NoSuchMethodError e) {
                this.loader = new Loader();
            }
            this.serviceClass = cls;
            String resName = "META-INF/services/" + this.serviceClass.getName();
            this.configFiles = this.loader.getResources(resName);
        }

        public Enumeration getProviders() {
            return new ProviderEnumeration();
        }

        private synchronized boolean moreProviders() {
            while (true) {
                if (this.classNames == null) {
                    if (!this.configFiles.hasMoreElements()) {
                        return false;
                    }
                    this.classNames = Service.parseConfigFile((URL)this.configFiles.nextElement());
                    continue;
                }
                while (this.classNames.hasMoreElements()) {
                    String className = (String)this.classNames.nextElement();
                    try {
                        Class cls = this.loader.loadClass(className);
                        Object obj = cls.newInstance();
                        if (!this.serviceClass.isInstance(obj)) continue;
                        this.providers.addElement(obj);
                        return true;
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (LinkageError linkageError) {
                    }
                }
                this.classNames = null;
            }
        }

        private static Enumeration parseConfigFile(URL url) {
            try {
                int n;
                Reader r;
                InputStream in = url.openStream();
                try {
                    r = new InputStreamReader(in, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader(in, "UTF8");
                }
                r = new BufferedReader(r);
                Vector<String> tokens = new Vector<String>();
                StringBuffer tokenBuf = new StringBuffer();
                int state = 0;
                while ((n = r.read()) >= 0) {
                    char c = (char)n;
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            state = 0;
                            break;
                        }
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '#': {
                            state = 2;
                            break;
                        }
                        default: {
                            if (state == 2) break;
                            state = 1;
                            tokenBuf.append(c);
                        }
                    }
                    if (tokenBuf.length() == 0 || state == 1) continue;
                    tokens.addElement(tokenBuf.toString());
                    tokenBuf.setLength(0);
                }
                if (tokenBuf.length() != 0) {
                    tokens.addElement(tokenBuf.toString());
                }
                return tokens.elements();
            }
            catch (IOException e) {
                return null;
            }
        }

        private static class Loader2
        extends Loader {
            private ClassLoader cl = (class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader2 == null ? (class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader2 = DatatypeLibraryLoader.class$("org.relaxng.datatype.helpers.DatatypeLibraryLoader$Service$Loader2")) : class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader2).getClassLoader();

            Loader2() {
                ClassLoader clt;
                for (ClassLoader tem = clt = Thread.currentThread().getContextClassLoader(); tem != null; tem = tem.getParent()) {
                    if (tem != this.cl) continue;
                    this.cl = clt;
                    break;
                }
            }

            Enumeration getResources(String resName) {
                try {
                    Enumeration<URL> resources = this.cl.getResources(resName);
                    if (resources.hasMoreElements()) {
                        return resources;
                    }
                    return new Singleton(this.cl.getResource(resName));
                }
                catch (IOException e) {
                    return new Singleton(null);
                }
            }

            Class loadClass(String name) throws ClassNotFoundException {
                return Class.forName(name, true, this.cl);
            }
        }

        private static class Loader {
            private Loader() {
            }

            Enumeration getResources(String resName) {
                ClassLoader cl = (class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader == null ? (class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader = DatatypeLibraryLoader.class$("org.relaxng.datatype.helpers.DatatypeLibraryLoader$Service$Loader")) : class$org$relaxng$datatype$helpers$DatatypeLibraryLoader$Service$Loader).getClassLoader();
                URL url = cl == null ? ClassLoader.getSystemResource(resName) : cl.getResource(resName);
                return new Singleton(url);
            }

            Class loadClass(String name) throws ClassNotFoundException {
                return Class.forName(name);
            }
        }

        private static class Singleton
        implements Enumeration {
            private Object obj;

            private Singleton(Object obj) {
                this.obj = obj;
            }

            public boolean hasMoreElements() {
                return this.obj != null;
            }

            public Object nextElement() {
                if (this.obj == null) {
                    throw new NoSuchElementException();
                }
                Object tem = this.obj;
                this.obj = null;
                return tem;
            }
        }

        private class ProviderEnumeration
        implements Enumeration {
            private int nextIndex = 0;

            private ProviderEnumeration() {
            }

            public boolean hasMoreElements() {
                return this.nextIndex < Service.this.providers.size() || Service.this.moreProviders();
            }

            public Object nextElement() {
                try {
                    return Service.this.providers.elementAt(this.nextIndex++);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

