/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineOption;
import org.kohsuke.args4j.IllegalOptionParameterException;
import org.kohsuke.args4j.MissingOptionParameterException;
import org.kohsuke.args4j.UndefinedOptionException;

public final class CmdLineParser {
    private final List options = new ArrayList(50);
    private final List arguments = new ArrayList(50);
    private final List readonlyArguments = Collections.unmodifiableList(this.arguments);
    static /* synthetic */ Class class$org$kohsuke$args4j$CmdLineOption;

    public CmdLineOption addOption(CmdLineOption opt) {
        this.options.add(opt);
        return opt;
    }

    public void addOptionClass(Object obj) {
        Field[] fields = obj.getClass().getFields();
        if (fields.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!(class$org$kohsuke$args4j$CmdLineOption == null ? CmdLineParser.class$("org.kohsuke.args4j.CmdLineOption") : class$org$kohsuke$args4j$CmdLineOption).isAssignableFrom(fields[i].getType())) continue;
            try {
                this.addOption((CmdLineOption)fields[i].get(obj));
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void parse(String[] args) throws CmdLineException {
        CmdLineImpl cmdLine = new CmdLineImpl(args);
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getOptionName();
            if (arg.startsWith("-") & arg.length() > 1) {
                int j;
                for (j = 0; j < this.options.size(); ++j) {
                    CmdLineOption opt = (CmdLineOption)this.options.get(j);
                    if (!opt.accepts(arg)) continue;
                    int diff = opt.parseArguments(this, cmdLine);
                    cmdLine.proceed(diff + 1);
                    break;
                }
                if (j != this.options.size()) continue;
                throw new UndefinedOptionException(arg);
            }
            this.arguments.add(arg);
            cmdLine.proceed(1);
        }
    }

    public List getArguments() {
        return this.readonlyArguments;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CmdLineImpl
    implements CmdLineOption.Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args) {
            this.args = args;
            this.pos = 0;
        }

        private boolean hasMore() {
            return this.pos < this.args.length;
        }

        private String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getOptionName() {
            return this.getCurrentToken();
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx + 1 >= this.args.length) {
                throw new MissingOptionParameterException(this.getOptionName());
            }
            return this.args[this.pos + idx + 1];
        }

        public int getIntParameter(int idx) throws CmdLineException {
            String token = this.getParameter(idx);
            try {
                return Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionParameterException(this.getOptionName(), token);
            }
        }
    }
}

