/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.xml.bind.webapp;

import java.io.IOException;

import javax.servlet.ServletException;

/**
 * Servlet that displays the progress message while the task is
 * running in a separate thread.
 * 
 * @author
 *     Kohsuke Kawaguchi (kohsuke.kawaguchi@sun.com)
 */
public abstract class LongProcessServlet extends HttpServletEx {

    protected void run() throws ServletException, IOException {
        Thread task = getTask();
        if( task==null ) {
            // start the processing
            task = createTask();
            setTaskThread(task);
            task.start();
            
            try { // wait for the completion some time to save a round trip if the task ends quickly.
                task.join(3000);
            } catch( InterruptedException e ) {
                ;   // ignore
            }
        }
        
        // check if the task is still running
        if(task.isAlive()) {
            request.setAttribute("title", getProgressTitle() );
            request.setAttribute("message", getProgressMessage() );
            request.setAttribute("comebackto",
                n(request.getContextPath())+
                n(request.getServletPath())+
                n(request.getPathInfo()) );
            // the task is still working
            forward("/checkback.jsp");
        } else
            // it is finished
            renderResult(getTask());
    }
    
    private String n(String s) {
        if(s==null) return "";
        else        return s;
    }
    
    protected abstract String getProgressTitle();
    protected abstract String getProgressMessage();

    /**
     * Creates a task that does the actual processing.
     */
    protected abstract Thread createTask() throws ServletException, IOException;
    
    /**
     * The task is completed. Render the result.
     */
    protected abstract void renderResult( Thread task ) throws ServletException, IOException; 
    
    
    /**
     * Gets the task associated with the current session or null.
     */
    protected final Thread getTask() {
        return (Thread)request.getSession().getAttribute(this.getClass().getName());
    }

    private void setTaskThread( Thread t ) {
        request.getSession().setAttribute(this.getClass().getName(),t);
    }
}
