/*
 * Decompiled with CFR 0.152.
 */
package com.jartifacts.formattedTxt;

import com.jartifacts.formattedTxt.TxtFieldDefinition;
import com.jartifacts.formattedTxt.annotations.TxtField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TxtFile {
    protected String fineName;
    protected String lineSeparator = System.getProperties().getProperty("line.separator");
    protected String columnSeparator = "";
    protected String attachedTable;
    protected Object model;
    protected List<TxtFieldDefinition> structureModel = new ArrayList<TxtFieldDefinition>();
    protected Object actualRow;

    public String getFileName() {
        return this.fineName;
    }

    public void setFileName(String fileName) {
        this.fineName = fileName;
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
        this.structureModel.clear();
        Class<?> cls = model.getClass();
        while (cls != null) {
            Field[] fieldList = cls.getDeclaredFields();
            int index = 0;
            while (index < fieldList.length) {
                TxtField annotation = fieldList[index].getAnnotation(TxtField.class);
                if (annotation instanceof TxtField) {
                    TxtField fieldAnnotation = annotation;
                    String fieldName = "";
                    fieldName = fieldAnnotation.fieldName().isEmpty() ? fieldList[index].getName() : fieldAnnotation.fieldName();
                    TxtFieldDefinition txtField = new TxtFieldDefinition();
                    txtField.setFieldName(fieldName);
                    txtField.setLeftPosition(fieldAnnotation.leftPosition());
                    txtField.setRightPosition(fieldAnnotation.rightPosition());
                    txtField.setWidth(fieldAnnotation.width());
                    txtField.setPojoField(fieldList[index]);
                    this.structureModel.add(txtField);
                }
                ++index;
            }
            Method[] methodList = cls.getDeclaredMethods();
            int index2 = 0;
            while (index2 < fieldList.length) {
                TxtField annotation = methodList[index2].getAnnotation(TxtField.class);
                if (annotation instanceof TxtField) {
                    TxtField fieldAnnotation = annotation;
                    String fieldName = "";
                    String methodName = methodList[index2].getName();
                    if (fieldAnnotation.fieldName().isEmpty()) {
                        if (methodName.substring(0, 3).equals("get")) {
                            fieldName = String.valueOf(methodName.substring(3, 4).toLowerCase()) + (methodName.length() > 3 ? methodName.substring(4) : "");
                        }
                    } else {
                        fieldName = fieldAnnotation.fieldName();
                    }
                    if (fieldName.length() > 0) {
                        TxtFieldDefinition txtField = new TxtFieldDefinition();
                        txtField.setFieldName(fieldName);
                        txtField.setLeftPosition(fieldAnnotation.leftPosition());
                        txtField.setRightPosition(fieldAnnotation.rightPosition());
                        txtField.setWidth(fieldAnnotation.width());
                        int i = 0;
                        while (i < fieldList.length) {
                            if (fieldList[i].getName().toString().equals(fieldName)) {
                                txtField.setPojoField(fieldList[i]);
                            }
                            ++i;
                        }
                        this.structureModel.add(txtField);
                    }
                }
                ++index2;
            }
            cls = cls.getSuperclass();
        }
        Collections.sort(this.structureModel);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public String getAttachedTable() {
        return this.attachedTable;
    }

    public void setAttachedTable(String attachedTable) {
        this.attachedTable = attachedTable;
    }

    public List<TxtFieldDefinition> getStructureModel() {
        return this.structureModel;
    }
}

