/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.commons;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.PropertyInfo;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.services.MicroProfileAssert;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MicroProfileProjectInfoTest {
    @Test
    public void getSimpleProperty() {
        MicroProfileProjectInfo info = MicroProfileAssert.getDefaultMicroProfileProjectInfo();
        PropertyInfo property = MicroProfileProjectInfoTest.getProperty("quarkus.thread-pool.core-threads", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNull((Object)property.getProfile());
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.thread-pool.core-threads", (Object)property.getProperty().getName());
    }

    @Test
    public void getPropertyWithOnlyProfile() {
        MicroProfileProjectInfo info = MicroProfileAssert.getDefaultMicroProfileProjectInfo();
        PropertyInfo property = MicroProfileProjectInfoTest.getProperty("%dev", info);
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)"dev", (Object)property.getProfile());
        Assert.assertNull((Object)property.getProperty());
        property = MicroProfileProjectInfoTest.getProperty("%dev.", info);
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)"dev", (Object)property.getProfile());
        Assert.assertNull((Object)property.getProperty());
    }

    @Test
    public void getPropertyWithProfile() {
        MicroProfileProjectInfo info = MicroProfileAssert.getDefaultMicroProfileProjectInfo();
        PropertyInfo property = MicroProfileProjectInfoTest.getProperty("%dev.quarkus.thread-pool.core-threads", info);
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)"dev", (Object)property.getProfile());
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.thread-pool.core-threads", (Object)property.getProperty().getName());
    }

    @Test
    public void getPropertyMapWithOneKey() {
        MicroProfileProjectInfo info = MicroProfileAssert.getDefaultMicroProfileProjectInfo();
        PropertyInfo property = MicroProfileProjectInfoTest.getProperty("quarkus.log.category.\"com.lordofthejars\".level", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.log.category.{*}.level", (Object)property.getProperty().getName());
        property = MicroProfileProjectInfoTest.getProperty("quarkus.log.category.com.level", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.log.category.{*}.level", (Object)property.getProperty().getName());
        property = MicroProfileProjectInfoTest.getProperty("quarkus.log.category.com\\\\.lordofthejars.level", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.log.category.{*}.level", (Object)property.getProperty().getName());
    }

    @Test
    @Ignore(value="Ignore this test since quarkus.keycloak.policy-enforcer.claim-information-point.{*}.{*}.{*} no longer exists")
    public void getPropertyMapWithThreeKeys() {
        MicroProfileProjectInfo info = MicroProfileAssert.getDefaultMicroProfileProjectInfo();
        PropertyInfo property = MicroProfileProjectInfoTest.getProperty("quarkus.keycloak.policy-enforcer.claim-information-point.foo.bar.zoo", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.claim-information-point.{*}.{*}.{*}", (Object)property.getProperty().getName());
        property = MicroProfileProjectInfoTest.getProperty("quarkus.keycloak.policy-enforcer.claim-information-point.foo.bar", info);
        Assert.assertNotNull((Object)property);
        property = MicroProfileProjectInfoTest.getProperty("quarkus.keycloak.policy-enforcer.paths.a.claim-information-point.b.c", info);
        Assert.assertNotNull((Object)property);
        Assert.assertNotNull((Object)property.getProperty());
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.paths.{*}.claim-information-point.{*}.{*}", (Object)property.getProperty().getName());
    }

    @Test
    public void simpleFormatPropertyForMarkdown() {
        String actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"quarkus.thread-pool.core-threads");
        Assert.assertEquals((Object)"quarkus.thread-pool.core-threads", (Object)actual);
    }

    @Test
    public void mapFormatPropertyForMarkdown() {
        String actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"quarkus.log.category.{*}.level");
        Assert.assertEquals((Object)"quarkus.log.category.\\{\\*\\}.level", (Object)actual);
        actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"quarkus.keycloak.credentials.jwt.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.credentials.jwt.\\{\\*\\}", (Object)actual);
        actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"quarkus.keycloak.policy-enforcer.claim-information-point.{*}.{*}.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.claim-information-point.\\{\\*\\}.\\{\\*\\}.\\{\\*\\}", (Object)actual);
        actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"quarkus.keycloak.policy-enforcer.paths.{*}.claim-information-point.{*}.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.paths.\\{\\*\\}.claim-information-point.\\{\\*\\}.\\{\\*\\}", (Object)actual);
    }

    @Test
    public void indexArrayFormatPropertyForMarkdown() {
        String actual = MicroProfilePropertiesUtils.formatPropertyForMarkdown((String)"kubernetes.labels[*].key");
        Assert.assertEquals((Object)"kubernetes.labels[\\*\\].key", (Object)actual);
    }

    @Test
    public void simpleFormatPropertyForCompletion() {
        MicroProfilePropertiesUtils.FormattedPropertyResult actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"quarkus.thread-pool.core-threads");
        Assert.assertEquals((Object)"quarkus.thread-pool.core-threads", (Object)actual.getPropertyName());
        Assert.assertEquals((long)0L, (long)actual.getParameterCount());
    }

    @Test
    public void mapFormatPropertyForCompletion() {
        MicroProfilePropertiesUtils.FormattedPropertyResult actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"quarkus.log.category.{*}.level");
        Assert.assertEquals((Object)"quarkus.log.category.${1:key}.level", (Object)actual.getPropertyName());
        Assert.assertEquals((long)1L, (long)actual.getParameterCount());
        actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"quarkus.keycloak.credentials.jwt.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.credentials.jwt.${1:key}", (Object)actual.getPropertyName());
        Assert.assertEquals((long)1L, (long)actual.getParameterCount());
        actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"quarkus.keycloak.policy-enforcer.claim-information-point.{*}.{*}.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.claim-information-point.${1:key}.${2:key}.${3:key}", (Object)actual.getPropertyName());
        Assert.assertEquals((long)3L, (long)actual.getParameterCount());
        actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"quarkus.keycloak.policy-enforcer.paths.{*}.claim-information-point.{*}.{*}");
        Assert.assertEquals((Object)"quarkus.keycloak.policy-enforcer.paths.${1:key}.claim-information-point.${2:key}.${3:key}", (Object)actual.getPropertyName());
        Assert.assertEquals((long)3L, (long)actual.getParameterCount());
    }

    @Test
    public void indexArrayFormatPropertyForCompletion() {
        MicroProfilePropertiesUtils.FormattedPropertyResult actual = MicroProfilePropertiesUtils.formatPropertyForCompletion((String)"kubernetes.labels[*].key");
        Assert.assertEquals((Object)"kubernetes.labels[${1:0}].key", (Object)actual.getPropertyName());
        Assert.assertEquals((long)1L, (long)actual.getParameterCount());
    }

    private static PropertyInfo getProperty(String text, MicroProfileProjectInfo info) {
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertyKey key = ((Property)model.getChildren().get(0)).getKey();
        return new PropertyInfo(MicroProfilePropertiesUtils.getProperty((String)key.getPropertyName(), (MicroProfileProjectInfo)info), key.getProfile());
    }
}

