/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.JavaTextDocumentSnippetRegistry;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import com.redhat.microprofile.ls.commons.snippets.Snippet;
import com.redhat.microprofile.ls.commons.snippets.SnippetRegistry;
import com.redhat.microprofile.snippets.SnippetContextForJava;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class JavaTextDocumentSnippetRegistryTest {
    private static JavaTextDocumentSnippetRegistry registry = new JavaTextDocumentSnippetRegistry();

    @Test
    public void haveJavaSnippets() {
        Assert.assertFalse((String)"Tests has MicroProfile Java snippets", (boolean)registry.getSnippets().isEmpty());
    }

    @Test
    public void mpMetricsSnippets() {
        Optional<Snippet> metricSnippet = JavaTextDocumentSnippetRegistryTest.findByPrefix("@Metric", (SnippetRegistry)registry);
        Assert.assertTrue((String)"Tests has @Metric Java snippets", (boolean)metricSnippet.isPresent());
        ISnippetContext context = metricSnippet.get().getContext();
        Assert.assertNotNull((String)"@Metric snippet has context", (Object)context);
        Assert.assertTrue((String)"@Metric snippet context is Java context", (boolean)(context instanceof SnippetContextForJava));
        ProjectLabelInfoEntry projectInfo = new ProjectLabelInfoEntry("", new ArrayList());
        boolean match = ((SnippetContextForJava)context).isMatch(projectInfo);
        Assert.assertFalse((String)"Project has no org.eclipse.microprofile.metrics.annotation.Metric type", (boolean)match);
        ProjectLabelInfoEntry projectInfo2 = new ProjectLabelInfoEntry("", Arrays.asList("org.eclipse.microprofile.metrics.annotation.Metric"));
        boolean match2 = ((SnippetContextForJava)context).isMatch(projectInfo2);
        Assert.assertTrue((String)"Project has org.eclipse.microprofile.metrics.annotation.Metric type", (boolean)match2);
    }

    @Test
    public void mpOpenAPISnippets() {
        Optional<Snippet> apiResponseSnippet = JavaTextDocumentSnippetRegistryTest.findByPrefix("@APIResponse", (SnippetRegistry)registry);
        Assert.assertTrue((String)"Tests has @APIResponse Java snippets", (boolean)apiResponseSnippet.isPresent());
        ISnippetContext context = apiResponseSnippet.get().getContext();
        Assert.assertNotNull((String)"@APIResponse snippet has context", (Object)context);
        Assert.assertTrue((String)"@APIResponse snippet context is Java context", (boolean)(context instanceof SnippetContextForJava));
        ProjectLabelInfoEntry projectInfo = new ProjectLabelInfoEntry("", new ArrayList());
        boolean match = ((SnippetContextForJava)context).isMatch(projectInfo);
        Assert.assertFalse((String)"Project has no org.eclipse.microprofile.openapi.annotations.responses.APIResponse type", (boolean)match);
        ProjectLabelInfoEntry projectInfo2 = new ProjectLabelInfoEntry("", Arrays.asList("org.eclipse.microprofile.openapi.annotations.responses.APIResponse"));
        boolean match2 = ((SnippetContextForJava)context).isMatch(projectInfo2);
        Assert.assertTrue((String)"Project has org.eclipse.microprofile.openapi.annotations.responses.APIResponse type", (boolean)match2);
    }

    @Test
    public void mpFaultToleranceSnippets() {
        Optional<Snippet> fallbackSnippet = JavaTextDocumentSnippetRegistryTest.findByPrefix("@Fallback", (SnippetRegistry)registry);
        Assert.assertTrue((String)"Tests has @Fallback Java snippets", (boolean)fallbackSnippet.isPresent());
        ISnippetContext context = fallbackSnippet.get().getContext();
        Assert.assertNotNull((String)"@Fallback snippet has context", (Object)context);
        Assert.assertTrue((String)"@Fallback snippet context is Java context", (boolean)(context instanceof SnippetContextForJava));
        ProjectLabelInfoEntry projectInfo = new ProjectLabelInfoEntry("", new ArrayList());
        boolean match = ((SnippetContextForJava)context).isMatch(projectInfo);
        Assert.assertFalse((String)"Project has no org.eclipse.microprofile.faulttolerance.Fallback type", (boolean)match);
        ProjectLabelInfoEntry projectInfo2 = new ProjectLabelInfoEntry("", Arrays.asList("org.eclipse.microprofile.faulttolerance.Fallback"));
        boolean match2 = ((SnippetContextForJava)context).isMatch(projectInfo2);
        Assert.assertTrue((String)"Project has org.eclipse.microprofile.faulttolerance.Fallback type", (boolean)match2);
    }

    private static Optional<Snippet> findByPrefix(String prefix, SnippetRegistry registry) {
        return registry.getSnippets().stream().filter(snippet -> snippet.getPrefixes().contains(prefix)).findFirst();
    }
}

