/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileJavaProjectLabelsParams;
import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.JavaTextDocuments;
import com.redhat.microprofile.ls.api.MicroProfileJavaProjectLabelsProvider;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.TextDocumentItem;
import org.junit.Assert;
import org.junit.Test;

public class JavaTextDocumentsTest {
    private static final boolean DEFAULT_VALUE = false;
    private static final String MP_PROJECT = "mp-project";
    private static final String NOMP_PROJECT = "nomp-project";
    private static MicroProfileJavaProjectLabelsProvider PROVIDER = new MicroProfileJavaProjectLabelsProvider(){

        public CompletableFuture<ProjectLabelInfoEntry> getJavaProjectlabels(MicroProfileJavaProjectLabelsParams javaParams) {
            String uri = javaParams.getUri();
            List<String> labels = null;
            if (uri.startsWith(JavaTextDocumentsTest.MP_PROJECT)) {
                labels = Arrays.asList("microprofile");
            }
            ProjectLabelInfoEntry projectInfo = new ProjectLabelInfoEntry(uri, labels);
            return CompletableFuture.completedFuture(projectInfo);
        }
    };

    @Test
    public void inMicroProfileProject() throws InterruptedException, ExecutionException {
        JavaTextDocuments documents = new JavaTextDocuments(PROVIDER);
        JavaTextDocuments.JavaTextDocument document1 = documents.createDocument(new TextDocumentItem("mp-project/file1.java", "", 0, ""));
        CompletableFuture result = document1.executeIfInMicroProfileProject(projectInfo -> CompletableFuture.completedFuture(true), (Object)false);
        Assert.assertTrue((String)"Test executed in a MicroProfile project", (boolean)((Boolean)result.get()));
    }

    @Test
    public void inNonMicroProfileProject() throws InterruptedException, ExecutionException {
        JavaTextDocuments documents = new JavaTextDocuments(PROVIDER);
        JavaTextDocuments.JavaTextDocument document1 = documents.createDocument(new TextDocumentItem("nomp-project/file1.java", "", 0, ""));
        CompletableFuture result = document1.executeIfInMicroProfileProject(projectInfo -> CompletableFuture.completedFuture(true), (Object)false);
        Assert.assertFalse((String)"Test executed in a non-MicroProfile project", (boolean)((Boolean)result.get()));
    }
}

