/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.metadata.ItemBase;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.MockMicroProfileLanguageClient;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.Assert;
import org.junit.Test;

public class MicroProfileLanguageServerScopeChangedTest {
    private static final String PROJECT1 = "project1";
    private static final String PROJECT1_APPLICATION_PROPERTIES = "project1/application.properties";
    private static final ItemMetadata property1FromJar = new ItemMetadata();
    private static final ItemMetadata property2FromJar;
    private static final ItemMetadata property1FromSources;
    private static final ItemMetadata property2FromSources;
    private static final ItemMetadata dynamicProperty1FromSources;
    private static final ItemMetadata dynamicProperty2FromSources;
    private static final ItemHint itemHintFromSources;

    @Test
    public void classpathChanged() throws InterruptedException, ExecutionException {
        MicroProfileLanguageServer server = MicroProfileLanguageServerScopeChangedTest.createServer();
        MockMicroProfileLanguageClient client = (MockMicroProfileLanguageClient)server.getLanguageClient();
        client.changedClasspath(PROJECT1, new ItemBase[]{property1FromJar, property2FromJar, property1FromSources});
        this.didOpen(PROJECT1_APPLICATION_PROPERTIES, server);
        CompletionList list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 3, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus.application.version", "quarkus.application.version=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("greeting.message", "greeting.message=", MicroProfileAssert.r(0, 0, 0)));
        client.changedClasspath(PROJECT1, new ItemBase[]{property1FromJar, property1FromSources});
        list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 2, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("greeting.message", "greeting.message=", MicroProfileAssert.r(0, 0, 0)));
        client.changedJavaSources(PROJECT1, new ItemBase[]{property2FromSources});
        list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 2, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("greeting.suffix", "greeting.suffix=", MicroProfileAssert.r(0, 0, 0)));
        client.changedJavaSources(PROJECT1, new ItemBase[]{dynamicProperty1FromSources, dynamicProperty2FromSources, itemHintFromSources});
        list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 5, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("org.acme.restclient.CountriesService/mp-rest/url", "org.acme.restclient.CountriesService/mp-rest/url=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("org.acme.restclient.CountriesService/mp-rest/scope", "org.acme.restclient.CountriesService/mp-rest/scope=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("configKey/mp-rest/url", "configKey/mp-rest/url=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("configKey/mp-rest/scope", "configKey/mp-rest/scope=", MicroProfileAssert.r(0, 0, 0)));
    }

    @Test
    public void javaSourcesChangedInThreadContext() throws InterruptedException, ExecutionException {
        MicroProfileLanguageServer server = MicroProfileLanguageServerScopeChangedTest.createServer();
        MockMicroProfileLanguageClient client = (MockMicroProfileLanguageClient)server.getLanguageClient();
        client.changedClasspath(PROJECT1, new ItemBase[]{property1FromJar, property2FromJar, property1FromSources});
        this.didOpen(PROJECT1_APPLICATION_PROPERTIES, server);
        CompletionList list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 3, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus.application.version", "quarkus.application.version=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("greeting.message", "greeting.message=", MicroProfileAssert.r(0, 0, 0)));
        client.changedClasspath(PROJECT1, new ItemBase[]{property1FromJar, property1FromSources});
        list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
        MicroProfileAssert.assertCompletions(list, 2, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("greeting.message", "greeting.message=", MicroProfileAssert.r(0, 0, 0)));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<Integer> count = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            Thread t1 = this.createChangedJavaSourcesThread(server, client);
            threads.add(t1);
            Thread t2 = this.createCompletionThread(server, client, count);
            threads.add(t2);
            t1.start();
            t2.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Integer max = (Integer)count.stream().max(Math::max).get();
        Assert.assertTrue((max <= 2 ? 1 : 0) != 0);
    }

    private Thread createCompletionThread(MicroProfileLanguageServer server, MockMicroProfileLanguageClient client, List<Integer> count) {
        return new Thread(() -> {
            try {
                CompletionList list = MicroProfileLanguageServerScopeChangedTest.completion(PROJECT1_APPLICATION_PROPERTIES, server);
                List list2 = count;
                synchronized (list2) {
                    count.add(list.getItems().size());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private Thread createChangedJavaSourcesThread(MicroProfileLanguageServer server, MockMicroProfileLanguageClient client) {
        return new Thread(() -> {
            try {
                client.changedJavaSources(PROJECT1, new ItemBase[]{property2FromSources});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static MicroProfileLanguageServer createServer() {
        MicroProfileLanguageServer languageServer = new MicroProfileLanguageServer();
        MockMicroProfileLanguageClient languageClient = new MockMicroProfileLanguageClient(languageServer);
        languageServer.setClient((LanguageClient)languageClient);
        return languageServer;
    }

    private void didOpen(String uri, MicroProfileLanguageServer server) {
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams();
        params.setTextDocument(new TextDocumentItem(uri, "", 1, ""));
        server.getTextDocumentService().didOpen(params);
    }

    private static CompletionList completion(String uri, MicroProfileLanguageServer server) throws InterruptedException, ExecutionException {
        CompletionParams params = new CompletionParams();
        params.setTextDocument(new TextDocumentIdentifier(uri));
        params.setPosition(new Position(0, 0));
        return (CompletionList)((Either)server.getTextDocumentService().completion(params).get()).getRight();
    }

    static {
        property1FromJar.setName("quarkus.application.name");
        property2FromJar = new ItemMetadata();
        property2FromJar.setName("quarkus.application.version");
        property1FromSources = new ItemMetadata();
        property1FromSources.setName("greeting.message");
        property1FromSources.setSource(Boolean.TRUE);
        property2FromSources = new ItemMetadata();
        property2FromSources.setName("greeting.suffix");
        property2FromSources.setSource(Boolean.TRUE);
        dynamicProperty1FromSources = new ItemMetadata();
        dynamicProperty1FromSources.setName("${mp.register.rest.client.class}/mp-rest/url");
        dynamicProperty1FromSources.setSource(Boolean.TRUE);
        dynamicProperty2FromSources = new ItemMetadata();
        dynamicProperty2FromSources.setName("${mp.register.rest.client.class}/mp-rest/scope");
        dynamicProperty2FromSources.setSource(Boolean.TRUE);
        itemHintFromSources = new ItemHint();
        itemHintFromSources.setName("${mp.register.rest.client.class}");
        itemHintFromSources.setValues(new ArrayList());
        ItemHint.ValueHint value = new ItemHint.ValueHint();
        value.setValue("org.acme.restclient.CountriesService");
        itemHintFromSources.getValues().add(value);
        value = new ItemHint.ValueHint();
        value.setValue("configKey");
        itemHintFromSources.getValues().add(value);
    }
}

