/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.MicroProfilePropertiesScope;
import com.redhat.microprofile.ls.MicroProfileProjectInfoCache;
import com.redhat.microprofile.ls.api.MicroProfileProjectInfoProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class MicroProfileProjectInfoCacheTest {
    private static final String PROJECT1 = "project1";
    private static final String PROJECT1_APPLICATION_PROPERTIES = "project1/application.properties";

    @Test
    public void getProjectInfoFromCache() throws InterruptedException, ExecutionException {
        CompletableFuture request2;
        MicroProfileProjectInfoProviderTracker tracker = new MicroProfileProjectInfoProviderTracker();
        MicroProfileProjectInfoCache cache = new MicroProfileProjectInfoCache((MicroProfileProjectInfoProvider)tracker);
        MicroProfileProjectInfoParams params = new MicroProfileProjectInfoParams(PROJECT1_APPLICATION_PROPERTIES);
        CompletableFuture request1 = cache.getProjectInfoFromCache(params);
        Assert.assertTrue((String)"Same futures for getProjectInfo in same time with 2 completion requests", (request1 == (request2 = cache.getProjectInfoFromCache(params)) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Same instances of getProjectInfo in same time with 2 completion requests", (request1.get() == request2.get() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of call of getProjectInfo in same time with 2 completion requests", (long)1L, (long)tracker.getInstanceCount());
        CompletableFuture request3 = cache.getProjectInfoFromCache(params);
        Assert.assertTrue((String)"Same futures for getProjectInfo in same time with 2 completion requests", (request1 == request3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Same instances of getProjectInfo in same time with 2 completion requests", (request1.get() == request3.get() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of call of getProjectInfo in same time with 2 completion requests", (long)1L, (long)tracker.getInstanceCount());
        MicroProfilePropertiesChangeEvent event = new MicroProfilePropertiesChangeEvent();
        event.setProjectURIs(new HashSet<String>(Arrays.asList(PROJECT1)));
        event.setType(MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        cache.propertiesChanged(event);
        CompletableFuture request4 = cache.getProjectInfoFromCache(params);
        Assert.assertFalse((String)"Different futures for getProjectInfo after propertiesChanged", (request1 == request4 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Different instance of getProjectInfo after propertiesChanged", (request1.get() == request4.get() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of call of getProjectInfo after propertiesChanged", (long)2L, (long)tracker.getInstanceCount());
    }

    @Test
    public void getProjectInfoCacheProviderException() throws InterruptedException, ExecutionException {
        MicroProfileProjectInfoProviderThrowException provider = new MicroProfileProjectInfoProviderThrowException();
        MicroProfileProjectInfoCache cache = new MicroProfileProjectInfoCache((MicroProfileProjectInfoProvider)provider);
        MicroProfileProjectInfoParamsThrowException params = new MicroProfileProjectInfoParamsThrowException("application.properties");
        params.setThrowError(true);
        CompletableFuture request = cache.getProjectInfo((MicroProfileProjectInfoParams)params);
        MicroProfileProjectInfo infoWithError = (MicroProfileProjectInfo)request.get();
        Assert.assertNotNull((String)"Project info after an error should be not null", (Object)infoWithError);
        Assert.assertTrue((String)"Project info after an error should have no project URI", (boolean)infoWithError.getProjectURI().isEmpty());
        params.setThrowError(false);
        request = cache.getProjectInfo((MicroProfileProjectInfoParams)params);
        MicroProfileProjectInfo infoWithNoError = (MicroProfileProjectInfo)request.get();
        Assert.assertNotNull((String)"Project info after an error should be not null", (Object)infoWithNoError);
        Assert.assertTrue((String)"Project info after an error should have a project URI", (!infoWithNoError.getProjectURI().isEmpty() ? 1 : 0) != 0);
    }

    public static class MicroProfileProjectInfoProviderThrowException
    implements MicroProfileProjectInfoProvider {
        public CompletableFuture<MicroProfileProjectInfo> getProjectInfo(MicroProfileProjectInfoParams params) {
            boolean throwError = ((MicroProfileProjectInfoParamsThrowException)params).isThrowError();
            if (throwError) {
                CompletableFuture<MicroProfileProjectInfo> completableFuture = new CompletableFuture<MicroProfileProjectInfo>();
                completableFuture.completeExceptionally(new UnsupportedOperationException());
                return completableFuture;
            }
            MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
            projectInfo.setProjectURI(MicroProfileProjectInfoCacheTest.PROJECT1);
            projectInfo.setProperties(new ArrayList());
            return CompletableFuture.completedFuture(projectInfo);
        }
    }

    static class MicroProfileProjectInfoParamsThrowException
    extends MicroProfileProjectInfoParams {
        private boolean throwError;

        public MicroProfileProjectInfoParamsThrowException(String uri) {
            super(uri);
        }

        public boolean isThrowError() {
            return this.throwError;
        }

        public void setThrowError(boolean throwError) {
            this.throwError = throwError;
        }
    }

    static class MicroProfileProjectInfoProviderTracker
    implements MicroProfileProjectInfoProvider {
        private final AtomicInteger instanceCount = new AtomicInteger();

        MicroProfileProjectInfoProviderTracker() {
        }

        public CompletableFuture<MicroProfileProjectInfo> getProjectInfo(MicroProfileProjectInfoParams params) {
            return CompletableFuture.supplyAsync(() -> {
                this.instanceCount.incrementAndGet();
                MicroProfileProjectInfo info = new MicroProfileProjectInfo();
                info.setProjectURI(params.getUri().substring(0, params.getUri().indexOf(47)));
                MicroProfileProjectInfo microProfileProjectInfo = info;
                synchronized (microProfileProjectInfo) {
                    try {
                        info.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return info;
            });
        }

        public int getInstanceCount() {
            return this.instanceCount.get();
        }
    }
}

