/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.MicroProfilePropertiesScope;
import com.redhat.microprofile.commons.MicroProfilePropertyDefinitionParams;
import com.redhat.microprofile.commons.metadata.ItemBase;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.MockMicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.ls.api.MicroProfileLanguageClientAPI;
import com.redhat.microprofile.ls.api.MicroProfilePropertyDefinitionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;

public class MockMicroProfileLanguageClient
implements MicroProfileLanguageClientAPI {
    private final MicroProfileLanguageServer languageServer;
    private final Map<String, List<ItemMetadata>> jarProperties;
    private final Map<String, List<ItemHint>> jarHints;
    private final Map<String, List<ItemMetadata>> sourcesProperties;
    private final Map<String, List<ItemHint>> sourcesHints;
    private MicroProfilePropertyDefinitionProvider provider;

    public MockMicroProfileLanguageClient(MicroProfileLanguageServer languageServer) {
        this.languageServer = languageServer;
        this.jarProperties = new HashMap<String, List<ItemMetadata>>();
        this.jarHints = new HashMap<String, List<ItemHint>>();
        this.sourcesProperties = new HashMap<String, List<ItemMetadata>>();
        this.sourcesHints = new HashMap<String, List<ItemHint>>();
    }

    public void telemetryEvent(Object object) {
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
    }

    public void showMessage(MessageParams messageParams) {
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return null;
    }

    public void logMessage(MessageParams message) {
    }

    public CompletableFuture<MicroProfileProjectInfo> getProjectInfo(MicroProfileProjectInfoParams params) {
        List<ItemHint> fromJars;
        List<ItemMetadata> fromJars2;
        MicroProfileProjectInfo info = new MicroProfileProjectInfo();
        String applicationPropertiesURI = params.getUri();
        String projectURI = applicationPropertiesURI.substring(0, applicationPropertiesURI.indexOf(47));
        info.setProjectURI(projectURI);
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        info.setProperties(properties);
        List<ItemMetadata> propertiesFromSources = this.sourcesProperties.get(projectURI);
        if (propertiesFromSources != null) {
            properties.addAll(propertiesFromSources);
        }
        if (params.getScopes().contains(MicroProfilePropertiesScope.dependencies) && (fromJars2 = this.jarProperties.get(projectURI)) != null) {
            properties.addAll(fromJars2);
        }
        ArrayList<ItemHint> hints = new ArrayList<ItemHint>();
        info.setHints(hints);
        List<ItemHint> hintsFromSources = this.sourcesHints.get(projectURI);
        if (hintsFromSources != null) {
            hints.addAll(hintsFromSources);
        }
        if (params.getScopes().contains(MicroProfilePropertiesScope.dependencies) && (fromJars = this.jarHints.get(projectURI)) != null) {
            hints.addAll(fromJars);
        }
        return CompletableFuture.completedFuture(info);
    }

    public void changedClasspath(String projectURI, ItemBase ... items) {
        List<ItemMetadata> propertiesFromSources = this.sourcesProperties.get(projectURI);
        if (propertiesFromSources != null) {
            propertiesFromSources.clear();
        } else {
            propertiesFromSources = new ArrayList<ItemMetadata>();
            this.sourcesProperties.put(projectURI, propertiesFromSources);
        }
        List<ItemHint> hintsFromSources = this.sourcesHints.get(projectURI);
        if (hintsFromSources != null) {
            hintsFromSources.clear();
        } else {
            hintsFromSources = new ArrayList<ItemHint>();
            this.sourcesHints.put(projectURI, hintsFromSources);
        }
        List<ItemMetadata> propertiesFromJars = this.jarProperties.get(projectURI);
        if (propertiesFromJars != null) {
            propertiesFromJars.clear();
        } else {
            propertiesFromJars = new ArrayList<ItemMetadata>();
            this.jarProperties.put(projectURI, propertiesFromJars);
        }
        List<ItemHint> hintsFromJars = this.jarHints.get(projectURI);
        if (hintsFromJars != null) {
            hintsFromJars.clear();
        } else {
            hintsFromJars = new ArrayList<ItemHint>();
            this.jarHints.put(projectURI, hintsFromJars);
        }
        for (ItemBase item : items) {
            if (item instanceof ItemMetadata) {
                if (!item.isBinary()) {
                    propertiesFromJars.add((ItemMetadata)item);
                    continue;
                }
                propertiesFromSources.add((ItemMetadata)item);
                continue;
            }
            if (!(item instanceof ItemHint)) continue;
            if (!item.isBinary()) {
                hintsFromJars.add((ItemHint)item);
                continue;
            }
            hintsFromSources.add((ItemHint)item);
        }
        MicroProfilePropertiesChangeEvent event = new MicroProfilePropertiesChangeEvent();
        event.setType(MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        event.setProjectURIs(new HashSet<String>(Arrays.asList(projectURI)));
        this.languageServer.propertiesChanged(event);
    }

    public void changedJavaSources(String projectURI, ItemBase ... items) {
        List<ItemMetadata> propertiesFromSources = this.sourcesProperties.get(projectURI);
        if (propertiesFromSources != null) {
            propertiesFromSources.clear();
        } else {
            propertiesFromSources = new ArrayList<ItemMetadata>();
            this.sourcesProperties.put(projectURI, propertiesFromSources);
        }
        List<ItemHint> hintsFromSources = this.sourcesHints.get(projectURI);
        if (hintsFromSources != null) {
            hintsFromSources.clear();
        } else {
            hintsFromSources = new ArrayList<ItemHint>();
            this.sourcesHints.put(projectURI, hintsFromSources);
        }
        for (ItemBase item : items) {
            if (item instanceof ItemMetadata) {
                propertiesFromSources.add((ItemMetadata)item);
                continue;
            }
            if (!(item instanceof ItemHint)) continue;
            hintsFromSources.add((ItemHint)item);
        }
        MicroProfilePropertiesChangeEvent event = new MicroProfilePropertiesChangeEvent();
        event.setType(MicroProfilePropertiesScope.ONLY_SOURCES);
        event.setProjectURIs(new HashSet<String>(Arrays.asList(projectURI)));
        this.languageServer.propertiesChanged(event);
    }

    public CompletableFuture<Location> getPropertyDefinition(MicroProfilePropertyDefinitionParams params) {
        if (this.provider == null) {
            this.provider = new MockMicroProfilePropertyDefinitionProvider();
        }
        return this.provider.getPropertyDefinition(params);
    }
}

