/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.google.gson.Gson;
import com.redhat.microprofile.commons.MicroProfilePropertyDefinitionParams;
import com.redhat.microprofile.ls.api.MicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;

public class MockMicroProfilePropertyDefinitionProvider
implements MicroProfilePropertyDefinitionProvider {
    private final Map<String, Location> cache = new HashMap<String, Location>();

    public MockMicroProfilePropertyDefinitionProvider() {
        PropertyDefinition[] definitions;
        for (PropertyDefinition propertyDefinition : definitions = (PropertyDefinition[])new Gson().fromJson((Reader)new InputStreamReader(MicroProfileAssert.class.getResourceAsStream("all-quarkus-definitions.json")), PropertyDefinition[].class)) {
            this.cache.put(MockMicroProfilePropertyDefinitionProvider.getKey(propertyDefinition), propertyDefinition.getLocation());
        }
    }

    public CompletableFuture<Location> getPropertyDefinition(MicroProfilePropertyDefinitionParams params) {
        return CompletableFuture.completedFuture(this.cache.get(MockMicroProfilePropertyDefinitionProvider.getKey(params)));
    }

    private static String getKey(MicroProfilePropertyDefinitionParams params) {
        return params.getSourceType() + "#" + params.getSourceField() + "#" + params.getSourceMethod();
    }

    private static class PropertyDefinition
    extends MicroProfilePropertyDefinitionParams {
        private Location location;

        private PropertyDefinition() {
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

