/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons.snippets;

import com.redhat.microprofile.ls.commons.snippets.Snippet;
import com.redhat.microprofile.ls.commons.snippets.SnippetRegistry;
import com.redhat.microprofile.ls.commons.snippets.TextDocumentSnippetRegistry;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.Assert;
import org.junit.Test;

public class SnippetRegistryTest {
    @Test
    public void prefixWithString() throws IOException {
        String content = "{\r\n  \"@Metric\": {\r\n    \"prefix\": \"@Metric\",\r\n    \"body\": [\r\n      \"@Metric(\",\r\n      \"\\tname = \\\"${1:name}\\\",\",\r\n      \"\\tdescription = \\\"${2:description}\\\"\",\r\n      \")\"\r\n    ],\r\n    \"description\": \"An annotation that contains the metadata information when requesting a metric to be injected or produced. This annotation can be used on fields of type Meter, Timer, Counter, and Histogram. For Gauge, the @Metric annotation can only be used on producer methods/fields.\"\r\n  }\r\n  }";
        SnippetRegistry registry = new SnippetRegistry();
        registry.registerSnippets((Reader)new StringReader(content));
        Assert.assertEquals((long)1L, (long)registry.getSnippets().size());
    }

    @Test
    public void prefixWithArray() throws IOException {
        String content = "{\r\n  \"@Metric\": {\r\n    \"prefix\": [\r\n      \"@Metric\"\r\n    ],\r\n    \"body\": [\r\n      \"@Metric(\",\r\n      \"\\tname = \\\"${1:name}\\\",\",\r\n      \"\\tdescription = \\\"${2:description}\\\"\",\r\n      \")\"\r\n    ],\r\n    \"description\": \"An annotation that contains the metadata information when requesting a metric to be injected or produced. This annotation can be used on fields of type Meter, Timer, Counter, and Histogram. For Gauge, the @Metric annotation can only be used on producer methods/fields.\"\r\n  }\r\n  }";
        SnippetRegistry registry = new SnippetRegistry();
        registry.registerSnippets((Reader)new StringReader(content));
        Assert.assertEquals((long)1L, (long)registry.getSnippets().size());
    }

    @Test
    public void applyCompletion() {
        TextDocumentSnippetRegistry registry = new TextDocumentSnippetRegistry();
        Snippet snippet = new Snippet();
        snippet.setPrefixes(Arrays.asList("mp"));
        snippet.setBody(Arrays.asList("a", "\tb", "c"));
        registry.registerSnippet(snippet);
        String ls = System.lineSeparator();
        String expected = "a" + ls + "\tb" + ls + "c";
        MicroProfileAssert.assertCompletion("|", 1, registry, MicroProfileAssert.c("mp", expected, MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.assertCompletion(" |", 1, registry, MicroProfileAssert.c("mp", expected, MicroProfileAssert.r(0, 1, 1)));
    }

    @Test
    public void applyCompletionWithIndent() throws IOException {
        String content = "{\r\n\t\"Quarkus - new native test resource class\": {\r\n\t\t\"prefix\": \"qntrc\",\r\n\t\t\"body\": [\r\n\t\t\t\"package ${1:packagename};\",\r\n\t\t\t\"\",\r\n\t\t\t\"import io.quarkus.test.junit.SubstrateTest;\",\r\n\t\t\t\"\",\r\n\t\t\t\"@SubstrateTest\",\r\n\t\t\t\"public class ${TM_FILENAME_BASE} extends ${2:${TM_FILENAME_BASE/^Native(.*)IT/$1/}Test} {\",\r\n\t\t\t\"\",\r\n\t\t\t\"\\t// Execute the same tests, but in native mode.\",\r\n\t\t\t\"}\"\r\n\t\t],\r\n\t\t\"description\": \"Quarkus native test resource class\"\r\n\t}\r\n}";
        TextDocumentSnippetRegistry registry = new TextDocumentSnippetRegistry();
        registry.registerSnippets((Reader)new StringReader(content));
        String ls = System.lineSeparator();
        String expected = "package ${1:packagename};" + ls + "" + ls + "import io.quarkus.test.junit.SubstrateTest;" + ls + "" + ls + "@SubstrateTest" + ls + "public class ${TM_FILENAME_BASE} extends ${2:${TM_FILENAME_BASE/^Native(.*)IT/$1/}Test} {" + ls + "" + ls + "\t// Execute the same tests, but in native mode." + ls + "}";
        MicroProfileAssert.assertCompletion("|", registry, MicroProfileAssert.c("qntrc", expected, MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.assertCompletion(" |", registry, MicroProfileAssert.c("qntrc", expected, MicroProfileAssert.r(0, 1, 1)));
    }

    @Test
    public void prefixCompletion() {
        TextDocumentSnippetRegistry registry = new TextDocumentSnippetRegistry();
        Snippet snippet = new Snippet();
        snippet.setPrefixes(Arrays.asList("mp"));
        registry.registerSnippet(snippet);
        snippet = new Snippet();
        snippet.setPrefixes(Arrays.asList("quarkus"));
        registry.registerSnippet(snippet);
        MicroProfileAssert.assertCompletion("|", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.assertCompletion("| ", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.assertCompletion(" | ", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 1, 1)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 1, 1)));
        MicroProfileAssert.assertCompletion(" |", registry, new CompletionItem[0]);
        MicroProfileAssert.assertCompletion("abcd|", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 0, 4)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 0, 4)));
        MicroProfileAssert.assertCompletion("abcd |", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 5, 5)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 5, 5)));
        MicroProfileAssert.assertCompletion("m |", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 2, 2)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 2, 2)));
        MicroProfileAssert.assertCompletion("m|", registry, MicroProfileAssert.c("mp", "", MicroProfileAssert.r(0, 0, 1)), MicroProfileAssert.c("quarkus", "", MicroProfileAssert.r(0, 0, 1)));
    }
}

