/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.parser;

import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesModelTest {
    @Test
    public void parseCommentsAndTwoProperties() {
        String text = " # comment \na = b\n c=d";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 3);
        Node comments = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertComments(comments, 1, 11, "# comment ");
        Node firstPropertyNode = (Node)model.getChildren().get(1);
        PropertiesModelTest.assertProperty(firstPropertyNode, 12, 17, 12, 13, "a", 14, 16, 17, "b");
        Node secondPropertyNode = (Node)model.getChildren().get(2);
        PropertiesModelTest.assertProperty(secondPropertyNode, 19, 22, 19, 20, "c", 20, 21, 22, "d");
    }

    @Test
    public void parsePropertyWithoutAssign() {
        String text = " a";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        Node firstPropertyNode = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(firstPropertyNode, 1, 2, 1, 2, "a", -1, -1, -1, null);
    }

    @Test
    public void parsePropertyValueWithPoundSign() {
        String text = "a = value # value";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        Node firstPropertyNode = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(firstPropertyNode, 0, 17, 0, 1, "a", 2, 4, 17, "value # value");
    }

    @Test
    public void parsePropertyWithoutValue() {
        String text = " a=";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        Node firstPropertyNode = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(firstPropertyNode, 1, 3, 1, 2, "a", 2, -1, -1, null);
    }

    @Test
    public void parseMultiPropertyKey() {
        String text = "quarkus\\\n.application\\\n.name=name";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        Node property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 33, 0, 28, "quarkus.application.name", 28, 29, 33, "name");
    }

    @Test
    public void parseMultiPropertyValue() {
        String text = "mp.openapi.schema.java.util.Date = { \\\n  \"name\": \"EpochMillis\" \\\n  \"type\": \"number\", \\\n  \"format\": \"int64\", \\\n  \"description\": \"Milliseconds since January 1, 1970, 00:00:00 GMT\" \\\n}\nquarkus.http.port=9090";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 2);
        Node firstProperty = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(firstProperty, 0, 181, 0, 32, "mp.openapi.schema.java.util.Date", 33, 35, 181, "{ \"name\": \"EpochMillis\" \"type\": \"number\", \"format\": \"int64\", \"description\": \"Milliseconds since January 1, 1970, 00:00:00 GMT\" }");
        Node secondProperty = (Node)model.getChildren().get(1);
        PropertiesModelTest.assertProperty(secondProperty, 182, 204, 182, 199, "quarkus.http.port", 199, 200, 204, "9090");
    }

    @Test
    public void parseMultiPropertyValueLeadingSpaces() {
        String text = "a = hello \\\nhow \\\nare \\\nyou?";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        Node property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 28, 0, 1, "a", 2, 4, 28, "hello how are you?");
        text = "a = hello \\\n      how \\\n   are \\\n      you?";
        model = PropertiesModel.parse((String)text, (String)"application.properties");
        property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 43, 0, 1, "a", 2, 4, 43, "hello how are you?");
    }

    @Test
    public void parseMultiPropertyKeyAndValue() {
        String text = "mp\\\n.openapi\\\n.schema.java.util.Date = { \\\n  \"name\": \"EpochMillis\" \\\n  \"type\": \"number\", \\\n  \"format\": \"int64\", \\\n  \"description\": \"Milliseconds since January 1, 1970, 00:00:00 GMT\" \\\n}\nquarkus.http.port=9090";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 2);
        Node firstProperty = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(firstProperty, 0, 185, 0, 36, "mp.openapi.schema.java.util.Date", 37, 39, 185, "{ \"name\": \"EpochMillis\" \"type\": \"number\", \"format\": \"int64\", \"description\": \"Milliseconds since January 1, 1970, 00:00:00 GMT\" }");
        Node secondProperty = (Node)model.getChildren().get(1);
        PropertiesModelTest.assertProperty(secondProperty, 186, 208, 186, 203, "quarkus.http.port", 203, 204, 208, "9090");
    }

    @Test
    public void parseSpaceAfterBackSlash() {
        String text = "greeting.\\ \r\n             message = hello\r\ngreeting.name = quarkus";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 3);
        Node property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 11, 0, 10, "greeting.\\", -1, -1, -1, null);
        property = (Node)model.getChildren().get(1);
        PropertiesModelTest.assertProperty(property, 26, 41, 26, 33, "message", 34, 36, 41, "hello");
        property = (Node)model.getChildren().get(2);
        PropertiesModelTest.assertProperty(property, 43, 66, 43, 56, "greeting.name", 57, 59, 66, "quarkus");
    }

    @Test
    public void parseSpaceAfterBackSlash2() {
        String text = "quarkus\\  \n.application\\ \n.name=name";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 3);
        Node property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 10, 0, 8, "quarkus\\", -1, -1, -1, null);
        property = (Node)model.getChildren().get(1);
        PropertiesModelTest.assertProperty(property, 11, 25, 11, 24, ".application\\", -1, -1, -1, null);
        property = (Node)model.getChildren().get(2);
        PropertiesModelTest.assertProperty(property, 26, 36, 26, 31, ".name", 31, 32, 36, "name");
    }

    @Test
    public void parseEndWithBackSlash() {
        String text = "mp.opentracing.server.skip\\";
        PropertiesModel model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        Node property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 27, 0, 27, "mp.opentracing.server.skip\\", -1, -1, -1, null);
        text = "mp.opentracing.server.skip-pattern=\\";
        model = PropertiesModel.parse((String)text, (String)"application.properties");
        PropertiesModelTest.assertModel((Node)model, text.length(), 1);
        property = (Node)model.getChildren().get(0);
        PropertiesModelTest.assertProperty(property, 0, 36, 0, 34, "mp.opentracing.server.skip-pattern", 34, 35, 36, "\\");
    }

    private static void assertComments(Node comments, int expectedStart, int expectedEnd, String expectedText) {
        Assert.assertEquals((Object)comments.getNodeType(), (Object)Node.NodeType.COMMENTS);
        Assert.assertEquals((Object)expectedText, (Object)comments.getText());
        Assert.assertEquals((long)expectedStart, (long)comments.getStart());
        Assert.assertEquals((long)expectedEnd, (long)comments.getEnd());
    }

    private static void assertProperty(Node propertyNode, int expectedStart, int expectedEnd, int expectedStartKey, int expectedEndKey, String expectedTextKey, int expectedDelimiterAssign, int expectedStartValue, int expectedEndValue, String expectedTextValue) {
        Assert.assertEquals((Object)propertyNode.getNodeType(), (Object)Node.NodeType.PROPERTY);
        Property property = (Property)propertyNode;
        Assert.assertEquals((long)expectedStart, (long)property.getStart());
        Assert.assertEquals((long)expectedEnd, (long)property.getEnd());
        PropertyKey propertyKey = property.getKey();
        if (expectedStartKey == -1) {
            Assert.assertNull((Object)propertyKey);
        } else {
            Assert.assertNotNull((Object)propertyKey);
            Assert.assertEquals((long)expectedStartKey, (long)propertyKey.getStart());
            Assert.assertEquals((long)expectedEndKey, (long)propertyKey.getEnd());
            Assert.assertEquals((Object)expectedTextKey, (Object)propertyKey.getText(true));
        }
        Node delemiterAssign = property.getDelimiterAssign();
        if (expectedDelimiterAssign == -1) {
            Assert.assertNull((Object)delemiterAssign);
        } else {
            Assert.assertNotNull((Object)delemiterAssign);
            Assert.assertEquals((long)expectedDelimiterAssign, (long)delemiterAssign.getStart());
        }
        PropertyValue propertyValue = property.getValue();
        if (expectedStartValue == -1) {
            Assert.assertNull((Object)propertyValue);
        } else {
            Assert.assertNotNull((Object)propertyValue);
            Assert.assertEquals((long)expectedStartValue, (long)propertyValue.getStart());
            Assert.assertEquals((long)expectedEndValue, (long)propertyValue.getEnd());
            Assert.assertEquals((Object)expectedTextValue, (Object)propertyValue.getText(true));
        }
    }

    private static void assertModel(Node model, int expectedEnd, int expectedChildren) {
        Node.NodeType expectedNodeType = Node.NodeType.DOCUMENT;
        int expectedStart = 0;
        Assert.assertEquals((Object)expectedNodeType, (Object)model.getNodeType());
        Assert.assertEquals((long)expectedStart, (long)model.getStart());
        Assert.assertEquals((long)expectedEnd, (long)model.getEnd());
        Assert.assertEquals((long)expectedChildren, (long)model.getChildren().size());
    }
}

