/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.client.ConfigurationItemEdit;
import com.redhat.microprofile.ls.commons.client.ConfigurationItemEditType;
import com.redhat.microprofile.services.MicroProfileAssert;
import com.redhat.microprofile.services.ValidationType;
import java.util.Arrays;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.Test;

public class ApplicationPropertiesCodeActionsTest {
    @Test
    public void codeActionsForUnknownProperties() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.application.nme=X\n\n";
        Diagnostic d = MicroProfileAssert.d(1, 0, 23, "Unknown property 'quarkus.application.nme'", DiagnosticSeverity.Warning, ValidationType.unknown);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'quarkus.application.name' ?", MicroProfileAssert.te(1, 0, 1, 23, "quarkus.application.name"), d), this.caAddToExcluded("quarkus.application.nme", d), this.caAddToExcluded("quarkus.application.*", d));
    }

    @Test
    public void codeActionsForUnknownPropertiesParentKey() throws BadLocationException {
        String value = "abcdefghij.group=myUser\nabcdefghij.registry=http://my.docker-registry.net\nabcdefghij.labels[0].key=foo\nabcdefghij.labels[0].value=bar\nabcdefghij.readiness-probe.initial-delay-seconds=20\nabcdefghij.readiness-probe.period-seconds=45";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 16, "Unknown property 'abcdefghij.group'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d2 = MicroProfileAssert.d(1, 0, 19, "Unknown property 'abcdefghij.registry'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d3 = MicroProfileAssert.d(2, 0, 24, "Unknown property 'abcdefghij.labels[0].key'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d4 = MicroProfileAssert.d(3, 0, 26, "Unknown property 'abcdefghij.labels[0].value'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d5 = MicroProfileAssert.d(4, 0, 48, "Unknown property 'abcdefghij.readiness-probe.initial-delay-seconds'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d6 = MicroProfileAssert.d(5, 0, 41, "Unknown property 'abcdefghij.readiness-probe.period-seconds'", DiagnosticSeverity.Warning, ValidationType.unknown);
        MicroProfileAssert.testDiagnosticsFor(value, d1, d2, d3, d4, d5, d6);
        MicroProfileAssert.testCodeActionsFor(value, d1, this.caAddToExcluded("abcdefghij.group", d1), this.caAddToExcluded("abcdefghij.*", d1));
        MicroProfileAssert.testCodeActionsFor(value, d2, this.caAddToExcluded("abcdefghij.registry", d2), this.caAddToExcluded("abcdefghij.*", d2));
        MicroProfileAssert.testCodeActionsFor(value, d3, this.caAddToExcluded("abcdefghij.labels[0].key", d3), this.caAddToExcluded("abcdefghij.labels[0].*", d3), this.caAddToExcluded("abcdefghij.*", d3));
        MicroProfileAssert.testCodeActionsFor(value, d4, this.caAddToExcluded("abcdefghij.labels[0].value", d4), this.caAddToExcluded("abcdefghij.labels[0].*", d4), this.caAddToExcluded("abcdefghij.*", d4));
        MicroProfileAssert.testCodeActionsFor(value, d5, this.caAddToExcluded("abcdefghij.readiness-probe.initial-delay-seconds", d5), this.caAddToExcluded("abcdefghij.readiness-probe.*", d5), this.caAddToExcluded("abcdefghij.*", d5));
        MicroProfileAssert.testCodeActionsFor(value, d6, this.caAddToExcluded("abcdefghij.readiness-probe.period-seconds", d6), this.caAddToExcluded("abcdefghij.readiness-probe.*", d6), this.caAddToExcluded("abcdefghij.*", d6));
    }

    @Test
    public void codeActionsForUnknownPropertiesParentKey2() throws BadLocationException {
        String value = "a.b.c.d=123\na.c.d=123";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 7, "Unknown property 'a.b.c.d'", DiagnosticSeverity.Warning, ValidationType.unknown);
        Diagnostic d2 = MicroProfileAssert.d(1, 0, 5, "Unknown property 'a.c.d'", DiagnosticSeverity.Warning, ValidationType.unknown);
        MicroProfileAssert.testDiagnosticsFor(value, d1, d2);
        MicroProfileAssert.testCodeActionsFor(value, d1, this.caAddToExcluded("a.b.c.d", d1), this.caAddToExcluded("a.b.c.*", d1), this.caAddToExcluded("a.b.*", d1), this.caAddToExcluded("a.*", d1));
        MicroProfileAssert.testCodeActionsFor(value, d2, this.caAddToExcluded("a.c.d", d2), this.caAddToExcluded("a.c.*", d2), this.caAddToExcluded("a.*", d2));
    }

    @Test
    public void codeActionsForUnknownPropertiesParentKey3() throws BadLocationException {
        String value = "quarkus.a.b.c.d=123";
        Diagnostic d = MicroProfileAssert.d(0, 0, 15, "Unknown property 'quarkus.a.b.c.d'", DiagnosticSeverity.Warning, ValidationType.unknown);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, this.caAddToExcluded("quarkus.a.b.c.d", d), this.caAddToExcluded("quarkus.a.b.c.*", d), this.caAddToExcluded("quarkus.a.b.*", d), this.caAddToExcluded("quarkus.a.*", d));
    }

    @Test
    public void codeActionsForUnknownPropertiesParentKey4() throws BadLocationException {
        String value = "a.b.c.d=123";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 7, "Unknown property 'a.b.c.d'", DiagnosticSeverity.Warning, ValidationType.unknown);
        MicroProfileAssert.testDiagnosticsFor(value, d1);
        MicroProfileAssert.testCodeActionsFor(value, d1, this.caAddToExcluded("a.b.c.d", d1), this.caAddToExcluded("a.b.c.*", d1), this.caAddToExcluded("a.b.*", d1), this.caAddToExcluded("a.*", d1));
    }

    @Test
    public void codeActionsForUnknownLogLevelValue() throws BadLocationException {
        String value = "quarkus.log.level=WARNIN";
        Diagnostic d = MicroProfileAssert.d(0, 18, 24, "Invalid enum value: 'WARNIN' is invalid for type java.util.logging.Level", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'WARNING'?", MicroProfileAssert.te(0, 18, 0, 24, "WARNING"), d));
    }

    @Test
    public void codeActionsForUnknownLogLevelStartsWith() throws BadLocationException {
        String value = "quarkus.log.level=F";
        Diagnostic d = MicroProfileAssert.d(0, 18, 19, "Invalid enum value: 'F' is invalid for type java.util.logging.Level", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'FINE'?", MicroProfileAssert.te(0, 18, 0, 19, "FINE"), d), MicroProfileAssert.ca("Did you mean 'FINER'?", MicroProfileAssert.te(0, 18, 0, 19, "FINER"), d), MicroProfileAssert.ca("Did you mean 'FINEST'?", MicroProfileAssert.te(0, 18, 0, 19, "FINEST"), d));
    }

    @Test
    public void codeActionsForUnknownLogLevelValueMappedProperty() throws BadLocationException {
        String value = "quarkus.log.category.\"org.acme\".level=WARNIN";
        Diagnostic d = MicroProfileAssert.d(0, 38, 44, "Invalid enum value: 'WARNIN' is invalid for type io.quarkus.runtime.logging.InheritableLevel", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'WARNING'?", MicroProfileAssert.te(0, 38, 0, 44, "WARNING"), d));
    }

    @Test
    public void codeActionsForUnknownEnum() throws BadLocationException {
        String value = "quarkus.log.syslog.async.overflow=BLACK";
        Diagnostic d = MicroProfileAssert.d(0, 34, 39, "Invalid enum value: 'BLACK' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'BLOCK'?", MicroProfileAssert.te(0, 34, 0, 39, "BLOCK"), d));
    }

    @Test
    public void codeActionsForUnknownEnumStartsWith() throws BadLocationException {
        String value = "quarkus.log.syslog.async.overflow=B";
        Diagnostic d = MicroProfileAssert.d(0, 34, 35, "Invalid enum value: 'B' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'BLOCK'?", MicroProfileAssert.te(0, 34, 0, 35, "BLOCK"), d));
        value = "quarkus.log.syslog.async.overflow=b";
        d = MicroProfileAssert.d(0, 34, 35, "Invalid enum value: 'b' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'block'?", MicroProfileAssert.te(0, 34, 0, 35, "block"), d));
    }

    @Test
    public void codeActionsForUnknownBoolean() throws BadLocationException {
        String value = "quarkus.http.cors=fals";
        Diagnostic d = MicroProfileAssert.d(0, 18, 22, "Type mismatch: boolean expected", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Did you mean 'false'?", MicroProfileAssert.te(0, 18, 0, 22, "false"), d));
    }

    @Test
    public void codeActionsForReplaceUnknown() throws BadLocationException {
        String value = "quarkus.log.syslog.async.overflow=unknown-value";
        Diagnostic d = MicroProfileAssert.d(0, 34, 47, "Invalid enum value: 'unknown-value' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value);
        MicroProfileAssert.testDiagnosticsFor(value, d);
        MicroProfileAssert.testCodeActionsFor(value, d, MicroProfileAssert.ca("Replace with 'block'?", MicroProfileAssert.te(0, 34, 0, 47, "block"), d), MicroProfileAssert.ca("Replace with 'discard'?", MicroProfileAssert.te(0, 34, 0, 47, "discard"), d));
    }

    private CodeAction caAddToExcluded(String item, Diagnostic diagnostic) {
        ConfigurationItemEdit configItemEdit = new ConfigurationItemEdit("quarkus.tools.validation.unknown.excluded", ConfigurationItemEditType.add, (Object)item);
        Command command = new Command("Add " + item + " to unknown excluded array", "quarkus.command.configuration.update", Arrays.asList(configItemEdit));
        return MicroProfileAssert.ca("Exclude '" + item + "' from unknown property validation?", command, diagnostic);
    }
}

