/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.util.ArrayList;
import org.junit.Test;

public class ApplicationPropertiesCompletionTest {
    @Test
    public void completionOnComments() throws BadLocationException {
        String value = "#|";
        MicroProfileAssert.testCompletionFor(value, true, 0);
        value = " #|";
        MicroProfileAssert.testCompletionFor(value, true, 0);
    }

    @Test
    public void completionOnKey() throws BadLocationException {
        String value = "|";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=false", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=${1|false,true|}", MicroProfileAssert.r(0, 0, 0)));
        value = " |";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=false", MicroProfileAssert.r(0, 0, 1)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=${1|false,true|}", MicroProfileAssert.r(0, 0, 1)));
        value = " quarkus.http.co|rs = ";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=false", MicroProfileAssert.r(0, 0, 21)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=${1|false,true|}", MicroProfileAssert.r(0, 0, 21)));
        value = " quarkus.application.name =| ";
        MicroProfileAssert.testCompletionFor(value, true, 0);
    }

    @Test
    public void completionOnKeyMap() throws BadLocationException {
        String value = "quarkus.log.category|";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.log.category.{*}.level", "quarkus.log.category.{*}.level=inherit", MicroProfileAssert.r(0, 0, 20)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.log.category.{*}.level", "quarkus.log.category.${1:key}.level=${2|DEBUG,ERROR,OFF,SEVERE,WARNING,INFO,CONFIG,FINE,FINER,FINEST,ALL|}", MicroProfileAssert.r(0, 0, 20)));
    }

    @Test
    public void completionOnEmptyLine() throws BadLocationException {
        String value = "quarkus.application.name= \r\n|\r\nquarkus.application.version= ";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.log.category.{*}.level", "quarkus.log.category.{*}.level=inherit", MicroProfileAssert.r(1, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.log.category.{*}.level", "quarkus.log.category.${1:key}.level=${2|DEBUG,ERROR,OFF,SEVERE,WARNING,INFO,CONFIG,FINE,FINER,FINEST,ALL|}", MicroProfileAssert.r(1, 0, 0)));
    }

    @Test
    public void completionOnValueNoCompletionItems() throws BadLocationException {
        String value = "quarkus.application.name = | ";
        MicroProfileAssert.testCompletionFor(value, true, 0);
    }

    @Test
    public void completionOnValueOnAssign() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=| ";
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("block", "block", MicroProfileAssert.r(0, 35, 36)), MicroProfileAssert.c("discard", "discard", MicroProfileAssert.r(0, 35, 36)));
    }

    @Test
    public void completionOnValueOnPropertyValue() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=BLO| ";
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("block", "block", MicroProfileAssert.r(0, 35, 39)));
    }

    @Test
    public void completionOnValueBetweenPropertyValue() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=B|L";
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("block", "block", MicroProfileAssert.r(0, 35, 37)));
    }

    @Test
    public void completionOnKeyWithEnums() throws BadLocationException {
        String value = "|";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.log.console.async.overflow", "quarkus.log.console.async.overflow=block", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.log.console.async.overflow", "quarkus.log.console.async.overflow=${1|block,discard|}", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.datasource.enable-metrics", "quarkus.datasource.enable-metrics=false", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.datasource.enable-metrics", "quarkus.datasource.enable-metrics=${1|false,true|}", MicroProfileAssert.r(0, 0, 0)));
    }

    @Test
    public void completionOnValueWithEnumsKebabCase() throws BadLocationException {
        String value = "quarkus.datasource.transaction-isolation-level=|";
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("undefined", "undefined", MicroProfileAssert.r(0, 47, 47)), MicroProfileAssert.c("none", "none", MicroProfileAssert.r(0, 47, 47)), MicroProfileAssert.c("read-uncommitted", "read-uncommitted", MicroProfileAssert.r(0, 47, 47)), MicroProfileAssert.c("read-committed", "read-committed", MicroProfileAssert.r(0, 47, 47)), MicroProfileAssert.c("repeatable-read", "repeatable-read", MicroProfileAssert.r(0, 47, 47)), MicroProfileAssert.c("serializable", "serializable", MicroProfileAssert.r(0, 47, 47)));
    }

    @Test
    public void completionOnProfile() throws BadLocationException {
        String value = "%|";
        MicroProfileAssert.testCompletionFor(value, true, 3, MicroProfileAssert.c("dev", "%dev", MicroProfileAssert.r(0, 0, 1), "dev" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator()), MicroProfileAssert.c("prod", "%prod", MicroProfileAssert.r(0, 0, 1), "prod" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator()), MicroProfileAssert.c("test", "%test", MicroProfileAssert.r(0, 0, 1), "test" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator()));
        value = "%st|\n%staging.property=123";
        MicroProfileAssert.testCompletionFor(value, true, 4, MicroProfileAssert.c("staging", "%staging", MicroProfileAssert.r(0, 0, 3)), MicroProfileAssert.c("dev", "%dev", MicroProfileAssert.r(0, 0, 3), "dev" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator()), MicroProfileAssert.c("prod", "%prod", MicroProfileAssert.r(0, 0, 3), "prod" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator()), MicroProfileAssert.c("test", "%test", MicroProfileAssert.r(0, 0, 3), "test" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator()));
        value = "%staging|.";
        MicroProfileAssert.testCompletionFor(value, true, 3, MicroProfileAssert.c("dev", "%dev", MicroProfileAssert.r(0, 0, 8), "dev" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator()), MicroProfileAssert.c("prod", "%prod", MicroProfileAssert.r(0, 0, 8), "prod" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator()), MicroProfileAssert.c("test", "%test", MicroProfileAssert.r(0, 0, 8), "test" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator()));
    }

    @Test
    public void completionOnProfileWithPropertyName() throws BadLocationException {
        String value = "%pr|quarkus.application.name";
        MicroProfileAssert.testCompletionFor(value, true, 3, MicroProfileAssert.c("dev", "%dev.", MicroProfileAssert.r(0, 0, 3), "dev" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator()), MicroProfileAssert.c("prod", "%prod.", MicroProfileAssert.r(0, 0, 3), "prod" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator()), MicroProfileAssert.c("test", "%test.", MicroProfileAssert.r(0, 0, 3), "test" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator()));
        value = "%d|.quarkus.application.name";
        MicroProfileAssert.testCompletionFor(value, true, 3, MicroProfileAssert.c("dev", "%dev", MicroProfileAssert.r(0, 0, 2), "dev" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator()), MicroProfileAssert.c("prod", "%prod", MicroProfileAssert.r(0, 0, 2), "prod" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator()), MicroProfileAssert.c("test", "%test", MicroProfileAssert.r(0, 0, 2), "test" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator()));
    }

    @Test
    public void completionAfterProfile() throws BadLocationException {
        String value = "%dev.|";
        MicroProfileAssert.testCompletionFor(value, false, MicroProfileAssert.c("quarkus.http.cors", "%dev.quarkus.http.cors=false", MicroProfileAssert.r(0, 0, 5)));
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("quarkus.http.cors", "%dev.quarkus.http.cors=${1|false,true|}", MicroProfileAssert.r(0, 0, 5)));
    }

    @Test
    public void noCompletionForExistingProperties() throws BadLocationException {
        String value = "|";
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.http.cors");
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.application.name");
        properties.add(p2);
        projectInfo.setProperties(properties);
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)2, projectInfo, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)));
        value = "quarkus.http.cors=false\r\n|";
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)1, projectInfo, MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(1, 0, 0)));
    }

    @Test
    public void noCompletionForExistingPropertiesWithProfile() throws BadLocationException {
        String value = "%prod.quarkus.application.name=name\n%prod.|";
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.http.cors");
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.application.name");
        properties.add(p2);
        projectInfo.setProperties(properties);
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)1, projectInfo, MicroProfileAssert.c("quarkus.http.cors", "%prod.quarkus.http.cors=", MicroProfileAssert.r(1, 0, 6)));
    }

    @Test
    public void completionForExistingPropertiesDifferentProfile() throws BadLocationException {
        String value = "|";
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.http.cors");
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.application.name");
        properties.add(p2);
        projectInfo.setProperties(properties);
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)2, projectInfo, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors=", MicroProfileAssert.r(0, 0, 0)), MicroProfileAssert.c("quarkus.application.name", "quarkus.application.name=", MicroProfileAssert.r(0, 0, 0)));
        value = "quarkus.http.cors=false\r\n%dev.|";
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)2, projectInfo, MicroProfileAssert.c("quarkus.http.cors", "%dev.quarkus.http.cors=", MicroProfileAssert.r(1, 0, 5)), MicroProfileAssert.c("quarkus.application.name", "%dev.quarkus.application.name=", MicroProfileAssert.r(1, 0, 5)));
        value = "quarkus.http.cors=false\r\n%dev.quarkus.application.name\r\n%prod.|";
        MicroProfileAssert.testCompletionFor(value, false, null, (Integer)2, projectInfo, MicroProfileAssert.c("quarkus.http.cors", "%prod.quarkus.http.cors=", MicroProfileAssert.r(2, 0, 6)), MicroProfileAssert.c("quarkus.application.name", "%prod.quarkus.application.name=", MicroProfileAssert.r(2, 0, 6)));
    }

    @Test
    public void completionOnValueForLevelBasedOnRule() throws BadLocationException {
        String value = "quarkus.log.file.level=| ";
        MicroProfileAssert.testCompletionFor(value, true, MicroProfileAssert.c("OFF", "OFF", MicroProfileAssert.r(0, 23, 24)), MicroProfileAssert.c("SEVERE", "SEVERE", MicroProfileAssert.r(0, 23, 24)));
    }

    @Test
    public void completionSpacingSurroundingEquals() throws BadLocationException {
        String value = "|";
        MicroProfileAssert.testCompletionFor(value, false, true, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors = false", MicroProfileAssert.r(0, 0, 0)));
        MicroProfileAssert.testCompletionFor(value, true, true, MicroProfileAssert.c("quarkus.http.cors", "quarkus.http.cors = ${1|false,true|}", MicroProfileAssert.r(0, 0, 0)));
    }
}

