/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.Test;

public class ApplicationPropertiesDefinitionTest {
    @Test
    public void definitionOnComments() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "#|";
        MicroProfileAssert.testDefinitionFor(value, new LocationLink[0]);
        value = " #|";
        MicroProfileAssert.testDefinitionFor(value, new LocationLink[0]);
    }

    @Test
    public void definitionOnKey() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.application.na|me";
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.ll("jdt://contents/quarkus-core-1.3.2.Final.jar/io.quarkus.runtime/ApplicationConfig.class?=all-quarkus-extensions/C:%5C/Users%5C/azerr%5C/.m2%5C/repository%5C/io%5C/quarkus%5C/quarkus-core%5C/1.3.2.Final%5C/quarkus-core-1.3.2.Final.jar%3Cio.quarkus.runtime(ApplicationConfig.class", MicroProfileAssert.r(0, 0, 24), MicroProfileAssert.r(16, 28, 32)));
    }

    @Test
    public void definitionOnEnumValue() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.log.syslog.async.overflow=BLO|CK";
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.ll("jdt://contents/jboss-logmanager-embedded-1.0.4.jar/org.jboss.logmanager.handlers/AsyncHandler$OverflowAction.class?=all-quarkus-extensions/C:%5C/Users%5C/azerr%5C/.m2%5C/repository%5C/org%5C/jboss%5C/logmanager%5C/jboss-logmanager-embedded%5C/1.0.4%5C/jboss-logmanager-embedded-1.0.4.jar%3Corg.jboss.logmanager.handlers(AsyncHandler$OverflowAction.class", MicroProfileAssert.r(0, 34, 39), MicroProfileAssert.r(222, 8, 13)));
    }

    @Test
    public void definitionOnOptionalEnumValue() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.datasource.transaction-isolation-level=no|ne";
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.ll("jdt://contents/agroal-api-1.7.jar/io.agroal.api.configuration/AgroalConnectionFactoryConfiguration$TransactionIsolation.class?=all-quarkus-extensions/C:%5C/Users%5C/azerr%5C/.m2%5C/repository%5C/io%5C/agroal%5C/agroal-api%5C/1.7%5C/agroal-api-1.7.jar%3Cio.agroal.api.configuration(AgroalConnectionFactoryConfiguration$TransactionIsolation.class", MicroProfileAssert.r(0, 47, 51), MicroProfileAssert.r(87, 19, 23)));
    }

    @Test
    public void definitionOnOptionalEnumValueKebabCase() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.datasource.transaction-isolation-level=read-uncom|mitted";
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.ll("jdt://contents/agroal-api-1.7.jar/io.agroal.api.configuration/AgroalConnectionFactoryConfiguration$TransactionIsolation.class?=all-quarkus-extensions/C:%5C/Users%5C/azerr%5C/.m2%5C/repository%5C/io%5C/agroal%5C/agroal-api%5C/1.7%5C/agroal-api-1.7.jar%3Cio.agroal.api.configuration(AgroalConnectionFactoryConfiguration$TransactionIsolation.class", MicroProfileAssert.r(0, 47, 63), MicroProfileAssert.r(87, 25, 41)));
    }

    @Test
    public void definitionOnMappedPropertyOptionalEnumValue() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.datasource.key.transaction-isolation-level=no|ne";
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.ll("jdt://contents/agroal-api-1.7.jar/io.agroal.api.configuration/AgroalConnectionFactoryConfiguration$TransactionIsolation.class?=all-quarkus-extensions/C:%5C/Users%5C/azerr%5C/.m2%5C/repository%5C/io%5C/agroal%5C/agroal-api%5C/1.7%5C/agroal-api-1.7.jar%3Cio.agroal.api.configuration(AgroalConnectionFactoryConfiguration$TransactionIsolation.class", MicroProfileAssert.r(0, 51, 55), MicroProfileAssert.r(87, 19, 23)));
    }

    @Test
    public void noDefinitionOnKey() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.datasource.driv|erXXXX";
        MicroProfileAssert.testDefinitionFor(value, new LocationLink[0]);
    }

    @Test
    public void noDefinitionOnValue() throws BadLocationException, InterruptedException, ExecutionException {
        String value = "quarkus.datasource.driver=XXX|X";
        MicroProfileAssert.testDefinitionFor(value, new LocationLink[0]);
    }
}

