/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.JavaVersion;
import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ConverterKind;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import com.redhat.microprofile.services.ValidationType;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.MicroProfileValidationTypeSettings;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.Test;

public class ApplicationPropertiesDiagnosticsTest {
    @Test
    public void validateUnknownProperties() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.datasource.driver=org.postgresql.Driver\nquarkus.datasource.username=quarkus_test\nquarkus.datasource.password=quarkus_test\n\n       \nquarkus.datasource.max-size=20\nquarkus.datasource.min-size=\nunknown.property=X\nquarkus.log.category.XXXXXXXXXXXXX.level=DEBUG\nquarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level=DEBUG\nquarkus.log.category.\"XXXXXXXXXXXXX.YYYYYYYYYYYY\".level=DEBUG\n\n";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), MicroProfileAssert.d(8, 0, 16, "Unknown property 'unknown.property'", DiagnosticSeverity.Warning, ValidationType.unknown), MicroProfileAssert.d(10, 0, 53, "Unknown property 'quarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level'", DiagnosticSeverity.Warning, ValidationType.unknown));
    }

    @Test
    public void validateUnknownPropertyMissingEquals() throws BadLocationException {
        String value = "unknown.property\nquarkus.datasource.min-size=\nquarkus.log.category.\"XXXXXXXXXXXXX.YYYYYYYYYYYY\".level=DEBUG\n\n";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), MicroProfileAssert.d(0, 0, 16, "Missing equals sign after 'unknown.property'", DiagnosticSeverity.Error, ValidationType.syntax), MicroProfileAssert.d(0, 0, 16, "Unknown property 'unknown.property'", DiagnosticSeverity.Warning, ValidationType.unknown));
    }

    @Test
    public void validateUnknownPropertiesAsError() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.datasource.driver=org.postgresql.Driver\nquarkus.datasource.username=quarkus_test\nquarkus.datasource.password=quarkus_test\n\n       \nquarkus.datasource.max-size=20\nquarkus.datasource.min-size=\nunknown.property=X\nquarkus.log.category.XXXXXXXXXXXXX.level=DEBUG\nquarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level=DEBUG\nquarkus.log.category.\"XXXXXXXXXXXXX.YYYYYYYYYYYY\".level=DEBUG\n\n";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileValidationTypeSettings unknown = new MicroProfileValidationTypeSettings();
        unknown.setSeverity("error");
        settings.setUnknown(unknown);
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(8, 0, 16, "Unknown property 'unknown.property'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(10, 0, 53, "Unknown property 'quarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level'", DiagnosticSeverity.Error, ValidationType.unknown));
    }

    @Test
    public void validateUnknownPropertiesExcluded() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.datasource.driver=org.postgresql.Driver\nquarkus.datasource.username=quarkus_test\nquarkus.datasource.password=quarkus_test\n\n       \nquarkus.datasource.max-size=20\nquarkus.datasource.min-size=\nunknown.property=X\nquarkus.log.category.XXXXXXXXXXXXX.level=DEBUG\nquarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level=DEBUG\nquarkus.log.category.\"XXXXXXXXXXXXX.YYYYYYYYYYYY\".level=DEBUG\n\n";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileValidationTypeSettings unknown = new MicroProfileValidationTypeSettings();
        unknown.setSeverity("error");
        unknown.setExcluded(new String[]{"unknown.property"});
        settings.setUnknown(unknown);
        MicroProfileAssert.testDiagnosticsFor(value, 1, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(10, 0, 53, "Unknown property 'quarkus.log.category.XXXXXXXXXXXXX.YYYYYYYYYYYY.level'", DiagnosticSeverity.Error, ValidationType.unknown));
    }

    @Test
    public void validateUnknownPropertiesExcludedWithPattern() throws BadLocationException {
        String value = "com.mycompany.remoteServices.MyServiceClient/mp-rest/url=url\ncom.mycompany.remoteServices.MyServiceClient/mp-rest/uri=uri\ncom.mycompany.foo=bar";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileValidationTypeSettings unknown = new MicroProfileValidationTypeSettings();
        unknown.setSeverity("error");
        settings.setUnknown(unknown);
        unknown.setExcluded(new String[]{"*/mp-rest/url"});
        MicroProfileAssert.testDiagnosticsFor(value, 2, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 56, "Unknown property 'com.mycompany.remoteServices.MyServiceClient/mp-rest/uri'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(2, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"*/mp-rest/*"});
        MicroProfileAssert.testDiagnosticsFor(value, 1, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(2, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        value = "com.mycompany.remoteServices.MyServiceClient/mp-rest/url/foo=url\ncom.mycompany.remoteServices.MyServiceClient/mp-rest/uri/bar=uri\ncom.mycompany.remoteServices.MyOtherClient/mp-rest/url/foo=url\ncom.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar=uri\ncom.mycompany.foo=bar";
        unknown.setExcluded(new String[]{"com.mycompany.*"});
        MicroProfileAssert.testDiagnosticsFor(value, 0, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        unknown.setExcluded(new String[]{"com.mycompany.remoteServices.MyServiceClient/**/"});
        MicroProfileAssert.testDiagnosticsFor(value, 3, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(2, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/url/foo'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(3, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(4, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"com.mycompany.remoteServices.MyServiceClient/**/foo"});
        MicroProfileAssert.testDiagnosticsFor(value, 4, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 60, "Unknown property 'com.mycompany.remoteServices.MyServiceClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(2, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/url/foo'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(3, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(4, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"com.mycompany.*/**/foo"});
        MicroProfileAssert.testDiagnosticsFor(value, 3, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 60, "Unknown property 'com.mycompany.remoteServices.MyServiceClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(3, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(4, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"com*MyService*/**/foo"});
        MicroProfileAssert.testDiagnosticsFor(value, 4, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 60, "Unknown property 'com.mycompany.remoteServices.MyServiceClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(2, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/url/foo'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(3, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(4, 0, 17, "Unknown property 'com.mycompany.foo'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"*foo"});
        MicroProfileAssert.testDiagnosticsFor(value, 2, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 60, "Unknown property 'com.mycompany.remoteServices.MyServiceClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown), MicroProfileAssert.d(3, 0, 58, "Unknown property 'com.mycompany.remoteServices.MyOtherClient/mp-rest/uri/bar'", DiagnosticSeverity.Error, ValidationType.unknown));
        unknown.setExcluded(new String[]{"*"});
        MicroProfileAssert.testDiagnosticsFor(value, 0, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateSyntaxMissingEquals() throws BadLocationException {
        String value = "quarkus.http.cors true\nquarkus.application.name=\"name\"\nquarkus.datasource.username";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 0, 17, "Missing equals sign after 'quarkus.http.cors'", DiagnosticSeverity.Error, ValidationType.syntax), MicroProfileAssert.d(2, 0, 27, "Missing equals sign after 'quarkus.datasource.username'", DiagnosticSeverity.Error, ValidationType.syntax));
    }

    @Test
    public void validateSyntaxMissingEqualsComment() throws BadLocationException {
        String value = "quarkus.http.cors=true\nquarkus.application.name # ====";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 24, "Missing equals sign after 'quarkus.application.name'", DiagnosticSeverity.Error, ValidationType.syntax));
    }

    @Test
    public void validateDuplicateProperty() throws BadLocationException {
        String value = "quarkus.http.port=8080\nquarkus.http.cors=false\nquarkus.http.host=0.0.0.0\nquarkus.http.port=8080\nquarkus.ssl.native=true";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(3, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate));
    }

    @Test
    public void validateDuplicateProperties() throws BadLocationException {
        String value = "quarkus.http.port=8080\nquarkus.http.cors=false\nquarkus.http.host=0.0.0.0\nquarkus.http.port=8080\nquarkus.ssl.native=true\nquarkus.http.port=8080\nquarkus.http.cors.headers=\"test\"";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(3, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(5, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate));
    }

    @Test
    public void validateDifferentDuplicateProperties() throws BadLocationException {
        String value = "quarkus.http.port=8080\nquarkus.ssl.native=false\nquarkus.http.port=8080\nquarkus.http.host=0.0.0.0\nquarkus.http.port=8080\nquarkus.ssl.native=true\nquarkus.http.cors.headers=\"test\"";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 18, "Duplicate property 'quarkus.ssl.native'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(5, 0, 18, "Duplicate property 'quarkus.ssl.native'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(0, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(2, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(4, 0, 17, "Duplicate property 'quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate));
    }

    @Test
    public void validateDuplicatePropertyDifferentProfile() throws BadLocationException {
        String value = "quarkus.http.port=8080\n%dev.quarkus.http.port=9090\n%prod.quarkus.http.port=9090\nquarkus.ssl.native=true";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateDuplicatePropertySameProfile() throws BadLocationException {
        String value = "quarkus.http.port=8080\n%dev.quarkus.http.port=9090\n%dev.quarkus.http.port=9090";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(1, 0, 22, "Duplicate property '%dev.quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(2, 0, 22, "Duplicate property '%dev.quarkus.http.port'", DiagnosticSeverity.Warning, ValidationType.duplicate));
    }

    @Test
    public void validateEnumValueNoError() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=DISCARD\nquarkus.log.file.async.overflow = BLOCK ";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateEnumValueError() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=error\nquarkus.log.file.async.overflow = error";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 35, 40, "Invalid enum value: 'error' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 34, 39, "Invalid enum value: 'error' is invalid for type org.jboss.logmanager.handlers.AsyncHandler.OverflowAction", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateIntValueNoError() throws BadLocationException {
        String value = "quarkus.http.port=09010\nquarkus.http.io-threads = 9\nquarkus.http.test-ssl-port=43444\nquarkus.thread-pool.core-threads  =  ";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateIntValueError() throws BadLocationException {
        String value = "quarkus.http.port=4.3\nquarkus.http.io-threads = hello\nquarkus.http.test-ssl-port=DISCARD\nquarkus.thread-pool.core-threads=false\nquarkus.hibernate-orm.jdbc.statement-batch-size= error";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 18, 21, "Type mismatch: int expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 26, 31, "Type mismatch: java.util.OptionalInt expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(2, 27, 34, "Type mismatch: int expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(3, 33, 38, "Type mismatch: int expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(4, 49, 54, "Type mismatch: java.util.Optional<java.lang.Integer> expected", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateBooleanNoError() throws BadLocationException {
        String value = "quarkus.http.cors  =   \nquarkus.arc.auto-inject-fields=false\nquarkus.ssl.native = true\nMP_Fault_Tolerance_Metrics_Enabled=false";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateBooleanError() throws BadLocationException {
        String value = "quarkus.http.cors  =   DISCARD\nquarkus.arc.auto-inject-fields=1.76\nquarkus.ssl.native = hello\nMP_Fault_Tolerance_Metrics_Enabled=abc";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 23, 30, "Type mismatch: boolean expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 31, 35, "Type mismatch: boolean expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(2, 21, 26, "Type mismatch: java.util.Optional<java.lang.Boolean> expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(3, 35, 38, "Type mismatch: java.lang.Boolean expected", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateFloatNoError() throws BadLocationException {
        String value = "quarkus.thread-pool.growth-resistance=0";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "quarkus.thread-pool.growth-resistance=0.4343";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "quarkus.thread-pool.growth-resistance=340.434";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "quarkus.thread-pool.growth-resistance=340.434f";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "quarkus.thread-pool.growth-resistance=";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateFloatError() throws BadLocationException {
        String value = "quarkus.thread-pool.growth-resistance=abc0.4343";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 38, 47, "Type mismatch: float expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.thread-pool.growth-resistance=DISCARD";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 38, 45, "Type mismatch: float expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.thread-pool.growth-resistance=hello";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 38, 43, "Type mismatch: float expected", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateBigDecimalError() throws BadLocationException {
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.BigDecimal");
        p1.setType("java.math.BigDecimal");
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.Optional.BigDecimal");
        p2.setType("java.util.Optional<java.math.BigDecimal>");
        properties.add(p2);
        projectInfo.setProperties(properties);
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        String value = "quarkus.BigDecimal=12\nquarkus.Optional.BigDecimal=12";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigDecimal=-19\nquarkus.Optional.BigDecimal=-19";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigDecimal=3.14159\nquarkus.Optional.BigDecimal=3.14159";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigDecimal=314.159e-2\nquarkus.Optional.BigDecimal=314.159e-2";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigDecimal=hello world\nquarkus.Optional.BigDecimal=hello world";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 30, "Type mismatch: java.math.BigDecimal expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 39, "Type mismatch: java.util.Optional<java.math.BigDecimal> expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.BigDecimal=true\nquarkus.Optional.BigDecimal=true";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 23, "Type mismatch: java.math.BigDecimal expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 32, "Type mismatch: java.util.Optional<java.math.BigDecimal> expected", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateBigIntegerError() throws BadLocationException {
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.BigInteger");
        p1.setType("java.math.BigInteger");
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.Optional.BigInteger");
        p2.setType("java.util.Optional<java.math.BigInteger>");
        properties.add(p2);
        projectInfo.setProperties(properties);
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        String value = "quarkus.BigInteger=12\nquarkus.Optional.BigInteger=12";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigInteger=-19\nquarkus.Optional.BigInteger=-19";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "quarkus.BigInteger=hello world\nquarkus.Optional.BigInteger=hello world";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 30, "Type mismatch: java.math.BigInteger expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 39, "Type mismatch: java.util.Optional<java.math.BigInteger> expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.BigInteger=true\nquarkus.Optional.BigInteger=true";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 23, "Type mismatch: java.math.BigInteger expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 32, "Type mismatch: java.util.Optional<java.math.BigInteger> expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.BigInteger=3.14159\nquarkus.Optional.BigInteger=3.14159";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 26, "Type mismatch: java.math.BigInteger expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 35, "Type mismatch: java.util.Optional<java.math.BigInteger> expected", DiagnosticSeverity.Error, ValidationType.value));
        value = "quarkus.BigInteger=314.159e-2\nquarkus.Optional.BigInteger=314.159e-2";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 19, 29, "Type mismatch: java.math.BigInteger expected", DiagnosticSeverity.Error, ValidationType.value), MicroProfileAssert.d(1, 28, 38, "Type mismatch: java.util.Optional<java.math.BigInteger> expected", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateBuildTimeInjectValues() throws BadLocationException {
        String value = "quarkus.http.cors = ${value.one}\nquarkus.http.port=${value_two}\nquarkus.ssl.native=    ${value-three}";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateValueForLevelBasedOnRule() throws BadLocationException {
        String value = "quarkus.log.file.level=XXX ";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 23, 27, "Invalid enum value: 'XXX' is invalid for type java.util.logging.Level", DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateValueForTransactionIsolationLevelEnumKebabCase() {
        String value = "quarkus.datasource.transaction-isolation-level = READ_UNCOMMITTED";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateValueForTransactionIsolationLevelEnumVerbatim() {
        String value = "quarkus.datasource.transaction-isolation-level = read-uncommitted";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
    }

    @Test
    public void validateAccordingConverterKinds() {
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        projectInfo.setProperties(new ArrayList());
        projectInfo.setHints(new ArrayList());
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("property.converters.none");
        p1.setType("MyEnumType");
        projectInfo.getProperties().add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("property.converters.verbatim");
        p2.setConverterKinds(Arrays.asList(ConverterKind.VERBATIM));
        p2.setType("MyEnumType");
        projectInfo.getProperties().add(p2);
        ItemMetadata p3 = new ItemMetadata();
        p3.setName("property.converters.kebab_case");
        p3.setConverterKinds(Arrays.asList(ConverterKind.KEBAB_CASE));
        p3.setType("MyEnumType");
        projectInfo.getProperties().add(p3);
        ItemMetadata p4 = new ItemMetadata();
        p4.setName("property.converters.both");
        p4.setConverterKinds(Arrays.asList(ConverterKind.KEBAB_CASE, ConverterKind.VERBATIM));
        p4.setType("MyEnumType");
        projectInfo.getProperties().add(p4);
        ItemHint hint = new ItemHint();
        hint.setName("MyEnumType");
        hint.setValues(new ArrayList());
        ItemHint.ValueHint valueHint = new ItemHint.ValueHint();
        valueHint.setValue("READ_UNCOMMITTED");
        hint.getValues().add(valueHint);
        projectInfo.getHints().add(hint);
        String value = "property.converters.none = READ_UNCOMMITTED";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "property.converters.none = read-uncommitted";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 27, 43, "Invalid enum value: 'read-uncommitted' is invalid for type MyEnumType", DiagnosticSeverity.Error, ValidationType.value));
        value = "property.converters.verbatim = READ_UNCOMMITTED";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "property.converters.verbatim = read-uncommitted";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 31, 47, "Invalid enum value: 'read-uncommitted' is invalid for type MyEnumType", DiagnosticSeverity.Error, ValidationType.value));
        value = "property.converters.kebab_case = read-uncommitted";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "property.converters.kebab_case = READ_UNCOMMITTED";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 33, 49, "Invalid enum value: 'READ_UNCOMMITTED' is invalid for type MyEnumType", DiagnosticSeverity.Error, ValidationType.value));
        value = "property.converters.both = read-uncommitted";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        value = "property.converters.both = READ_UNCOMMITTED";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
    }

    @Test
    public void validateRegexPatternValue() {
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        projectInfo.setProperties(new ArrayList());
        projectInfo.setHints(new ArrayList());
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("mp.opentracing.server.skip-pattern");
        p1.setRequired(false);
        p1.setType("java.util.Optional<java.util.regex.Pattern>");
        projectInfo.getProperties().add(p1);
        String value = "mp.opentracing.server.skip-pattern=/foo|/bar.*";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
        String ls = System.lineSeparator();
        value = "mp.opentracing.server.skip-pattern=(";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 35, 36, "Unclosed group near index 1" + ls + "(" + ls + "", DiagnosticSeverity.Error, ValidationType.value));
        value = "mp.opentracing.server.skip-pattern=[";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 35, 36, "Unclosed character class near index 0" + ls + "[" + ls + "^" + ls + "", DiagnosticSeverity.Error, ValidationType.value));
        value = "mp.opentracing.server.skip-pattern=\\";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 35, 36, "Unexpected internal error near index 1" + ls + "\\" + ls + "", DiagnosticSeverity.Error, ValidationType.value));
        value = "mp.opentracing.server.skip-pattern={";
        StringBuilder message = new StringBuilder("Illegal repetition");
        if (JavaVersion.CURRENT > 12) {
            message.append(" near index 1");
        }
        message.append(ls).append("{").append(ls);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 35, 36, message.toString(), DiagnosticSeverity.Error, ValidationType.value));
    }

    @Test
    public void validateMultilineKey() {
        String value = "quarkus.\\\napplication.\\\nname=name";
        MicroProfileValidationSettings settings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "quarkus.\\\r\napplication.\\\r\nname=name";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, new Diagnostic[0]);
        value = "qu.\\\napplication.\\\nname=name";
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), settings, MicroProfileAssert.d(0, 0, 2, 4, "Unknown property 'qu.application.name'", DiagnosticSeverity.Warning, ValidationType.unknown));
    }
}

