/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import org.junit.Test;

public class ApplicationPropertiesFormatterTest {
    @Test
    public void testExtraSpacesAroundEquals() throws BadLocationException {
        String value = "quarkus.http.port       =         8000";
        String expected = "quarkus.http.port=8000";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testExtraSpacesAtEnds() throws BadLocationException {
        String value = "             quarkus.http.port=8000              ";
        String expected = "quarkus.http.port=8000";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testFormatWithProfile() throws BadLocationException {
        String value = "             %dev.quarkus.http.port       =      8000              ";
        String expected = "%dev.quarkus.http.port=8000";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testFormatMissingValue() throws BadLocationException {
        String value = "quarkus.http.port       =                  ";
        String expected = "quarkus.http.port=";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testFormatMissingKey() throws BadLocationException {
        String value = "      =   false  ";
        String expected = "=false";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testFormatMissingKeyValue() throws BadLocationException {
        String value = "      =     ";
        String expected = "=";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testFormatMissingEquals() throws BadLocationException {
        String value = "    quarkus.http.port    8000     ";
        String expected = "quarkus.http.port    8000";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testInsertSpacesAroundEquals() throws BadLocationException {
        String value = "quarkus.http.port=8000";
        String expected = "quarkus.http.port = 8000";
        MicroProfileAssert.assertFormat(value, expected, true);
    }

    @Test
    public void testRemoveSpacesAroundEquals() throws BadLocationException {
        String value = "quarkus.http.port = 8000";
        String expected = "quarkus.http.port=8000";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testRemoveExtraNewlines() throws BadLocationException {
        String value = "quarkus.http.port=8080\n%dev.quarkus.log.syslog.async.overflow=DISCARD\n\n\n\nquarkus.application.name=name\n%prod.quarkus.application.version=1.0\n\nquarkus.http.cors=false\n\n";
        String expected = "quarkus.http.port=8080\n%dev.quarkus.log.syslog.async.overflow=DISCARD\nquarkus.application.name=name\n%prod.quarkus.application.version=1.0\nquarkus.http.cors=false";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testRangeFormattingPartialLines() throws BadLocationException {
        String value = "quarkus.http.port       =        8080\n%dev.quarku|s.log.syslog.async.overflow   =  DISCARD   \n\n\nquarkus.application.|name  =   \n\n%prod.quarkus.application.version=1.0\n=   false\n\nquarkus.application.version  1.0";
        String expected = "quarkus.http.port       =        8080\n%dev.quarkus.log.syslog.async.overflow=DISCARD\nquarkus.application.name=\n\n%prod.quarkus.application.version=1.0\n=   false\n\nquarkus.application.version  1.0";
        MicroProfileAssert.assertRangeFormat(value, expected, false);
    }

    @Test
    public void testRangeFormattingFullLines() throws BadLocationException {
        String value = "|quarkus.http.port       =        8080\n%dev.quarkus.log.syslog.async.overflow   =  DISCARD   \n\n\nquarkus.application.name  =   |\n\n%prod.quarkus.application.version=1.0\n=   false\n\nquarkus.application.version  1.0";
        String expected = "quarkus.http.port=8080\n%dev.quarkus.log.syslog.async.overflow=DISCARD\nquarkus.application.name=\n\n%prod.quarkus.application.version=1.0\n=   false\n\nquarkus.application.version  1.0";
        MicroProfileAssert.assertRangeFormat(value, expected, false);
    }

    @Test
    public void testCommentsPersist() throws BadLocationException {
        String value;
        String expected = value = "quarkus.http.port=8000\n# this is a comment\nquarkus.application.version=1.0\n# this is a comment\n# this is a comment";
        MicroProfileAssert.assertFormat(value, expected, false);
    }

    @Test
    public void testRangeCommentsPersist() throws BadLocationException {
        String value = "# a comment \nqua|rkus.applic|ation.version    =   1.0";
        String expected = "# a comment \nquarkus.application.version=1.0";
        MicroProfileAssert.assertRangeFormat(value, expected, false);
    }

    @Test
    public void testMultiLineKeyAndValue() throws BadLocationException {
        String value = "quarkus.\\\napplication.\\\nname=my\\\napplication\\\nname   ";
        String expected = "quarkus.\\\napplication.\\\nname=my\\\napplication\\\nname";
        MicroProfileAssert.assertFormat(value, expected, false);
    }
}

