/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import org.junit.Test;

public class ApplicationPropertiesHoverTest {
    @Test
    public void unkwownProperty() throws BadLocationException {
        String value = "unkwo|wn";
        String hoverLabel = null;
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void testKeyHoverMarkdown() throws BadLocationException {
        String value = "quarkus.applica|tion.name = name";
        String hoverLabel = "**quarkus.application.name**" + System.lineSeparator() + System.lineSeparator() + "The name of the application.\nIf not set, defaults to the name of the project (except for tests where it is not set at all)." + System.lineSeparator() + System.lineSeparator() + " * Type: `java.util.Optional<java.lang.String>`" + System.lineSeparator() + " * Phase: `buildtime & runtime`" + System.lineSeparator() + " * Extension: `quarkus-core`";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void testKeyHoverPlaintext() throws BadLocationException {
        String value = "quarkus.applica|tion.name = name";
        String hoverLabel = "quarkus.application.name" + System.lineSeparator() + System.lineSeparator() + "The name of the application.\nIf not set, defaults to the name of the project (except for tests where it is not set at all)." + System.lineSeparator() + System.lineSeparator() + "Type: java.util.Optional<java.lang.String>" + System.lineSeparator() + "Phase: buildtime & runtime" + System.lineSeparator() + "Extension: quarkus-core";
        MicroProfileAssert.assertHoverPlaintext(value, hoverLabel, 0);
    }

    @Test
    public void testKeyHoverNoSpaces() throws BadLocationException {
        String value = "quarkus.applica|tion.name=name";
        String hoverLabel = "**quarkus.application.name**" + System.lineSeparator() + System.lineSeparator() + "The name of the application.\nIf not set, defaults to the name of the project (except for tests where it is not set at all)." + System.lineSeparator() + System.lineSeparator() + " * Type: `java.util.Optional<java.lang.String>`" + System.lineSeparator() + " * Phase: `buildtime & runtime`" + System.lineSeparator() + " * Extension: `quarkus-core`";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void testNoKeyHoverOnEqualsSign() throws BadLocationException {
        MicroProfileAssert.assertHoverMarkdown("quarkus.application.name |= name", null, 0);
        MicroProfileAssert.assertHoverMarkdown("quarkus.application.name|=name", null, 0);
        MicroProfileAssert.assertHoverMarkdown("quarkus.log.syslog.async.overflow|=DISCARD", null, 0);
    }

    @Test
    public void testNoValueHoverOnEqualsSign() throws BadLocationException {
        MicroProfileAssert.assertHoverMarkdown("quarkus.log.syslog.async.overflow |= DISCARD", null, 0);
        MicroProfileAssert.assertHoverMarkdown("quarkus.log.syslog.async.overflow|=DISCARD", null, 0);
    }

    @Test
    public void testNoHoverOnEqualsWhenNoValue() throws BadLocationException {
        String value = "a=1\nb=|";
        MicroProfileAssert.assertHoverMarkdown(value, null, 0);
    }

    @Test
    public void testDefaultProfileHover() throws BadLocationException {
        String value = "%d|ev.quarkus.log.syslog.async.overflow=DISCARD";
        String hoverLabelMarkdown = "**dev**" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabelMarkdown, 0);
    }

    @Test
    public void testDefaultProfileHoverSpacesInFront() throws BadLocationException {
        String value = "        %d|ev.quarkus.log.syslog.async.overflow=DISCARD";
        String hoverLabelMarkdown = "**dev**" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabelMarkdown, 8);
    }

    @Test
    public void testOnlyDefaultProfile() throws BadLocationException {
        String value = "%de|v";
        String hoverLabelMarkdown = "**dev**" + System.lineSeparator() + System.lineSeparator() + "Profile activated when in development mode (quarkus:dev)." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabelMarkdown, 0);
        value = "|%prod";
        hoverLabelMarkdown = "**prod**" + System.lineSeparator() + System.lineSeparator() + "The default profile when not running in development or test mode." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabelMarkdown, 0);
        value = "%test|";
        hoverLabelMarkdown = "**test**" + System.lineSeparator() + System.lineSeparator() + "Profile activated when running tests." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabelMarkdown, 0);
    }

    @Test
    public void testOnlyNonDefaultProfile() throws BadLocationException {
        String value = "%hel|lo";
        String hoverLabel = null;
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
        value = "%hello|";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
        value = "|%hello";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void testKeyWithProfileHoverMarkdown() throws BadLocationException {
        String value = "%dev.quarkus.applica|tion.name = name";
        String hoverLabel = "**quarkus.application.name**" + System.lineSeparator() + System.lineSeparator() + "The name of the application.\nIf not set, defaults to the name of the project (except for tests where it is not set at all)." + System.lineSeparator() + System.lineSeparator() + " * Profile: `dev`" + System.lineSeparator() + " * Type: `java.util.Optional<java.lang.String>`" + System.lineSeparator() + " * Phase: `buildtime & runtime`" + System.lineSeparator() + " * Extension: `quarkus-core`";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void testKeyMap() throws BadLocationException {
        String value = "quar|kus.log.category.\"com.lordofthejars\".level=DEBUG";
        String hoverLabel = "**quarkus.log.category.\\{\\*\\}.level**" + System.lineSeparator() + System.lineSeparator() + "The log level level for this category" + System.lineSeparator() + System.lineSeparator() + " * Type: `io.quarkus.runtime.logging.InheritableLevel`" + System.lineSeparator() + " * Default: `inherit`" + System.lineSeparator() + " * Phase: `runtime`" + System.lineSeparator() + " * Extension: `quarkus-core`";
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 0);
    }

    @Test
    public void hoverWithEnums() throws BadLocationException {
        String value = "quarkus.log.console.async.overflow=BLO|CK";
        String hoverLabel = "**BLOCK**" + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 35);
    }

    @Test
    public void hoverOnValueForLevelBasedOnRule() throws BadLocationException {
        String value = "quarkus.log.file.level=OF|F ";
        String hoverLabel = "**OFF**" + System.lineSeparator() + System.lineSeparator() + "OFF is a special level that can be used to turn off logging.\nThis level is initialized to `Integer.MAX_VALUE`." + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 23);
    }

    @Test
    public void hoverWithEnumsKebabCase() throws BadLocationException {
        String value = "quarkus.datasource.transaction-isolation-level = read-unc|ommitted";
        String hoverLabel = "**READ_UNCOMMITTED**" + System.lineSeparator();
        MicroProfileAssert.assertHoverMarkdown(value, hoverLabel, 49);
    }
}

