/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import com.redhat.microprofile.services.ValidationType;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.MicroProfileValidationTypeSettings;
import java.util.ArrayList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationPropertiesRequiredCodeActionTest {
    private static MicroProfileProjectInfo projectInfo;
    private static MicroProfileValidationSettings validationSettings;

    @BeforeClass
    public static void setUp() throws Exception {
        projectInfo = new MicroProfileProjectInfo();
        validationSettings = new MicroProfileValidationSettings();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.required.property");
        p1.setRequired(true);
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.second.required.property");
        p2.setRequired(true);
        properties.add(p2);
        ItemMetadata p3 = new ItemMetadata();
        p3.setName("quarkus.third.required.property");
        p3.setRequired(true);
        properties.add(p3);
        ItemMetadata p4 = new ItemMetadata();
        p4.setName("quarkus.optional.property");
        p4.setRequired(false);
        properties.add(p4);
        projectInfo.setProperties(properties);
        MicroProfileValidationTypeSettings error = new MicroProfileValidationTypeSettings();
        error.setSeverity("warning");
        validationSettings.setRequired(error);
    }

    @Test
    public void testOneMissingPropertyCodeAction() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.second.required.property=hello\nquarkus.third.required.property=hello";
        Diagnostic d = MicroProfileAssert.d(0, 0, 2, 37, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d);
        MicroProfileAssert.testCodeActionsFor(value, d, projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(2, 37, 2, 37, "\nquarkus.required.property="), d));
    }

    @Test
    public void testOneMissingPropertyCodeActionDelimeter() throws BadLocationException {
        String value = "quarkus.optional.property=hello\r\nquarkus.second.required.property=hello\r\nquarkus.third.required.property=hello";
        Diagnostic d = MicroProfileAssert.d(0, 0, 2, 37, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d);
        MicroProfileAssert.testCodeActionsFor(value, d, projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(2, 37, 2, 37, "\r\nquarkus.required.property="), d));
    }

    @Test
    public void testMissingPropertyCodeAction() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.third.required.property=hello";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 1, 37, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d2 = MicroProfileAssert.d(0, 0, 1, 37, "Missing required property 'quarkus.second.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        ArrayList<Diagnostic> d = new ArrayList<Diagnostic>();
        d.add(d1);
        d.add(d2);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d1, d2);
        MicroProfileAssert.testCodeActionsFor(value, d, ((Diagnostic)d.get(0)).getRange(), projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(1, 37, 1, 37, "\nquarkus.required.property=\nquarkus.second.required.property="), d1, d2));
    }

    @Test
    public void testMissingPropertyTrailingWhitespaceCodeAction() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.third.required.property=hello\n      \n     \n     ";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 4, 5, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d2 = MicroProfileAssert.d(0, 0, 4, 5, "Missing required property 'quarkus.second.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        ArrayList<Diagnostic> d = new ArrayList<Diagnostic>();
        d.add(d1);
        d.add(d2);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d1, d2);
        MicroProfileAssert.testCodeActionsFor(value, d, ((Diagnostic)d.get(0)).getRange(), projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(1, 37, 1, 37, "\nquarkus.required.property=\nquarkus.second.required.property="), d1, d2));
    }

    @Test
    public void testMissingPropertyWhitepspaceCodeAction() throws BadLocationException {
        String value = "     \n      \n     \n      \n     \n     ";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 5, 5, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d2 = MicroProfileAssert.d(0, 0, 5, 5, "Missing required property 'quarkus.second.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d3 = MicroProfileAssert.d(0, 0, 5, 5, "Missing required property 'quarkus.third.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        ArrayList<Diagnostic> d = new ArrayList<Diagnostic>();
        d.add(d1);
        d.add(d2);
        d.add(d3);
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d1, d2, d3);
        MicroProfileAssert.testCodeActionsFor(value, d, ((Diagnostic)d.get(0)).getRange(), projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(0, 0, 0, 0, "quarkus.required.property=\nquarkus.second.required.property=\nquarkus.third.required.property="), d1, d2, d3));
    }

    @Test
    public void testMissingPropertyEmptyFileCodeAction() throws BadLocationException {
        String value = "";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d2 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.second.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d3 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.third.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        ArrayList<Diagnostic> d = new ArrayList<Diagnostic>();
        d.add(d1);
        d.add(d2);
        d.add(d3);
        String lineSeparator = System.lineSeparator();
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d1, d2, d3);
        MicroProfileAssert.testCodeActionsFor(value, d, ((Diagnostic)d.get(0)).getRange(), projectInfo, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(0, 0, 0, 0, "quarkus.required.property=" + lineSeparator + "quarkus.second.required.property=" + lineSeparator + "quarkus.third.required.property="), d1, d2, d3));
    }

    @Test
    public void testMissingPropertySpacesCodeAction() throws BadLocationException {
        String value = "";
        Diagnostic d1 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d2 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.second.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        Diagnostic d3 = MicroProfileAssert.d(0, 0, 0, 0, "Missing required property 'quarkus.third.required.property'", DiagnosticSeverity.Warning, ValidationType.required);
        ArrayList<Diagnostic> d = new ArrayList<Diagnostic>();
        d.add(d1);
        d.add(d2);
        d.add(d3);
        MicroProfileFormattingSettings quarkusFormattingSettings = new MicroProfileFormattingSettings();
        quarkusFormattingSettings.setSurroundEqualsWithSpaces(true);
        String lineSeparator = System.lineSeparator();
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, d1, d2, d3);
        MicroProfileAssert.testCodeActionsFor(value, d, ((Diagnostic)d.get(0)).getRange(), projectInfo, quarkusFormattingSettings, MicroProfileAssert.ca("Add all missing required properties?", MicroProfileAssert.te(0, 0, 0, 0, "quarkus.required.property = " + lineSeparator + "quarkus.second.required.property = " + lineSeparator + "quarkus.third.required.property = "), d1, d2, d3));
    }
}

