/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import com.redhat.microprofile.services.ValidationType;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.MicroProfileValidationTypeSettings;
import java.util.ArrayList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationPropertiesRequiredDiagnosticsTest {
    private static MicroProfileProjectInfo projectInfo;
    private static MicroProfileValidationSettings settings;

    @BeforeClass
    public static void setUp() throws Exception {
        projectInfo = new MicroProfileProjectInfo();
        settings = new MicroProfileValidationSettings();
        ArrayList<ItemMetadata> properties = new ArrayList<ItemMetadata>();
        ItemMetadata p1 = new ItemMetadata();
        p1.setName("quarkus.required.property");
        p1.setRequired(true);
        properties.add(p1);
        ItemMetadata p2 = new ItemMetadata();
        p2.setName("quarkus.optional.property");
        p2.setRequired(false);
        properties.add(p2);
        ItemMetadata p3 = new ItemMetadata();
        p3.setName("quarkus.second.optional.property");
        p3.setRequired(false);
        properties.add(p3);
        projectInfo.setProperties(properties);
        MicroProfileValidationTypeSettings error = new MicroProfileValidationTypeSettings();
        error.setSeverity("error");
        settings.setRequired(error);
    }

    @Test
    public void testNoErrorRequiredExists() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.required.property=hello";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, new Diagnostic[0]);
    }

    @Test
    public void testMissingRequired() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.second.optional.property=hello";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(0, 0, 1, 38, "Missing required property 'quarkus.required.property'", DiagnosticSeverity.Error, ValidationType.required));
    }

    @Test
    public void testRequiredMissingValue() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.required.property=   \nquarkus.second.optional.property=hello";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(1, 0, 29, "Missing required property value for 'quarkus.required.property'", DiagnosticSeverity.Error, ValidationType.requiredValue));
    }

    @Test
    public void testRequiredBothMissingValueDuplicates() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.required.property=   \nquarkus.required.property=   \nquarkus.second.optional.property=hello";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(1, 0, 25, "Duplicate property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(2, 0, 25, "Duplicate property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(1, 0, 29, "Missing required property value for 'quarkus.required.property'", DiagnosticSeverity.Error, ValidationType.requiredValue), MicroProfileAssert.d(2, 0, 29, "Missing required property value for 'quarkus.required.property'", DiagnosticSeverity.Error, ValidationType.requiredValue));
    }

    @Test
    public void testRequiredOneMissingValueDuplicates() throws BadLocationException {
        String value = "quarkus.optional.property=hello\nquarkus.required.property=value\nquarkus.required.property=   \nquarkus.second.optional.property=hello";
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, settings, MicroProfileAssert.d(1, 0, 25, "Duplicate property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.duplicate), MicroProfileAssert.d(2, 0, 25, "Duplicate property 'quarkus.required.property'", DiagnosticSeverity.Warning, ValidationType.duplicate));
    }
}

