/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.services.MicroProfileAssert;
import java.util.Arrays;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.Test;

public class ApplicationPropertiesSymbolsTest {
    @Test
    public void symbolsInformation() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.datasource.driver=org.postgresql.Driver\nquarkus.datasource.username=quarkus_test\nquarkus.datasource.password=quarkus_test\n\n       \nquarkus.datasource.max-size\nquarkus.datasource.min-size=\n\n";
        MicroProfileAssert.testSymbolInformationsFor(value, MicroProfileAssert.s("quarkus.datasource.driver", SymbolKind.Property, "application.properties", MicroProfileAssert.r(1, 0, 47)), MicroProfileAssert.s("quarkus.datasource.username", SymbolKind.Property, "application.properties", MicroProfileAssert.r(2, 0, 40)), MicroProfileAssert.s("quarkus.datasource.password", SymbolKind.Property, "application.properties", MicroProfileAssert.r(3, 0, 40)), MicroProfileAssert.s("quarkus.datasource.max-size", SymbolKind.Property, "application.properties", MicroProfileAssert.r(6, 0, 27)), MicroProfileAssert.s("quarkus.datasource.min-size", SymbolKind.Property, "application.properties", MicroProfileAssert.r(7, 0, 28)));
    }

    @Test
    public void documentSymbols() throws BadLocationException {
        String value = "# quarkus.datasource.url=jdbc:postgresql:quarkus_test\nquarkus.datasource.driver=org.postgresql.Driver\nquarkus.hibernate-orm.database.generation=drop-and-create\nquarkus.hibernate-orm.log.sql=true\n\n       \nquarkus.datasource.max-size\nquarkus.datasource.min-size=\n%dev.quarkus.datasource.max-size=2\n%dev.quarkus.datasource.min-size=1\n\n";
        MicroProfileAssert.testDocumentSymbolsFor(value, MicroProfileAssert.ds("quarkus", SymbolKind.Package, MicroProfileAssert.r(1, 0, 47), null, Arrays.asList(MicroProfileAssert.ds("datasource", SymbolKind.Package, MicroProfileAssert.r(1, 0, 47), null, Arrays.asList(MicroProfileAssert.ds("driver", SymbolKind.Property, MicroProfileAssert.r(1, 0, 47), "org.postgresql.Driver"), MicroProfileAssert.ds("max-size", SymbolKind.Property, MicroProfileAssert.r(6, 0, 27), null), MicroProfileAssert.ds("min-size", SymbolKind.Property, MicroProfileAssert.r(7, 0, 28), ""))), MicroProfileAssert.ds("hibernate-orm", SymbolKind.Package, MicroProfileAssert.r(2, 0, 57), null, Arrays.asList(MicroProfileAssert.ds("database", SymbolKind.Package, MicroProfileAssert.r(2, 0, 57), null, Arrays.asList(MicroProfileAssert.ds("generation", SymbolKind.Property, MicroProfileAssert.r(2, 0, 57), "drop-and-create"))), MicroProfileAssert.ds("log", SymbolKind.Package, MicroProfileAssert.r(3, 0, 34), null, Arrays.asList(MicroProfileAssert.ds("sql", SymbolKind.Property, MicroProfileAssert.r(3, 0, 34), "true"))))))), MicroProfileAssert.ds("%dev", SymbolKind.Package, MicroProfileAssert.r(8, 0, 34), null, Arrays.asList(MicroProfileAssert.ds("quarkus", SymbolKind.Package, MicroProfileAssert.r(8, 0, 34), null, Arrays.asList(MicroProfileAssert.ds("datasource", SymbolKind.Package, MicroProfileAssert.r(8, 0, 34), null, Arrays.asList(MicroProfileAssert.ds("max-size", SymbolKind.Property, MicroProfileAssert.r(8, 0, 34), "2"), MicroProfileAssert.ds("min-size", SymbolKind.Property, MicroProfileAssert.r(9, 0, 34), "1"))))))));
    }

    @Test
    public void multiLineKeyValueSymbols() throws BadLocationException {
        String value = "quarkus.\\\napplication.name = quarkus \\\napplication \\\nname";
        MicroProfileAssert.testSymbolInformationsFor(value, MicroProfileAssert.s("quarkus.application.name", SymbolKind.Property, "application.properties", MicroProfileAssert.r(0, 0, 3, 4)));
    }
}

