/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.MockMicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.ls.api.MicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.ls.commons.client.CommandCapabilities;
import com.redhat.microprofile.ls.commons.client.CommandKindCapabilities;
import com.redhat.microprofile.ls.commons.snippets.TextDocumentSnippetRegistry;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.services.MicroProfileLanguageService;
import com.redhat.microprofile.services.ValidationType;
import com.redhat.microprofile.settings.MicroProfileCommandCapabilities;
import com.redhat.microprofile.settings.MicroProfileCompletionSettings;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileHoverSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.snippets.LanguageId;
import com.redhat.microprofile.snippets.SnippetContextForProperties;
import com.redhat.microprofile.utils.DocumentationUtils;
import com.redhat.microprofile.utils.PositionUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;

public class MicroProfileAssert {
    private static MicroProfileProjectInfo DEFAULT_PROJECT;
    private static MicroProfilePropertyDefinitionProvider DEFAULT_DEFINITION_PROVIDER;
    private static final String MICROPROFILE_DIAGNOSTIC_SOURCE = "microprofile";

    public static MicroProfileProjectInfo getDefaultMicroProfileProjectInfo() {
        if (DEFAULT_PROJECT == null) {
            DEFAULT_PROJECT = (MicroProfileProjectInfo)MicroProfileAssert.createGson().fromJson((Reader)new InputStreamReader(MicroProfileAssert.class.getResourceAsStream("all-quarkus-properties.json")), MicroProfileProjectInfo.class);
        }
        return DEFAULT_PROJECT;
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();
    }

    public static MicroProfilePropertyDefinitionProvider getDefaultMicroProfilePropertyDefinitionProvider() {
        if (DEFAULT_DEFINITION_PROVIDER == null) {
            DEFAULT_DEFINITION_PROVIDER = new MockMicroProfilePropertyDefinitionProvider();
        }
        return DEFAULT_DEFINITION_PROVIDER;
    }

    public static void testCompletionFor(String value, boolean snippetSupport, Integer expectedCount) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, false, expectedCount, new CompletionItem[0]);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, CompletionItem ... expectedItems) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, false, null, expectedItems);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, boolean insertSpacing, CompletionItem ... expectedItems) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, insertSpacing, null, expectedItems);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, false, null, expectedCount, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), expectedItems);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, boolean insertSpacing, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, insertSpacing, null, expectedCount, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), expectedItems);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, String fileURI, Integer expectedCount, MicroProfileProjectInfo projectInfo, CompletionItem ... expectedItems) throws BadLocationException {
        MicroProfileAssert.testCompletionFor(value, snippetSupport, false, null, expectedCount, projectInfo, expectedItems);
    }

    public static void testCompletionFor(String value, boolean snippetSupport, boolean insertSpacing, String fileURI, Integer expectedCount, MicroProfileProjectInfo projectInfo, CompletionItem ... expectedItems) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        PropertiesModel model = MicroProfileAssert.parse(value, fileURI);
        Position position = model.positionAt(offset);
        MicroProfileCompletionSettings completionSettings = new MicroProfileCompletionSettings();
        CompletionItemCapabilities completionItemCapabilities = new CompletionItemCapabilities();
        completionItemCapabilities.setSnippetSupport(Boolean.valueOf(snippetSupport));
        CompletionCapabilities completionCapabilities = new CompletionCapabilities(completionItemCapabilities);
        completionSettings.setCapabilities(completionCapabilities);
        MicroProfileFormattingSettings formattingSettings = new MicroProfileFormattingSettings();
        formattingSettings.setSurroundEqualsWithSpaces(insertSpacing);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        CompletionList list = languageService.doComplete(model, position, projectInfo, completionSettings, formattingSettings, () -> {});
        MicroProfileAssert.assertCompletions(list, expectedCount, expectedItems);
    }

    public static void assertCompletions(CompletionList actual, Integer expectedCount, CompletionItem ... expectedItems) {
        List labels = actual.getItems().stream().map(i -> i.getLabel()).sorted().collect(Collectors.toList());
        String previous = null;
        for (String label : labels) {
            Assert.assertTrue((String)("Duplicate label " + label + " in " + labels.stream().collect(Collectors.joining(",")) + "}"), (previous != label ? 1 : 0) != 0);
            previous = label;
        }
        if (expectedCount != null) {
            Assert.assertEquals((long)expectedCount.intValue(), (long)actual.getItems().size());
        }
        if (expectedItems != null) {
            for (CompletionItem item : expectedItems) {
                MicroProfileAssert.assertCompletion(actual, item);
            }
        }
    }

    private static void assertCompletion(CompletionList completions, CompletionItem expected) {
        Range r;
        List matches = completions.getItems().stream().filter(completion -> expected.getLabel().equals(completion.getLabel())).collect(Collectors.toList());
        Assert.assertEquals((String)(expected.getLabel() + " should only exist once: Actual: " + completions.getItems().stream().map(c -> c.getLabel()).collect(Collectors.joining(","))), (long)1L, (long)matches.size());
        CompletionItem match = (CompletionItem)matches.get(0);
        if (expected.getTextEdit().getNewText() != null) {
            Assert.assertEquals((Object)expected.getTextEdit().getNewText(), (Object)match.getTextEdit().getNewText());
        }
        if ((r = expected.getTextEdit().getRange()) != null && r.getStart() != null && r.getEnd() != null) {
            Assert.assertEquals((Object)expected.getTextEdit().getRange(), (Object)match.getTextEdit().getRange());
        }
        if (expected.getFilterText() != null && match.getFilterText() != null) {
            Assert.assertEquals((Object)expected.getFilterText(), (Object)match.getFilterText());
        }
        if (expected.getDocumentation() != null) {
            Assert.assertEquals((Object)DocumentationUtils.getDocumentationTextFromEither((Either)expected.getDocumentation()), (Object)DocumentationUtils.getDocumentationTextFromEither((Either)match.getDocumentation()));
        }
    }

    public static CompletionItem c(String label, String newText, Range range) {
        return MicroProfileAssert.c(label, newText, range, null);
    }

    public static CompletionItem c(String label, String newText, Range range, String documentation) {
        return MicroProfileAssert.c(label, new TextEdit(range, newText), null, (Either<String, MarkupContent>)(documentation != null ? Either.forLeft((Object)documentation) : null));
    }

    private static CompletionItem c(String label, TextEdit textEdit, String filterText, Either<String, MarkupContent> documentation) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(filterText);
        item.setTextEdit(textEdit);
        item.setDocumentation(documentation);
        return item;
    }

    public static Range r(int line, int startChar, int endChar) {
        return MicroProfileAssert.r(line, startChar, line, endChar);
    }

    public static Range r(int startLine, int startChar, int endLine, int endChar) {
        Position start = new Position(startLine, startChar);
        Position end = new Position(endLine, endChar);
        return new Range(start, end);
    }

    public static void assertCompletion(String value, TextDocumentSnippetRegistry registry, CompletionItem ... expectedItems) {
        MicroProfileAssert.assertCompletion(value, null, registry, expectedItems);
    }

    public static void assertCompletion(String value, Integer expectedCount, TextDocumentSnippetRegistry registry, CompletionItem ... expectedItems) {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, "application.properties");
        List items = registry.getCompletionItems(document, offset, true, context -> true);
        CompletionList actual = new CompletionList(items);
        MicroProfileAssert.assertCompletions(actual, expectedCount, expectedItems);
    }

    public static void assertCompletionWithProperties(String value, Integer expectedCount, Collection<String> propertyNames, CompletionItem ... expectedItems) {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        MicroProfileProjectInfo projectInfo = new MicroProfileProjectInfo();
        projectInfo.setProperties(propertyNames.stream().map(propertyName -> {
            ItemMetadata metadata = new ItemMetadata();
            metadata.setName(propertyName);
            return metadata;
        }).collect(Collectors.toList()));
        TextDocumentSnippetRegistry registry = new TextDocumentSnippetRegistry(LanguageId.properties.name());
        TextDocument document = new TextDocument(value, "application.properties");
        List items = registry.getCompletionItems(document, offset, true, context -> {
            if (context instanceof SnippetContextForProperties) {
                SnippetContextForProperties contextProperties = (SnippetContextForProperties)context;
                return contextProperties.isMatch(projectInfo);
            }
            return false;
        });
        CompletionList actual = new CompletionList(items);
        MicroProfileAssert.assertCompletions(actual, expectedCount, expectedItems);
    }

    public static void assertHoverMarkdown(String value, String expectedHoverLabel, Integer expectedHoverOffset) throws BadLocationException {
        MicroProfileHoverSettings hoverSettings = new MicroProfileHoverSettings();
        HoverCapabilities capabilities = new HoverCapabilities(Arrays.asList("markdown"), Boolean.valueOf(false));
        hoverSettings.setCapabilities(capabilities);
        MicroProfileAssert.assertHover(value, null, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), hoverSettings, expectedHoverLabel, expectedHoverOffset);
    }

    public static void assertHoverPlaintext(String value, String expectedHoverLabel, Integer expectedHoverOffset) throws BadLocationException {
        MicroProfileHoverSettings hoverSettings = new MicroProfileHoverSettings();
        HoverCapabilities capabilities = new HoverCapabilities(Arrays.asList("plaintext"), Boolean.valueOf(false));
        hoverSettings.setCapabilities(capabilities);
        MicroProfileAssert.assertHover(value, null, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), hoverSettings, expectedHoverLabel, expectedHoverOffset);
    }

    public static void assertHover(String value, String fileURI, MicroProfileProjectInfo projectInfo, MicroProfileHoverSettings hoverSettings, String expectedHoverLabel, Integer expectedHoverOffset) throws BadLocationException {
        int offset = value.indexOf("|");
        value = value.substring(0, offset) + value.substring(offset + 1);
        PropertiesModel model = MicroProfileAssert.parse(value, fileURI);
        Position position = model.positionAt(offset);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        Hover hover = languageService.doHover(model, position, projectInfo, hoverSettings);
        if (expectedHoverLabel == null) {
            Assert.assertNull((Object)hover);
        } else {
            String actualHoverLabel = MicroProfileAssert.getHoverLabel(hover);
            Assert.assertEquals((Object)expectedHoverLabel, (Object)actualHoverLabel);
            if (expectedHoverOffset != null) {
                Assert.assertNotNull((Object)hover.getRange());
                Assert.assertNotNull((Object)hover.getRange().getStart());
                Assert.assertEquals((long)expectedHoverOffset.intValue(), (long)hover.getRange().getStart().getCharacter());
            }
        }
    }

    private static String getHoverLabel(Hover hover) {
        Either contents;
        Either either = contents = hover != null ? hover.getContents() : null;
        if (contents == null) {
            return null;
        }
        return ((MarkupContent)contents.getRight()).getValue();
    }

    public static void testSymbolInformationsFor(String value, SymbolInformation ... expected) {
        MicroProfileAssert.testSymbolInformationsFor(value, null, expected);
    }

    public static void testSymbolInformationsFor(String value, String fileURI, SymbolInformation ... expected) {
        PropertiesModel model = MicroProfileAssert.parse(value, fileURI);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        List actual = languageService.findSymbolInformations(model, () -> {});
        MicroProfileAssert.assertSymbolInformations(actual, expected);
    }

    public static SymbolInformation s(String name, SymbolKind kind, String uri, Range range) {
        return new SymbolInformation(name, kind, new Location(uri, range));
    }

    public static void assertSymbolInformations(List<SymbolInformation> actual, SymbolInformation ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        Assert.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testDocumentSymbolsFor(String value, DocumentSymbol ... expected) {
        MicroProfileAssert.testDocumentSymbolsFor(value, null, expected);
    }

    public static void testDocumentSymbolsFor(String value, String fileURI, DocumentSymbol ... expected) {
        PropertiesModel model = MicroProfileAssert.parse(value, fileURI);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        List actual = languageService.findDocumentSymbols(model, () -> {});
        MicroProfileAssert.assertDocumentSymbols(actual, expected);
    }

    public static DocumentSymbol ds(String name, SymbolKind kind, Range range, String detail) {
        return MicroProfileAssert.ds(name, kind, range, detail, new ArrayList<DocumentSymbol>());
    }

    public static DocumentSymbol ds(String name, SymbolKind kind, Range range, String detail, List<DocumentSymbol> children) {
        return new DocumentSymbol(name, kind, range, range, detail, children);
    }

    public static void assertDocumentSymbols(List<DocumentSymbol> actual, DocumentSymbol ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        Assert.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testDefinitionFor(String value, LocationLink ... expected) throws BadLocationException, InterruptedException, ExecutionException {
        MicroProfileAssert.testDefinitionFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), MicroProfileAssert.getDefaultMicroProfilePropertyDefinitionProvider(), expected);
    }

    public static void testDefinitionFor(String value, MicroProfileProjectInfo projectInfo, MicroProfilePropertyDefinitionProvider definitionProvider, LocationLink ... expected) throws BadLocationException, InterruptedException, ExecutionException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        PropertiesModel document = MicroProfileAssert.parse(value, null);
        Position position = document.positionAt(offset);
        Either actual = (Either)languageService.findDefinition(document, position, projectInfo, definitionProvider, true).get();
        MicroProfileAssert.assertLocationLink((List)actual.getRight(), expected);
    }

    public static LocationLink ll(String uri, Range originRange, Range targetRange) {
        return new LocationLink(uri, targetRange, targetRange, originRange);
    }

    public static void assertLocationLink(List<? extends LocationLink> actual, LocationLink ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            actual.get(i).setTargetUri(actual.get(i).getTargetUri().replaceAll("file:///", "file:/"));
            expected[i].setTargetUri(expected[i].getTargetUri().replaceAll("file:///", "file:/"));
        }
        Assert.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testDiagnosticsFor(String value, Diagnostic ... expected) {
        MicroProfileAssert.testDiagnosticsFor(value, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), expected);
    }

    public static void testDiagnosticsFor(String value, MicroProfileProjectInfo projectInfo, Diagnostic ... expected) {
        MicroProfileValidationSettings validationSettings = new MicroProfileValidationSettings();
        MicroProfileAssert.testDiagnosticsFor(value, projectInfo, validationSettings, expected);
    }

    public static void testDiagnosticsFor(String value, MicroProfileProjectInfo projectInfo, MicroProfileValidationSettings validationSettings, Diagnostic ... expected) {
        MicroProfileAssert.testDiagnosticsFor(value, null, null, projectInfo, validationSettings, expected);
    }

    public static void testDiagnosticsFor(String value, Integer expectedCount, MicroProfileProjectInfo projectInfo, MicroProfileValidationSettings validationSettings, Diagnostic ... expected) {
        MicroProfileAssert.testDiagnosticsFor(value, null, expectedCount, projectInfo, validationSettings, expected);
    }

    public static void testDiagnosticsFor(String value, String fileURI, Integer expectedCount, MicroProfileProjectInfo projectInfo, MicroProfileValidationSettings validationSettings, Diagnostic ... expected) {
        PropertiesModel model = MicroProfileAssert.parse(value, fileURI);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        List actual = languageService.doDiagnostics(model, projectInfo, validationSettings, () -> {});
        if (expectedCount != null) {
            Assert.assertEquals((long)expectedCount.intValue(), (long)actual.size());
        }
        MicroProfileAssert.assertDiagnostics((List<Diagnostic>)actual, expected);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, Diagnostic ... expected) {
        MicroProfileAssert.assertDiagnostics(actual, Arrays.asList(expected));
    }

    public static void assertDiagnostics(List<Diagnostic> actual, List<Diagnostic> expected) {
        Assert.assertEquals((String)"Unexpected diagnostics:\n", expected, actual);
    }

    public static Diagnostic d(int line, int startCharacter, int endCharacter, String message, DiagnosticSeverity severity, ValidationType code) {
        return MicroProfileAssert.d(line, startCharacter, line, endCharacter, message, severity, code);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, String message, DiagnosticSeverity severity, ValidationType code) {
        return new Diagnostic(MicroProfileAssert.r(startLine, startCharacter, endLine, endCharacter), message, severity, MICROPROFILE_DIAGNOSTIC_SOURCE, code.name());
    }

    public static void testCodeActionsFor(String value, Diagnostic diagnostic, CodeAction ... expected) {
        MicroProfileAssert.testCodeActionsFor(value, diagnostic, MicroProfileAssert.getDefaultMicroProfileProjectInfo(), new MicroProfileFormattingSettings(), expected);
    }

    public static void testCodeActionsFor(String value, Diagnostic diagnostic, MicroProfileProjectInfo projectInfo, CodeAction ... expected) {
        MicroProfileAssert.testCodeActionsFor(value, Collections.singletonList(diagnostic), diagnostic.getRange(), projectInfo, new MicroProfileFormattingSettings(), expected);
    }

    public static void testCodeActionsFor(String value, Diagnostic diagnostic, MicroProfileProjectInfo projectInfo, MicroProfileFormattingSettings formattingSettings, CodeAction ... expected) {
        MicroProfileAssert.testCodeActionsFor(value, Collections.singletonList(diagnostic), diagnostic.getRange(), projectInfo, formattingSettings, expected);
    }

    public static void testCodeActionsFor(String value, List<Diagnostic> diagnostics, Range range, MicroProfileProjectInfo projectInfo, CodeAction ... expected) {
        MicroProfileAssert.testCodeActionsFor(value, diagnostics, range, projectInfo, new MicroProfileFormattingSettings(), expected);
    }

    public static void testCodeActionsFor(String value, List<Diagnostic> diagnostics, Range range, MicroProfileProjectInfo projectInfo, MicroProfileFormattingSettings formattingSettings, CodeAction ... expected) {
        PropertiesModel model = MicroProfileAssert.parse(value, null);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(diagnostics);
        MicroProfileCommandCapabilities mpCommandCapabilities = new MicroProfileCommandCapabilities();
        List<String> valueSet = Arrays.asList("quarkus.command.configuration.update");
        CommandKindCapabilities commandKindCapabilities = new CommandKindCapabilities(valueSet);
        CommandCapabilities commandCapabilities = new CommandCapabilities(commandKindCapabilities);
        mpCommandCapabilities.setCapabilities(commandCapabilities);
        List actual = languageService.doCodeActions(context, range, model, projectInfo, formattingSettings, mpCommandCapabilities);
        MicroProfileAssert.assertCodeActions(actual, expected);
    }

    public static void assertCodeActions(List<CodeAction> actual, CodeAction ... expected) {
        actual.stream().forEach(ca -> {
            ca.setKind(null);
            if (ca.getDiagnostics() != null) {
                ca.getDiagnostics().forEach(d -> {
                    d.setSeverity(null);
                    d.setMessage("");
                    d.setSource(null);
                });
            }
        });
        Assert.assertEquals((long)expected.length, (long)actual.size());
        Assert.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static CodeAction ca(String title, TextEdit te, Diagnostic ... d) {
        return MicroProfileAssert.ca(title, te, null, d);
    }

    public static CodeAction ca(String title, Command command, Diagnostic ... d) {
        return MicroProfileAssert.ca(title, null, command, d);
    }

    public static CodeAction ca(String title, TextEdit te, Command command, Diagnostic ... d) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (int i = 0; i < d.length; ++i) {
            diagnostics.add(d[i]);
        }
        return MicroProfileAssert.ca(title, te, command, diagnostics);
    }

    public static CodeAction ca(String title, TextEdit te, Command command, List<Diagnostic> diagnostics) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setDiagnostics(diagnostics);
        codeAction.setCommand(command);
        if (te != null) {
            VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier("application.properties", Integer.valueOf(0));
            TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Collections.singletonList(te));
            WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
            codeAction.setEdit(workspaceEdit);
        }
        return codeAction;
    }

    public static TextEdit te(int startLine, int startCharacter, int endLine, int endCharacter, String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newText);
        textEdit.setRange(MicroProfileAssert.r(startLine, startCharacter, endLine, endCharacter));
        return textEdit;
    }

    public static void assertFormat(String value, String expected, boolean insertSpaces) {
        MicroProfileFormattingSettings formattingSettings = new MicroProfileFormattingSettings();
        formattingSettings.setSurroundEqualsWithSpaces(insertSpaces);
        MicroProfileAssert.assertFormat(value, expected, formattingSettings);
    }

    public static void assertFormat(String value, String expected, MicroProfileFormattingSettings formattingSettings) {
        PropertiesModel model = MicroProfileAssert.parse(value, null);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        List edits = languageService.doFormat(model, formattingSettings);
        String formatted = edits.stream().map(edit -> edit.getNewText()).collect(Collectors.joining(""));
        Assert.assertEquals((Object)expected, (Object)formatted);
    }

    public static void assertRangeFormat(String value, String expected, boolean insertSpaces) throws BadLocationException {
        MicroProfileFormattingSettings formattingSettings = new MicroProfileFormattingSettings();
        formattingSettings.setSurroundEqualsWithSpaces(insertSpaces);
        MicroProfileAssert.assertRangeFormat(value, expected, formattingSettings);
    }

    public static void assertRangeFormat(String value, String expected, MicroProfileFormattingSettings formattingSettings) throws BadLocationException {
        int startOffset = value.indexOf("|");
        value = value.substring(0, startOffset) + value.substring(startOffset + 1);
        int endOffset = value.indexOf("|");
        value = value.substring(0, endOffset) + value.substring(endOffset + 1);
        TextDocument document = new TextDocument(value, "application.properties");
        Range range = PositionUtils.createRange((int)startOffset, (int)endOffset, (TextDocument)document);
        PropertiesModel model = MicroProfileAssert.parse(value, null);
        MicroProfileLanguageService languageService = new MicroProfileLanguageService();
        List edits = languageService.doRangeFormat(model, range, formattingSettings);
        Range formatRange = ((TextEdit)edits.get(0)).getRange();
        int formatStart = document.offsetAt(formatRange.getStart());
        int formatEnd = document.offsetAt(formatRange.getEnd());
        String formatted = value.substring(0, formatStart) + edits.stream().map(edit -> edit.getNewText()).collect(Collectors.joining("")) + value.substring(formatEnd);
        Assert.assertEquals((Object)expected, (Object)formatted);
    }

    private static PropertiesModel parse(String text, String uri) {
        TextDocument document = new TextDocument(text, uri != null ? uri : "application.properties");
        return PropertiesModel.parse((TextDocument)document);
    }
}

