/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.redhat.microprofile.settings.AllMicroProfileSettings;
import com.redhat.microprofile.settings.InitializationOptionsSettings;
import com.redhat.microprofile.settings.MicroProfileGeneralClientSettings;
import org.eclipse.lsp4j.InitializeParams;
import org.junit.Assert;
import org.junit.Test;

public class SettingsTest {
    private final String json = "{\r\n    \"settings\": {\r\n        \"quarkus\": {\r\n            \"tools\": {\r\n                \"trace\": {\r\n                    \"server\": \"verbose\"\r\n                },\r\n                \"starter\": {\r\n                    \"api\": \"http://code.quarkus.io/api\",\r\n                    \"defaults\": {}\r\n                },\r\n                \"symbols\": {\r\n                    \"showAsTree\": true\r\n                },\r\n                \"validation\": {\r\n                    \"enabled\": \"true\",\r\n                    \"unknown\": {\r\n                        \"severity\": \"error\",\r\n                        \"excluded\": [\r\n                            \"abcd\"\r\n                        ]\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n}";

    @Test
    public void initializationOptionsSettings() {
        InitializeParams params = SettingsTest.createInitializeParams("{\r\n    \"settings\": {\r\n        \"quarkus\": {\r\n            \"tools\": {\r\n                \"trace\": {\r\n                    \"server\": \"verbose\"\r\n                },\r\n                \"starter\": {\r\n                    \"api\": \"http://code.quarkus.io/api\",\r\n                    \"defaults\": {}\r\n                },\r\n                \"symbols\": {\r\n                    \"showAsTree\": true\r\n                },\r\n                \"validation\": {\r\n                    \"enabled\": \"true\",\r\n                    \"unknown\": {\r\n                        \"severity\": \"error\",\r\n                        \"excluded\": [\r\n                            \"abcd\"\r\n                        ]\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n}");
        Object initializationOptionsSettings = InitializationOptionsSettings.getSettings((InitializeParams)params);
        initializationOptionsSettings = AllMicroProfileSettings.getMicroProfileToolsSettings((Object)initializationOptionsSettings);
        MicroProfileGeneralClientSettings settings = MicroProfileGeneralClientSettings.getGeneralMicroProfileSettings((Object)initializationOptionsSettings);
        Assert.assertNotNull((Object)settings);
        Assert.assertNotNull((Object)settings.getSymbols());
        Assert.assertEquals((Object)true, (Object)settings.getSymbols().isShowAsTree());
        Assert.assertNotNull((Object)settings.getValidation());
        Assert.assertEquals((Object)"error", (Object)settings.getValidation().getUnknown().getSeverity());
        Assert.assertEquals((Object)"error", (Object)settings.getValidation().getSyntax().getSeverity());
        Assert.assertEquals((Object)"warning", (Object)settings.getValidation().getDuplicate().getSeverity());
        Assert.assertEquals((Object)"error", (Object)settings.getValidation().getValue().getSeverity());
        Assert.assertEquals((Object)"none", (Object)settings.getValidation().getRequired().getSeverity());
    }

    private static InitializeParams createInitializeParams(String json) {
        InitializeParams initializeParams = new InitializeParams();
        Object initializationOptions = new Gson().fromJson(json, JsonObject.class);
        initializeParams.setInitializationOptions(initializationOptions);
        return initializeParams;
    }
}

