/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings.capabilities;

import com.redhat.microprofile.settings.capabilities.ClientCapabilitiesWrapper;
import com.redhat.microprofile.settings.capabilities.MicroProfileCapabilityManager;
import com.redhat.microprofile.settings.capabilities.ServerCapabilitiesConstants;
import com.redhat.microprofile.settings.capabilities.ServerCapabilitiesInitializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MicroProfileCapabilitiesTest {
    private LanguageClient languageClient = new LanguageClientMock();
    private MicroProfileCapabilityManager manager;
    private ClientCapabilities clientCapabilities;
    private TextDocumentClientCapabilities textDocument;
    private WorkspaceClientCapabilities workspace;
    private Set<String> capabilityIDs;

    @Before
    public void startup() {
        this.textDocument = new TextDocumentClientCapabilities();
        this.workspace = new WorkspaceClientCapabilities();
        this.manager = new MicroProfileCapabilityManager(this.languageClient);
        this.clientCapabilities = new ClientCapabilities();
        this.capabilityIDs = null;
    }

    @Test
    public void testAllDynamicCapabilities() {
        this.setAllCapabilities(true);
        this.setAndInitializeCapabilities();
        Assert.assertEquals((long)2L, (long)this.capabilityIDs.size());
        Assert.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.COMPLETION_ID));
        Assert.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.HOVER_ID));
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities());
        Assert.assertEquals(null, (Object)serverCapabilities.getCompletionProvider());
        Assert.assertEquals((Object)false, (Object)serverCapabilities.getHoverProvider());
    }

    @Test
    public void testNoDynamicCapabilities() {
        this.setAllCapabilities(false);
        this.setAndInitializeCapabilities();
        Assert.assertEquals((long)0L, (long)this.capabilityIDs.size());
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities());
        Assert.assertEquals((Object)ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS, (Object)serverCapabilities.getCompletionProvider());
        Assert.assertEquals((Object)true, (Object)serverCapabilities.getHoverProvider());
    }

    @Test
    public void testBothCapabilityTypes() {
        CompletionCapabilities completion = new CompletionCapabilities();
        completion.setDynamicRegistration(Boolean.valueOf(true));
        this.textDocument.setCompletion(completion);
        this.textDocument.setHover(new HoverCapabilities(Boolean.valueOf(false)));
        this.setAndInitializeCapabilities();
        Assert.assertEquals((long)1L, (long)this.capabilityIDs.size());
        Assert.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.COMPLETION_ID));
        Assert.assertEquals((Object)false, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.HOVER_ID));
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities());
        Assert.assertEquals((Object)true, (Object)serverCapabilities.getHoverProvider());
        Assert.assertEquals(null, (Object)serverCapabilities.getCompletionProvider());
    }

    private void setAllCapabilities(boolean areAllDynamic) {
        CompletionCapabilities completion = new CompletionCapabilities();
        completion.setDynamicRegistration(Boolean.valueOf(areAllDynamic));
        this.textDocument.setCompletion(completion);
        this.textDocument.setHover(new HoverCapabilities(Boolean.valueOf(areAllDynamic)));
    }

    private void setAndInitializeCapabilities() {
        this.clientCapabilities.setTextDocument(this.textDocument);
        this.clientCapabilities.setWorkspace(this.workspace);
        this.manager.setClientCapabilities(this.clientCapabilities, null);
        this.manager.initializeCapabilities();
        this.capabilityIDs = this.manager.getRegisteredCapabilities();
    }

    class LanguageClientMock
    implements LanguageClient {
        LanguageClientMock() {
        }

        public void telemetryEvent(Object object) {
        }

        public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        }

        public void showMessage(MessageParams messageParams) {
        }

        public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
            return null;
        }

        public void logMessage(MessageParams message) {
        }

        public CompletableFuture<Void> registerCapability(RegistrationParams params) {
            return null;
        }
    }
}

