/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.DocumentFormat;
import com.redhat.microprofile.commons.MicroProfileJavaCodeActionParams;
import com.redhat.microprofile.commons.MicroProfileJavaCodeLensParams;
import com.redhat.microprofile.commons.MicroProfileJavaDiagnosticsParams;
import com.redhat.microprofile.commons.MicroProfileJavaHoverParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.AbstractTextDocumentService;
import com.redhat.microprofile.ls.JavaTextDocuments;
import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.snippets.TextDocumentSnippetRegistry;
import com.redhat.microprofile.settings.MicroProfileCodeLensSettings;
import com.redhat.microprofile.settings.SharedSettings;
import com.redhat.microprofile.snippets.SnippetContextForJava;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class JavaTextDocumentService
extends AbstractTextDocumentService {
    private static final Logger LOGGER = Logger.getLogger(JavaTextDocumentService.class.getName());
    private final MicroProfileLanguageServer microprofileLanguageServer;
    private final SharedSettings sharedSettings;
    private final JavaTextDocuments documents;
    private TextDocumentSnippetRegistry snippetRegistry;

    public JavaTextDocumentService(MicroProfileLanguageServer microprofileLanguageServer, SharedSettings sharedSettings) {
        this.microprofileLanguageServer = microprofileLanguageServer;
        this.sharedSettings = sharedSettings;
        this.documents = new JavaTextDocuments(microprofileLanguageServer);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.triggerValidationFor((JavaTextDocuments.JavaTextDocument)((Object)this.documents.onDidOpenTextDocument(params)));
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.triggerValidationFor((JavaTextDocuments.JavaTextDocument)((Object)this.documents.onDidChangeTextDocument(params)));
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documents.onDidCloseTextDocument(params);
        String uri = params.getTextDocument().getUri();
        this.microprofileLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, new ArrayList()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.triggerValidationForAll(null);
    }

    @Override
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        JavaTextDocuments.JavaTextDocument document = (JavaTextDocuments.JavaTextDocument)((Object)this.documents.get(params.getTextDocument().getUri()));
        return document.executeIfInMicroProfileProject(projectInfo -> CompletableFutures.computeAsync(cancel -> {
            try {
                int completionOffset = document.offsetAt(params.getPosition());
                boolean canSupportMarkdown = true;
                CompletionList list = new CompletionList();
                list.setItems(new ArrayList());
                this.documents.getSnippetRegistry().getCompletionItems(document, completionOffset, canSupportMarkdown, context -> {
                    if (context != null && context instanceof SnippetContextForJava) {
                        return ((SnippetContextForJava)context).isMatch((ProjectLabelInfoEntry)projectInfo);
                    }
                    return true;
                }).forEach(item -> list.getItems().add(item));
                return Either.forRight((Object)list);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "Error while getting java completions", e);
                return Either.forRight(null);
            }
        }), Either.forLeft(Collections.emptyList()));
    }

    public void updateCodeLensSettings(MicroProfileCodeLensSettings newCodeLens) {
        this.sharedSettings.getCodeLensSettings().setUrlCodeLensEnabled(newCodeLens.isUrlCodeLensEnabled());
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        boolean urlCodeLensEnabled = this.sharedSettings.getCodeLensSettings().isUrlCodeLensEnabled();
        if (!urlCodeLensEnabled) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        JavaTextDocuments.JavaTextDocument document = (JavaTextDocuments.JavaTextDocument)((Object)this.documents.get(params.getTextDocument().getUri()));
        return document.executeIfInMicroProfileProject(projectInfo -> {
            MicroProfileJavaCodeLensParams javaParams = new MicroProfileJavaCodeLensParams(params.getTextDocument().getUri());
            if (this.sharedSettings.getCommandCapabilities().isCommandSupported("quarkus.command.open.uri")) {
                javaParams.setOpenURICommand("quarkus.command.open.uri");
            }
            javaParams.setCheckServerAvailable(true);
            javaParams.setUrlCodeLensEnabled(urlCodeLensEnabled);
            return this.microprofileLanguageServer.getLanguageClient().getJavaCodelens(javaParams);
        }, Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        JavaTextDocuments.JavaTextDocument document = (JavaTextDocuments.JavaTextDocument)((Object)this.documents.get(params.getTextDocument().getUri()));
        return document.executeIfInMicroProfileProject(projectInfo -> {
            MicroProfileJavaCodeActionParams javaParams = new MicroProfileJavaCodeActionParams();
            javaParams.setTextDocument(params.getTextDocument());
            javaParams.setRange(params.getRange());
            javaParams.setContext(params.getContext());
            javaParams.setResourceOperationSupported(this.microprofileLanguageServer.getCapabilityManager().getClientCapabilities().isResourceOperationSupported());
            return this.microprofileLanguageServer.getLanguageClient().getJavaCodeAction(javaParams).thenApply(codeActions -> codeActions.stream().map(ca -> {
                Either e = Either.forRight((Object)ca);
                return e;
            }).collect(Collectors.toList()));
        }, Collections.emptyList());
    }

    @Override
    public CompletableFuture<Hover> hover(HoverParams params) {
        JavaTextDocuments.JavaTextDocument document = (JavaTextDocuments.JavaTextDocument)((Object)this.documents.get(params.getTextDocument().getUri()));
        return document.executeIfInMicroProfileProject(projectinfo -> {
            boolean markdownSupported = this.sharedSettings.getHoverSettings().isContentFormatSupported("markdown");
            DocumentFormat documentFormat = markdownSupported ? DocumentFormat.Markdown : DocumentFormat.PlainText;
            MicroProfileJavaHoverParams javaParams = new MicroProfileJavaHoverParams(params.getTextDocument().getUri(), params.getPosition(), documentFormat);
            return this.microprofileLanguageServer.getLanguageClient().getJavaHover(javaParams);
        }, null);
    }

    private void triggerValidationFor(JavaTextDocuments.JavaTextDocument document) {
        document.executeIfInMicroProfileProject(projectinfo -> {
            String uri = document.getUri();
            this.triggerValidationFor(Arrays.asList(uri));
            return null;
        }, null);
    }

    private void triggerValidationForAll(Set<String> projectURIs) {
        this.triggerValidationFor(this.documents.all().stream().filter(document -> projectURIs == null || projectURIs.contains(document.getProjectURI())).filter(JavaTextDocuments.JavaTextDocument::isInMicroProfileProject).map(TextDocumentItem::getUri).collect(Collectors.toList()));
    }

    private void triggerValidationFor(List<String> uris) {
        if (uris.isEmpty()) {
            return;
        }
        MicroProfileJavaDiagnosticsParams javaParams = new MicroProfileJavaDiagnosticsParams(uris);
        boolean markdownSupported = this.sharedSettings.getHoverSettings().isContentFormatSupported("markdown");
        if (markdownSupported) {
            javaParams.setDocumentFormat(DocumentFormat.Markdown);
        }
        this.microprofileLanguageServer.getLanguageClient().getJavaDiagnostics(javaParams).thenApply(diagnostics -> {
            if (diagnostics == null) {
                return null;
            }
            for (PublishDiagnosticsParams diagnostic : diagnostics) {
                this.microprofileLanguageServer.getLanguageClient().publishDiagnostics(diagnostic);
            }
            return null;
        });
    }

    public void propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        if (this.documents.propertiesChanged(event)) {
            this.triggerValidationForAll(event.getProjectURIs());
        }
    }
}

