/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.ILineTracker;
import com.redhat.microprofile.ls.commons.Line;
import com.redhat.microprofile.ls.commons.ListLineTracker;
import com.redhat.microprofile.ls.commons.TreeLineTracker;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;

public class TextDocument
extends TextDocumentItem {
    private static final Logger LOGGER = Logger.getLogger(TextDocument.class.getName());
    private final Object lock = new Object();
    private static String DEFAULT_DELIMTER = System.lineSeparator();
    private ILineTracker lineTracker;
    private boolean incremental;

    public TextDocument(TextDocumentItem document) {
        this(document.getText(), document.getUri());
        super.setVersion(document.getVersion());
        super.setLanguageId(document.getLanguageId());
    }

    public TextDocument(String text, String uri) {
        super.setUri(uri);
        super.setText(text);
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
        this.lineTracker = null;
        this.getLineTracker();
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public Position positionAt(int position) throws BadLocationException {
        ILineTracker lineTracker = this.getLineTracker();
        return lineTracker.getPositionAt(position);
    }

    public Range lineRangeAt(int position) throws BadLocationException {
        ILineTracker lineTracker = this.getLineTracker();
        Line line = lineTracker.getLineInformationOfOffset(position);
        int lineNumber = lineTracker.getLineNumberOfOffset(position);
        return new Range(new Position(lineNumber, 0), new Position(lineNumber, line.length));
    }

    public int offsetAt(Position position) throws BadLocationException {
        ILineTracker lineTracker = this.getLineTracker();
        return lineTracker.getOffsetAt(position);
    }

    public String lineText(int lineNumber) throws BadLocationException {
        ILineTracker lineTracker = this.getLineTracker();
        Line line = lineTracker.getLineInformation(lineNumber);
        String text = super.getText();
        return text.substring(line.offset, line.offset + line.length);
    }

    public String lineDelimiter(int lineNumber) throws BadLocationException {
        ILineTracker lineTracker = this.getLineTracker();
        String lineDelimiter = lineTracker.getLineDelimiter(lineNumber);
        if (lineDelimiter == null && lineTracker.getNumberOfLines() > 0) {
            lineDelimiter = lineTracker.getLineInformation((int)0).delimiter;
        }
        if (lineDelimiter == null) {
            lineDelimiter = DEFAULT_DELIMTER;
        }
        return lineDelimiter;
    }

    public Range getWordRangeAt(int textOffset, Pattern wordDefinition) {
        try {
            Position pos = this.positionAt(textOffset);
            ILineTracker lineTracker = this.getLineTracker();
            Line line = lineTracker.getLineInformation(pos.getLine());
            String text = super.getText();
            String lineText = text.substring(line.offset, textOffset);
            int position = lineText.length();
            Matcher m = wordDefinition.matcher(lineText);
            int currentPosition = 0;
            while (currentPosition != position) {
                if (m.find()) {
                    currentPosition = m.end();
                    if (currentPosition == position) {
                        return new Range(new Position(pos.getLine(), m.start()), pos);
                    }
                } else {
                    ++currentPosition;
                }
                m.region(currentPosition, position);
            }
            return new Range(pos, pos);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private ILineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = this.createLineTracker();
        }
        return this.lineTracker;
    }

    private synchronized ILineTracker createLineTracker() {
        if (this.lineTracker != null) {
            return this.lineTracker;
        }
        ILineTracker lineTracker = this.isIncremental() ? new TreeLineTracker(new ListLineTracker()) : new ListLineTracker();
        lineTracker.set(super.getText());
        return lineTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<TextDocumentContentChangeEvent> changes) {
        if (changes.size() < 1) {
            return;
        }
        if (this.isIncremental()) {
            try {
                long start = System.currentTimeMillis();
                Object object = this.lock;
                synchronized (object) {
                    StringBuilder buffer = new StringBuilder(this.getText());
                    for (int i = 0; i < changes.size(); ++i) {
                        TextDocumentContentChangeEvent changeEvent = changes.get(i);
                        Range range = changeEvent.getRange();
                        int length = 0;
                        if (range != null) {
                            length = changeEvent.getRangeLength();
                        } else {
                            length = buffer.length();
                            range = new Range(this.positionAt(0), this.positionAt(length));
                        }
                        String text = changeEvent.getText();
                        int startOffset = this.offsetAt(range.getStart());
                        buffer.replace(startOffset, startOffset + length, text);
                        this.lineTracker.replace(startOffset, length, text);
                    }
                    this.setText(buffer.toString());
                }
                LOGGER.fine("Text document content updated in " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (BadLocationException start) {}
        } else {
            TextDocumentContentChangeEvent last;
            TextDocumentContentChangeEvent textDocumentContentChangeEvent = last = changes.size() > 0 ? changes.get(changes.size() - 1) : null;
            if (last != null) {
                this.setText(last.getText());
                this.lineTracker.set(last.getText());
            }
        }
    }
}

