/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.model.Assign;
import com.redhat.microprofile.model.Comments;
import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;
import com.redhat.microprofile.model.parser.ErrorEvent;
import com.redhat.microprofile.model.parser.ErrorHandler;
import com.redhat.microprofile.model.parser.ParseContext;
import com.redhat.microprofile.model.parser.ParseException;
import com.redhat.microprofile.model.parser.PropertiesHandler;
import com.redhat.microprofile.model.parser.PropertiesParser;
import org.eclipse.lsp4j.Position;

public class PropertiesModel
extends Node {
    private final TextDocument document;

    PropertiesModel(TextDocument document) {
        this.document = document;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.DOCUMENT;
    }

    public static PropertiesModel parse(String text, String uri) {
        return PropertiesModel.parse(new TextDocument(text, uri));
    }

    public static PropertiesModel parse(TextDocument document) {
        PropertiesModel model = new PropertiesModel(document);
        PropertiesParser parser = new PropertiesParser();
        parser.parse(document.getText(), new PropertiesModelHandler(model), new ErrorHandler(){

            @Override
            public void error(ParseContext context, ErrorEvent errorEvent) throws ParseException {
            }
        });
        return model;
    }

    public String getText(int start, int end, boolean skipMultiLine) {
        String text = this.document.getText();
        if (!skipMultiLine) {
            return text.substring(start, end);
        }
        StringBuilder sb = new StringBuilder();
        int i = start;
        boolean trimLeading = false;
        while (i < end) {
            char curr = text.charAt(i);
            if (curr == '\\') {
                if (i < end - 1 && text.charAt(i + 1) == '\n') {
                    i += 2;
                    trimLeading = true;
                    continue;
                }
                if (i < end - 2 && text.charAt(i + 1) == '\r' && text.charAt(i + 2) == '\n') {
                    i += 3;
                    trimLeading = true;
                    continue;
                }
            }
            if (!trimLeading || !Character.isWhitespace(curr)) {
                trimLeading = false;
                sb.append(curr);
            }
            ++i;
        }
        return sb.toString();
    }

    public int offsetAt(Position position) throws BadLocationException {
        return this.document.offsetAt(position);
    }

    public Position positionAt(int position) throws BadLocationException {
        return this.document.positionAt(position);
    }

    @Override
    public PropertiesModel getOwnerModel() {
        return this;
    }

    @Override
    public TextDocument getDocument() {
        return this.document;
    }

    @Override
    public String getText() {
        return this.document.getText();
    }

    public String getDocumentURI() {
        return this.getDocument().getUri();
    }

    private static class PropertiesModelHandler
    implements PropertiesHandler {
        private final PropertiesModel model;
        private Property property;
        private Comments comment;

        public PropertiesModelHandler(PropertiesModel model) {
            this.model = model;
        }

        @Override
        public void startDocument(ParseContext context) {
            this.model.setStart(0);
        }

        @Override
        public void endDocument(ParseContext context) {
            this.model.setEnd(context.getLocationOffset());
        }

        @Override
        public void startProperty(ParseContext context) {
            this.property = new Property();
            this.property.setStart(context.getLocationOffset());
            this.model.addNode(this.property);
        }

        @Override
        public void startPropertyName(ParseContext context) {
            PropertyKey key = new PropertyKey();
            key.setStart(context.getLocationOffset());
            this.property.setKey(key);
        }

        @Override
        public void endPropertyName(ParseContext context) {
            PropertyKey key = this.property.getKey();
            key.setEnd(context.getLocationOffset());
        }

        @Override
        public void startPropertyValue(ParseContext context) {
            PropertyValue value = new PropertyValue();
            value.setStart(context.getLocationOffset());
            this.property.setValue(value);
        }

        @Override
        public void endPropertyValue(ParseContext context) {
            PropertyValue value = this.property.getValue();
            value.setEnd(context.getLocationOffset());
        }

        @Override
        public void endProperty(ParseContext context) {
            this.property.setEnd(context.getLocationOffset());
            this.property = null;
        }

        @Override
        public void startComment(ParseContext context) {
            this.comment = new Comments();
            this.comment.setStart(context.getLocationOffset());
            this.model.addNode(this.comment);
        }

        @Override
        public void endComment(ParseContext context) {
            this.comment.setEnd(context.getLocationOffset());
            this.comment = null;
        }

        @Override
        public void delimiterAssign(ParseContext context) {
            Assign assign = new Assign();
            assign.setStart(context.getLocationOffset());
            assign.setEnd(context.getLocationOffset() + 1);
            this.property.setDelimiterAssign(assign);
        }

        @Override
        public void blankLine(ParseContext context) {
        }
    }
}

