/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model.values;

import com.google.gson.Gson;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.values.ValuesDefinition;
import com.redhat.microprofile.model.values.ValuesRule;
import com.redhat.microprofile.model.values.ValuesRulesDescriptor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValuesRulesManager {
    private final Map<String, List<ItemHint.ValueHint>> definitionsMap = new HashMap<String, List<ItemHint.ValueHint>>();
    private final List<ValuesRule> rules = new ArrayList<ValuesRule>();
    private boolean withDefault;

    public ValuesRulesManager(boolean withDefault) {
        this.withDefault = withDefault;
    }

    private void load(InputStream in) {
        ValuesRulesDescriptor descriptor = (ValuesRulesDescriptor)new Gson().fromJson((Reader)new InputStreamReader(in), ValuesRulesDescriptor.class);
        if (descriptor.getDefinitions() != null) {
            this.registerDefinitions(descriptor.getDefinitions());
        }
        if (descriptor.getRules() != null) {
            this.registerRules(descriptor.getRules());
        }
    }

    public void registerDefinitions(List<ValuesDefinition> definitions) {
        definitions.forEach(def -> this.definitionsMap.put(def.getId(), def.getValues()));
    }

    public void registerRules(List<ValuesRule> rules) {
        this.rules.addAll(rules);
        rules.stream().filter(rule -> rule.getValuesRef() != null).forEach(rule -> rule.getValuesRef().forEach(ref -> {
            List<ItemHint.ValueHint> refValues;
            ArrayList<ItemHint.ValueHint> values = new ArrayList<ItemHint.ValueHint>();
            List<ItemHint.ValueHint> staticValues = rule.getValues();
            if (staticValues != null) {
                values.addAll(staticValues);
            }
            if ((refValues = this.definitionsMap.get(ref)) != null) {
                values.addAll(refValues);
            }
            rule.setValues(values);
        }));
    }

    public void unregisterRules(List<ValuesRule> rules) {
        this.rules.removeAll(rules);
    }

    public List<ItemHint.ValueHint> getValues(ItemMetadata metadata, PropertiesModel model) {
        for (ValuesRule rule : this.getRules()) {
            if (!rule.match(metadata, model)) continue;
            return rule.getValues();
        }
        return null;
    }

    public boolean isValidEnum(ItemMetadata metadata, PropertiesModel model, String propertyValue) {
        List<ItemHint.ValueHint> enums = this.getValues(metadata, model);
        return enums == null || this.getValueHint(propertyValue, metadata, model) != null;
    }

    public ItemHint.ValueHint getValueHint(String propertyValue, ItemMetadata metadata, PropertiesModel model) {
        List<ItemHint.ValueHint> enums = this.getValues(metadata, model);
        return this.getValue(propertyValue, enums);
    }

    private ItemHint.ValueHint getValue(String value, List<ItemHint.ValueHint> values) {
        if (values == null || value == null) {
            return null;
        }
        for (ItemHint.ValueHint valueHint : values) {
            if (!value.equals(valueHint.getValue())) continue;
            return valueHint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValuesRule> getRules() {
        if (this.isDefaultNotLoaded()) {
            List<ValuesRule> list = this.rules;
            synchronized (list) {
                if (this.isDefaultNotLoaded()) {
                    this.load(ValuesRulesManager.class.getResourceAsStream("quarkus-values-rules.json"));
                }
            }
        }
        return this.rules;
    }

    private boolean isDefaultNotLoaded() {
        return this.withDefault && this.rules.isEmpty();
    }
}

