/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.utils.PositionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

class MicroProfileFormatter {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileFormatter.class.getName());

    MicroProfileFormatter() {
    }

    public List<? extends TextEdit> format(PropertiesModel document, MicroProfileFormattingSettings formattingSettings) {
        Range fullRange = PositionUtils.createRange(document);
        if (fullRange == null) {
            return null;
        }
        return this.format(document, fullRange, formattingSettings);
    }

    public List<? extends TextEdit> format(PropertiesModel document, Range range, MicroProfileFormattingSettings formattingSettings) {
        int startOffset = -1;
        int endOffset = -1;
        String lineDelimiter = null;
        try {
            MicroProfileFormatter.enlargeRangeToGutters(range, document.getDocument());
            startOffset = document.offsetAt(range.getStart());
            endOffset = document.offsetAt(range.getEnd());
            lineDelimiter = document.getDocument().lineDelimiter(range.getStart().getLine());
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Formatting failed due to BadLocation", e);
            return null;
        }
        StringBuilder formattedContent = new StringBuilder();
        for (Node child : document.getChildren()) {
            if (child.getStart() < startOffset || child.getEnd() > endOffset) continue;
            if (child.getNodeType() == Node.NodeType.PROPERTY) {
                Property property = (Property)child;
                MicroProfileFormatter.formatPropertyAndAdd(property, formattingSettings.isSurroundEqualsWithSpaces(), lineDelimiter, formattedContent);
                continue;
            }
            if (child.getNodeType() != Node.NodeType.COMMENTS) continue;
            formattedContent.append(child.getText());
            formattedContent.append(lineDelimiter);
        }
        return Arrays.asList(new TextEdit(range, formattedContent.toString().trim()));
    }

    private static void enlargeRangeToGutters(Range range, TextDocument textDocument) throws BadLocationException {
        Position start = range.getStart();
        Position end = range.getEnd();
        start.setCharacter(0);
        if (end.getCharacter() == 0 && end.getLine() > 0) {
            end.setLine(end.getLine() - 1);
        }
        end.setCharacter(textDocument.lineText(end.getLine()).length());
    }

    private static void formatPropertyAndAdd(Property property, boolean insertSpaces, String lineDelimiter, StringBuilder formattedContent) {
        boolean valueExists;
        boolean keyExists = property.getKey() != null;
        boolean delimiterExists = property.getDelimiterAssign() != null;
        boolean bl = valueExists = property.getValue() != null;
        if (!delimiterExists && !valueExists) {
            formattedContent.append(property.getText().trim());
            formattedContent.append(lineDelimiter);
            return;
        }
        if (keyExists) {
            formattedContent.append(property.getKey().getText());
        }
        if (delimiterExists) {
            if (insertSpaces) {
                formattedContent.append(" ");
            }
            formattedContent.append("=");
        }
        if (valueExists) {
            if (insertSpaces) {
                formattedContent.append(" ");
            }
            formattedContent.append(property.getValue().getText().trim());
        }
        if (keyExists || delimiterExists || valueExists) {
            formattedContent.append(lineDelimiter);
        }
    }
}

