/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.ls.api.MicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.values.ValuesRulesManager;
import com.redhat.microprofile.services.MicroProfileCodeActions;
import com.redhat.microprofile.services.MicroProfileCompletions;
import com.redhat.microprofile.services.MicroProfileDefinition;
import com.redhat.microprofile.services.MicroProfileDiagnostics;
import com.redhat.microprofile.services.MicroProfileFormatter;
import com.redhat.microprofile.services.MicroProfileHover;
import com.redhat.microprofile.services.MicroProfileSymbolsProvider;
import com.redhat.microprofile.settings.MicroProfileCommandCapabilities;
import com.redhat.microprofile.settings.MicroProfileCompletionSettings;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileHoverSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class MicroProfileLanguageService {
    private final MicroProfileCompletions completions = new MicroProfileCompletions();
    private final MicroProfileSymbolsProvider symbolsProvider = new MicroProfileSymbolsProvider();
    private final MicroProfileHover hover = new MicroProfileHover();
    private final MicroProfileDefinition definition = new MicroProfileDefinition();
    private final MicroProfileDiagnostics diagnostics = new MicroProfileDiagnostics();
    private final MicroProfileFormatter formatter = new MicroProfileFormatter();
    private final MicroProfileCodeActions codeActions = new MicroProfileCodeActions();
    private final ValuesRulesManager valuesRulesManager;

    public MicroProfileLanguageService() {
        this(new ValuesRulesManager(true));
    }

    public MicroProfileLanguageService(ValuesRulesManager valuesRulesManger) {
        this.valuesRulesManager = valuesRulesManger;
    }

    public CompletionList doComplete(PropertiesModel document, Position position, MicroProfileProjectInfo projectInfo, MicroProfileCompletionSettings completionSettings, MicroProfileFormattingSettings formattingSettings, CancelChecker cancelChecker) {
        return this.completions.doComplete(document, position, projectInfo, this.getValuesRulesManager(), completionSettings, formattingSettings, cancelChecker);
    }

    public Hover doHover(PropertiesModel document, Position position, MicroProfileProjectInfo projectInfo, MicroProfileHoverSettings hoverSettings) {
        return this.hover.doHover(document, position, projectInfo, this.getValuesRulesManager(), hoverSettings);
    }

    public List<SymbolInformation> findSymbolInformations(PropertiesModel document, CancelChecker cancelChecker) {
        return this.symbolsProvider.findSymbolInformations(document, cancelChecker);
    }

    public List<DocumentSymbol> findDocumentSymbols(PropertiesModel document, CancelChecker cancelChecker) {
        return this.symbolsProvider.findDocumentSymbols(document, cancelChecker);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> findDefinition(PropertiesModel document, Position position, MicroProfileProjectInfo projectInfo, MicroProfilePropertyDefinitionProvider provider, boolean definitionLinkSupport) {
        return this.definition.findDefinition(document, position, projectInfo, provider, definitionLinkSupport);
    }

    public List<? extends TextEdit> doFormat(PropertiesModel document, MicroProfileFormattingSettings formattingSettings) {
        return this.formatter.format(document, formattingSettings);
    }

    public List<? extends TextEdit> doRangeFormat(PropertiesModel document, Range range, MicroProfileFormattingSettings formattingSettings) {
        return this.formatter.format(document, range, formattingSettings);
    }

    public List<Diagnostic> doDiagnostics(PropertiesModel document, MicroProfileProjectInfo projectInfo, MicroProfileValidationSettings validationSettings, CancelChecker cancelChecker) {
        return this.diagnostics.doDiagnostics(document, projectInfo, this.getValuesRulesManager(), validationSettings, cancelChecker);
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, PropertiesModel document, MicroProfileProjectInfo projectInfo, MicroProfileFormattingSettings formattingSettings, MicroProfileCommandCapabilities commandCapabilities) {
        return this.codeActions.doCodeActions(context, range, document, projectInfo, this.getValuesRulesManager(), formattingSettings, commandCapabilities);
    }

    private ValuesRulesManager getValuesRulesManager() {
        return this.valuesRulesManager;
    }
}

