/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.metadata.ItemHint;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class QuarkusModel {
    public static final ItemHint DEFAULT_PROFILES = QuarkusModel.createDefaultProfiles();
    public static final ItemHint BOOLEAN_ENUMS = QuarkusModel.createBooleanEnums();

    private QuarkusModel() {
    }

    public static List<String> getDefaultProfileNames() {
        return DEFAULT_PROFILES.getValues().stream().map(ItemHint.ValueHint::getValue).collect(Collectors.toList());
    }

    private static ItemHint createDefaultProfiles() {
        ItemHint item = QuarkusModel.createItem("quarkus.profiles");
        item.getValues().add(QuarkusModel.createValue("dev", "Profile activated when in development mode (quarkus:dev)."));
        item.getValues().add(QuarkusModel.createValue("prod", "The default profile when not running in development or test mode."));
        item.getValues().add(QuarkusModel.createValue("test", "Profile activated when running tests."));
        return item;
    }

    private static ItemHint createItem(String name) {
        ItemHint item = new ItemHint();
        item.setName(name);
        item.setValues(new ArrayList<ItemHint.ValueHint>());
        return item;
    }

    private static ItemHint.ValueHint createValue(String value, String description) {
        ItemHint.ValueHint valueHint = new ItemHint.ValueHint();
        valueHint.setValue(value);
        valueHint.setDescription(description);
        return valueHint;
    }

    private static ItemHint createBooleanEnums() {
        ItemHint item = QuarkusModel.createItem("quarkus.boolean");
        item.getValues().add(QuarkusModel.createValue("false", null));
        item.getValues().add(QuarkusModel.createValue("true", null));
        return item;
    }
}

