/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings;

import com.redhat.microprofile.settings.MicroProfileValidationTypeSettings;

public class MicroProfileValidationSettings {
    public static final MicroProfileValidationSettings DEFAULT;
    private static final MicroProfileValidationTypeSettings DEFAULT_SYNTAX;
    private static final MicroProfileValidationTypeSettings DEFAULT_UNKNOWN;
    private static final MicroProfileValidationTypeSettings DEFAULT_DUPLICATE;
    private static final MicroProfileValidationTypeSettings DEFAULT_VALUE;
    private static final MicroProfileValidationTypeSettings DEFAULT_REQUIRED;
    private transient boolean updated;
    private boolean enabled;
    private MicroProfileValidationTypeSettings syntax;
    private MicroProfileValidationTypeSettings unknown;
    private MicroProfileValidationTypeSettings duplicate;
    private MicroProfileValidationTypeSettings value;
    private MicroProfileValidationTypeSettings required;

    public MicroProfileValidationSettings() {
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public MicroProfileValidationTypeSettings getSyntax() {
        this.updateDefault();
        return this.syntax;
    }

    public void setSyntax(MicroProfileValidationTypeSettings syntax) {
        this.syntax = syntax;
        this.updated = false;
    }

    public MicroProfileValidationTypeSettings getUnknown() {
        this.updateDefault();
        return this.unknown;
    }

    public void setUnknown(MicroProfileValidationTypeSettings unknown) {
        this.unknown = unknown;
        this.updated = false;
    }

    public MicroProfileValidationTypeSettings getDuplicate() {
        this.updateDefault();
        return this.duplicate;
    }

    public void setDuplicate(MicroProfileValidationTypeSettings duplicate) {
        this.duplicate = duplicate;
        this.updated = false;
    }

    public MicroProfileValidationTypeSettings getRequired() {
        this.updateDefault();
        return this.required;
    }

    public void setRequired(MicroProfileValidationTypeSettings required) {
        this.required = required;
        this.updated = false;
    }

    public MicroProfileValidationTypeSettings getValue() {
        this.updateDefault();
        return this.value;
    }

    public void setValue(MicroProfileValidationTypeSettings value) {
        this.value = value;
        this.updated = false;
    }

    private void updateDefault() {
        if (this.updated) {
            return;
        }
        this.setSyntax(this.syntax != null ? this.syntax : DEFAULT_SYNTAX);
        this.setUnknown(this.unknown != null ? this.unknown : DEFAULT_UNKNOWN);
        this.setDuplicate(this.duplicate != null ? this.duplicate : DEFAULT_DUPLICATE);
        this.setValue(this.value != null ? this.value : DEFAULT_VALUE);
        this.setRequired(this.required != null ? this.required : DEFAULT_REQUIRED);
        this.updated = true;
    }

    public void update(MicroProfileValidationSettings newValidation) {
        this.setEnabled(newValidation.isEnabled());
        this.setSyntax(newValidation.getSyntax());
        this.setUnknown(newValidation.getUnknown());
        this.setDuplicate(newValidation.getDuplicate());
        this.setRequired(newValidation.getRequired());
        this.setValue(newValidation.getValue());
    }

    static {
        DEFAULT_SYNTAX = new MicroProfileValidationTypeSettings();
        DEFAULT_SYNTAX.setSeverity(Severity.error.name());
        DEFAULT_UNKNOWN = new MicroProfileValidationTypeSettings();
        DEFAULT_UNKNOWN.setSeverity(Severity.warning.name());
        DEFAULT_DUPLICATE = new MicroProfileValidationTypeSettings();
        DEFAULT_DUPLICATE.setSeverity(Severity.warning.name());
        DEFAULT_VALUE = new MicroProfileValidationTypeSettings();
        DEFAULT_VALUE.setSeverity(Severity.error.name());
        DEFAULT_REQUIRED = new MicroProfileValidationTypeSettings();
        DEFAULT_REQUIRED.setSeverity(Severity.none.name());
        DEFAULT = new MicroProfileValidationSettings();
        DEFAULT.updateDefault();
    }

    private static enum Severity {
        none,
        error,
        warning;

    }
}

