/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings.capabilities;

import com.redhat.microprofile.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.microprofile.settings.capabilities.ClientCapabilitiesWrapper;
import com.redhat.microprofile.settings.capabilities.IMicroProfileRegistrationConfiguration;
import com.redhat.microprofile.settings.capabilities.ServerCapabilitiesConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.services.LanguageClient;

public class MicroProfileCapabilityManager {
    private final Set<String> registeredCapabilities = new HashSet<String>(3);
    private final LanguageClient languageClient;
    private ClientCapabilitiesWrapper clientWrapper;
    private TextDocumentRegistrationOptions formattingRegistrationOptions;
    private final List<IMicroProfileRegistrationConfiguration> registrationConfigurations;
    private boolean registrationConfigurationsInitialized;

    public MicroProfileCapabilityManager(LanguageClient languageClient) {
        this.languageClient = languageClient;
        this.registrationConfigurations = new ArrayList<IMicroProfileRegistrationConfiguration>();
    }

    public void initializeCapabilities() {
        if (this.getClientCapabilities().isCodeActionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.CODE_ACTION_ID, "textDocument/codeAction");
        }
        if (this.getClientCapabilities().isCodeLensDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.CODE_LENS_ID, "textDocument/codeLens");
        }
        if (this.getClientCapabilities().isCompletionDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.COMPLETION_ID, "textDocument/completion", ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (this.getClientCapabilities().isHoverDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.HOVER_ID, "textDocument/hover");
        }
        if (this.getClientCapabilities().isDocumentSymbolDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol");
        }
        if (this.getClientCapabilities().isDefinitionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DEFINITION_ID, "textDocument/definition");
        }
        if (this.getClientCapabilities().isFormattingDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.FORMATTING_ID, "textDocument/formatting", this.getFormattingRegistrationOptions());
        }
        if (this.getClientCapabilities().isFormattingDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.RANGE_FORMATTING_ID, "textDocument/rangeFormatting", this.getFormattingRegistrationOptions());
        }
    }

    private TextDocumentRegistrationOptions getFormattingRegistrationOptions() {
        if (this.formattingRegistrationOptions == null) {
            ArrayList<DocumentFilter> documentSelector = new ArrayList<DocumentFilter>();
            documentSelector.add(new DocumentFilter("microprofile-properties", null, null));
            this.formattingRegistrationOptions = new TextDocumentRegistrationOptions(documentSelector);
        }
        return this.formattingRegistrationOptions;
    }

    public void setClientCapabilities(ClientCapabilities clientCapabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        this.clientWrapper = new ClientCapabilitiesWrapper(clientCapabilities, extendedClientCapabilities);
    }

    public ClientCapabilitiesWrapper getClientCapabilities() {
        if (this.clientWrapper == null) {
            this.clientWrapper = new ClientCapabilitiesWrapper();
        }
        return this.clientWrapper;
    }

    public Set<String> getRegisteredCapabilities() {
        return this.registeredCapabilities;
    }

    private void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    private void registerCapability(String id, String method, Object options) {
        if (this.registeredCapabilities.add(id)) {
            Registration registration = new Registration(id, method, options);
            RegistrationParams registrationParams = new RegistrationParams(Collections.singletonList(registration));
            this.getRegistrationConfigurations().forEach(config -> config.configure(registration));
            this.languageClient.registerCapability(registrationParams);
        }
    }

    private List<IMicroProfileRegistrationConfiguration> getRegistrationConfigurations() {
        if (!this.registrationConfigurationsInitialized) {
            this.initializeRegistrationConfigurations();
        }
        return this.registrationConfigurations;
    }

    private synchronized void initializeRegistrationConfigurations() {
        if (this.registrationConfigurationsInitialized) {
            return;
        }
        ServiceLoader<IMicroProfileRegistrationConfiguration> extensions = ServiceLoader.load(IMicroProfileRegistrationConfiguration.class);
        extensions.forEach(extension -> this.registrationConfigurations.add((IMicroProfileRegistrationConfiguration)extension));
        this.registrationConfigurationsInitialized = true;
    }
}

