/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.snippets;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnippetContextForProperties
implements ISnippetContext<MicroProfileProjectInfo> {
    public static final TypeAdapter<SnippetContextForProperties> TYPE_ADAPTER = new SnippetContextForPropertiesAdapter();
    private List<String> properties;

    public SnippetContextForProperties(List<String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean isMatch(MicroProfileProjectInfo projectInfo) {
        for (String propertyName : this.properties) {
            ItemMetadata metadata = MicroProfilePropertiesUtils.getProperty(propertyName, projectInfo);
            if (metadata != null) continue;
            return false;
        }
        return true;
    }

    private static class SnippetContextForPropertiesAdapter
    extends TypeAdapter<SnippetContextForProperties> {
        private SnippetContextForPropertiesAdapter() {
        }

        public SnippetContextForProperties read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ArrayList<String> properties = new ArrayList<String>();
            in.beginObject();
            block6: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "properties": {
                        if (in.peek() == JsonToken.BEGIN_ARRAY) {
                            in.beginArray();
                            while (in.peek() != JsonToken.END_ARRAY) {
                                properties.add(in.nextString());
                            }
                            in.endArray();
                            continue block6;
                        }
                        properties.add(in.nextString());
                        continue block6;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new SnippetContextForProperties(properties);
        }

        public void write(JsonWriter writer, SnippetContextForProperties value) throws IOException {
        }
    }
}

