/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.commons.metadata;

import io.quarkus.runtime.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ConverterKind {
    KEBAB_CASE(1),
    VERBATIM(2);

    private final int value;
    private static final String HYPHEN = "-";
    private static final Pattern PATTERN;

    private ConverterKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ConverterKind forValue(int value) {
        ConverterKind[] allValues = ConverterKind.values();
        if (value < 1 || value > allValues.length) {
            throw new IllegalArgumentException("Illegal enum value: " + value);
        }
        return allValues[value - 1];
    }

    public static String convert(String value, ConverterKind converterKind) {
        if (converterKind == null || value == null) {
            return value;
        }
        switch (converterKind) {
            case KEBAB_CASE: {
                return ConverterKind.hyphenate(value);
            }
        }
        return value;
    }

    private static String hyphenate(String value) {
        StringBuffer target = new StringBuffer();
        String hyphenate = StringUtil.hyphenate(value);
        Matcher matcher = PATTERN.matcher(hyphenate);
        while (matcher.find()) {
            matcher.appendReplacement(target, HYPHEN);
        }
        matcher.appendTail(target);
        return target.toString();
    }

    static {
        PATTERN = Pattern.compile("([-_]+)");
    }
}

