/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.DocumentFormat;
import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.ls.AbstractTextDocumentService;
import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.MicroProfileProjectInfoCache;
import com.redhat.microprofile.ls.api.MicroProfileLanguageServerAPI;
import com.redhat.microprofile.ls.commons.ModelTextDocument;
import com.redhat.microprofile.ls.commons.ModelTextDocuments;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.services.MicroProfileLanguageService;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileSymbolSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.SharedSettings;
import com.redhat.microprofile.utils.JSONSchemaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ApplicationPropertiesTextDocumentService
extends AbstractTextDocumentService {
    private final ModelTextDocuments<PropertiesModel> documents;
    private MicroProfileProjectInfoCache projectInfoCache;
    private final MicroProfileLanguageServer microprofileLanguageServer;
    private final SharedSettings sharedSettings;
    private boolean hierarchicalDocumentSymbolSupport;
    private boolean definitionLinkSupport;
    private DocumentFormat documentFormat;

    public ApplicationPropertiesTextDocumentService(MicroProfileLanguageServer microProfileLanguageServer, SharedSettings sharedSettings) {
        this.microprofileLanguageServer = microProfileLanguageServer;
        this.documents = new ModelTextDocuments<PropertiesModel>((document, cancelChecker) -> PropertiesModel.parse(document));
        this.sharedSettings = sharedSettings;
        this.documentFormat = DocumentFormat.PlainText;
    }

    public void updateClientCapabilities(ClientCapabilities capabilities) {
        TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
        if (textDocumentClientCapabilities != null) {
            this.hierarchicalDocumentSymbolSupport = textDocumentClientCapabilities.getDocumentSymbol() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != false;
            boolean bl = this.definitionLinkSupport = textDocumentClientCapabilities.getDefinition() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != false;
            if (textDocumentClientCapabilities.getCompletion() != null && textDocumentClientCapabilities.getCompletion().getCompletionItem() != null && textDocumentClientCapabilities.getCompletion().getCompletionItem().getDocumentationFormat() != null && textDocumentClientCapabilities.getCompletion().getCompletionItem().getDocumentationFormat().contains("markdown")) {
                this.documentFormat = DocumentFormat.Markdown;
            } else if (textDocumentClientCapabilities.getHover() != null && textDocumentClientCapabilities.getHover().getContentFormat() != null && textDocumentClientCapabilities.getHover().getContentFormat().contains("markdown")) {
                this.documentFormat = DocumentFormat.Markdown;
            }
        }
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.documents.onDidOpenTextDocument(params));
        this.triggerValidationFor(document);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.documents.onDidChangeTextDocument(params));
        this.triggerValidationFor(document);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documents.onDidCloseTextDocument(params);
        TextDocumentIdentifier document = params.getTextDocument();
        String uri = document.getUri();
        this.microprofileLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, new ArrayList()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    @Override
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        MicroProfileProjectInfoParams projectInfoParams = this.createProjectInfoParams(params.getTextDocument());
        return this.getProjectInfoCache().getProjectInfo(projectInfoParams).thenComposeAsync(projectInfo -> {
            if (projectInfo.getProperties().isEmpty()) {
                return CompletableFuture.completedFuture(Either.forRight((Object)new CompletionList()));
            }
            return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> {
                CompletionList list = this.getMicroProfileLanguageService().doComplete((PropertiesModel)document, params.getPosition(), (MicroProfileProjectInfo)projectInfo, this.sharedSettings.getCompletionSettings(), this.sharedSettings.getFormattingSettings(), null);
                return Either.forRight((Object)list);
            });
        });
    }

    @Override
    public CompletableFuture<Hover> hover(HoverParams params) {
        MicroProfileProjectInfoParams projectInfoParams = this.createProjectInfoParams(params.getTextDocument());
        return this.getProjectInfoCache().getProjectInfo(projectInfoParams).thenComposeAsync(projectInfo -> {
            if (projectInfo.getProperties().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> this.getMicroProfileLanguageService().doHover((PropertiesModel)document, params.getPosition(), (MicroProfileProjectInfo)projectInfo, this.sharedSettings.getHoverSettings()));
        });
    }

    @Override
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> {
            if (this.hierarchicalDocumentSymbolSupport && this.sharedSettings.getSymbolSettings().isShowAsTree()) {
                return this.getMicroProfileLanguageService().findDocumentSymbols((PropertiesModel)document, (CancelChecker)cancelChecker).stream().map(s -> {
                    Either e = Either.forRight((Object)s);
                    return e;
                }).collect(Collectors.toList());
            }
            return this.getMicroProfileLanguageService().findSymbolInformations((PropertiesModel)document, (CancelChecker)cancelChecker).stream().map(s -> {
                Either e = Either.forLeft((Object)s);
                return e;
            }).collect(Collectors.toList());
        });
    }

    @Override
    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        MicroProfileProjectInfoParams projectInfoParams = this.createProjectInfoParams(params.getTextDocument());
        return this.getProjectInfoCache().getProjectInfo(projectInfoParams).thenComposeAsync(projectInfo -> {
            if (projectInfo.getProperties().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getDocument(params.getTextDocument().getUri()).getModel().thenComposeAsync(document -> this.getMicroProfileLanguageService().findDefinition((PropertiesModel)document, params.getPosition(), (MicroProfileProjectInfo)projectInfo, this.microprofileLanguageServer.getLanguageClient(), this.definitionLinkSupport));
        });
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> this.getMicroProfileLanguageService().doFormat((PropertiesModel)document, this.sharedSettings.getFormattingSettings()));
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> this.getMicroProfileLanguageService().doRangeFormat((PropertiesModel)document, params.getRange(), this.sharedSettings.getFormattingSettings()));
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        MicroProfileProjectInfoParams projectInfoParams = this.createProjectInfoParams(params.getTextDocument());
        return this.getProjectInfoCache().getProjectInfo(projectInfoParams).thenComposeAsync(projectInfo -> {
            if (projectInfo.getProperties().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPropertiesModel(params.getTextDocument(), (CancelChecker cancelChecker, PropertiesModel document) -> this.getMicroProfileLanguageService().doCodeActions(params.getContext(), params.getRange(), (PropertiesModel)document, (MicroProfileProjectInfo)projectInfo, this.sharedSettings.getFormattingSettings(), this.sharedSettings.getCommandCapabilities()).stream().map(ca -> {
                Either e = Either.forRight((Object)ca);
                return e;
            }).collect(Collectors.toList()));
        });
    }

    private MicroProfileProjectInfoParams createProjectInfoParams(TextDocumentIdentifier id) {
        return this.createProjectInfoParams(id.getUri());
    }

    private MicroProfileProjectInfoParams createProjectInfoParams(String uri) {
        MicroProfileProjectInfoParams params = new MicroProfileProjectInfoParams(uri);
        params.setDocumentFormat(this.documentFormat);
        return params;
    }

    private MicroProfileLanguageService getMicroProfileLanguageService() {
        return this.microprofileLanguageServer.getMicroProfileLanguageService();
    }

    private void triggerValidationFor(ModelTextDocument<PropertiesModel> document) {
        MicroProfileProjectInfoParams projectInfoParams = this.createProjectInfoParams(document.getUri());
        this.getProjectInfoCache().getProjectInfo(projectInfoParams).thenComposeAsync(projectInfo -> {
            if (projectInfo.getProperties().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.getPropertiesModel(document, (CancelChecker cancelChecker, PropertiesModel model) -> {
                List<Diagnostic> diagnostics = this.getMicroProfileLanguageService().doDiagnostics((PropertiesModel)model, (MicroProfileProjectInfo)projectInfo, this.getSharedSettings().getValidationSettings(), (CancelChecker)cancelChecker);
                this.microprofileLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(model.getDocumentURI(), diagnostics));
                return null;
            });
        });
    }

    public ModelTextDocument<PropertiesModel> getDocument(String uri) {
        return (ModelTextDocument)((Object)this.documents.get(uri));
    }

    public <R> CompletableFuture<R> getPropertiesModel(TextDocumentIdentifier documentIdentifier, BiFunction<CancelChecker, PropertiesModel, R> code) {
        return this.getPropertiesModel(this.getDocument(documentIdentifier.getUri()), code);
    }

    public <R> CompletableFuture<R> getPropertiesModel(ModelTextDocument<PropertiesModel> document, BiFunction<CancelChecker, PropertiesModel, R> code) {
        return ApplicationPropertiesTextDocumentService.computeModelAsync(document.getModel(), code);
    }

    private static <R, M> CompletableFuture<R> computeModelAsync(CompletableFuture<M> loadModel, BiFunction<CancelChecker, M, R> code) {
        CompletableFuture<CancelChecker> start = new CompletableFuture<CancelChecker>();
        CompletionStage result = start.thenCombineAsync(loadModel, code);
        CancelChecker cancelIndicator = () -> ApplicationPropertiesTextDocumentService.lambda$computeModelAsync$17((CompletableFuture)result);
        start.complete(cancelIndicator);
        return result;
    }

    public void propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        Collection<String> uris = this.getProjectInfoCache().propertiesChanged(event);
        for (String uri : uris) {
            ModelTextDocument<PropertiesModel> document = this.getDocument(uri);
            if (document == null) continue;
            this.triggerValidationFor(document);
        }
    }

    public void updateSymbolSettings(MicroProfileSymbolSettings newSettings) {
        MicroProfileSymbolSettings symbolSettings = this.sharedSettings.getSymbolSettings();
        symbolSettings.setShowAsTree(newSettings.isShowAsTree());
    }

    public void updateValidationSettings(MicroProfileValidationSettings newValidation) {
        MicroProfileValidationSettings validation = this.sharedSettings.getValidationSettings();
        validation.update(newValidation);
        this.documents.all().stream().forEach(document -> this.triggerValidationFor((ModelTextDocument<PropertiesModel>)((Object)document)));
    }

    public void updateFormattingSettings(MicroProfileFormattingSettings newFormatting) {
        MicroProfileFormattingSettings formatting = this.sharedSettings.getFormattingSettings();
        formatting.setSurroundEqualsWithSpaces(newFormatting.isSurroundEqualsWithSpaces());
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    private MicroProfileProjectInfoCache getProjectInfoCache() {
        if (this.projectInfoCache == null) {
            this.createProjectInfoCache();
        }
        return this.projectInfoCache;
    }

    private synchronized void createProjectInfoCache() {
        if (this.projectInfoCache != null) {
            return;
        }
        this.projectInfoCache = new MicroProfileProjectInfoCache(this.microprofileLanguageServer.getLanguageClient());
    }

    public CompletableFuture<MicroProfileLanguageServerAPI.JsonSchemaForProjectInfo> getJsonSchemaForProjectInfo(MicroProfileProjectInfoParams params) {
        return this.getProjectInfoCache().getProjectInfo(params).thenApply(info -> {
            String jsonSchema = JSONSchemaUtils.toJSONSchema(info, true);
            return new MicroProfileLanguageServerAPI.JsonSchemaForProjectInfo(info.getProjectURI(), jsonSchema);
        });
    }

    private static /* synthetic */ void lambda$computeModelAsync$17(CompletableFuture result) {
        if (result.isCancelled()) {
            throw new CancellationException();
        }
    }
}

