/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileJavaProjectLabelsParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.MicroProfilePropertiesScope;
import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.JavaTextDocumentSnippetRegistry;
import com.redhat.microprofile.ls.MicroProfileProjectInfoCache;
import com.redhat.microprofile.ls.api.MicroProfileJavaProjectLabelsProvider;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.ls.commons.TextDocuments;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.TextDocumentItem;

class JavaTextDocuments
extends TextDocuments<JavaTextDocument> {
    private static final String MICROPROFILE_PROJECT_LABEL = "microprofile";
    private static final Logger LOGGER = Logger.getLogger(MicroProfileProjectInfoCache.class.getName());
    private final Map<String, CompletableFuture<ProjectLabelInfoEntry>> documentCache;
    private final Map<String, CompletableFuture<ProjectLabelInfoEntry>> projectCache;
    private final MicroProfileJavaProjectLabelsProvider provider;
    private JavaTextDocumentSnippetRegistry snippetRegistry;

    JavaTextDocuments(MicroProfileJavaProjectLabelsProvider provider) {
        this.provider = provider;
        this.documentCache = new ConcurrentHashMap<String, CompletableFuture<ProjectLabelInfoEntry>>();
        this.projectCache = new ConcurrentHashMap<String, CompletableFuture<ProjectLabelInfoEntry>>();
    }

    @Override
    public JavaTextDocument createDocument(TextDocumentItem document) {
        JavaTextDocument doc = new JavaTextDocument(document);
        doc.setIncremental(this.isIncremental());
        return doc;
    }

    private CompletableFuture<ProjectLabelInfoEntry> getProjectInfo(JavaTextDocument document) {
        return this.getProjectInfoFromCache(document).exceptionally(ex -> {
            LOGGER.log(Level.WARNING, String.format("Error while getting ProjectLabelInfoEntry (classpath) for '%s'", document.getUri()), (Throwable)ex);
            return null;
        });
    }

    CompletableFuture<ProjectLabelInfoEntry> getProjectInfoFromCache(JavaTextDocument document) {
        String projectURI = document.getProjectURI();
        String documentURI = document.getUri();
        CompletableFuture<ProjectLabelInfoEntry> projectInfo = null;
        projectInfo = projectURI != null ? this.projectCache.get(projectURI) : this.documentCache.get(documentURI);
        if (projectInfo == null || projectInfo.isCancelled() || projectInfo.isCompletedExceptionally()) {
            MicroProfileJavaProjectLabelsParams params = new MicroProfileJavaProjectLabelsParams();
            params.setUri(documentURI);
            params.setTypes(this.getSnippetRegistry().getTypes());
            CompletableFuture<ProjectLabelInfoEntry> future = this.provider.getJavaProjectlabels(params);
            future.thenApply(entry -> {
                if (entry != null) {
                    String newProjectURI = entry.getUri();
                    this.projectCache.put(newProjectURI, future);
                    document.setProjectURI(newProjectURI);
                    this.documentCache.remove(documentURI);
                }
                return entry;
            });
            this.documentCache.put(documentURI, future);
            return future;
        }
        return projectInfo;
    }

    public boolean propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        List<MicroProfilePropertiesScope> scopes = event.getType();
        boolean changedOnlyInSources = MicroProfilePropertiesScope.isOnlySources(scopes);
        if (!changedOnlyInSources && event.getProjectURIs() != null) {
            this.classpathChanged(event.getProjectURIs());
            return true;
        }
        return false;
    }

    private void classpathChanged(Set<String> projectURIs) {
        projectURIs.forEach(this.projectCache::remove);
    }

    private static boolean isMicroProfileProject(ProjectLabelInfoEntry projectInfo) {
        return projectInfo != null && projectInfo.hasLabel(MICROPROFILE_PROJECT_LABEL);
    }

    public JavaTextDocumentSnippetRegistry getSnippetRegistry() {
        if (this.snippetRegistry == null) {
            this.snippetRegistry = new JavaTextDocumentSnippetRegistry();
        }
        return this.snippetRegistry;
    }

    public class JavaTextDocument
    extends TextDocument {
        private String projectURI;

        public JavaTextDocument(TextDocumentItem document) {
            super(document);
        }

        public String getProjectURI() {
            return this.projectURI;
        }

        public void setProjectURI(String projectURI) {
            this.projectURI = projectURI;
        }

        public <T> CompletableFuture<T> executeIfInMicroProfileProject(Function<ProjectLabelInfoEntry, CompletableFuture<T>> code, T defaultValue) {
            return JavaTextDocuments.this.getProjectInfo(this).thenComposeAsync(projectInfo -> {
                if (!JavaTextDocuments.isMicroProfileProject(projectInfo)) {
                    return CompletableFuture.completedFuture(defaultValue);
                }
                return (CompletionStage)code.apply((ProjectLabelInfoEntry)projectInfo);
            });
        }

        public boolean isInMicroProfileProject() {
            ProjectLabelInfoEntry projectInfo = JavaTextDocuments.this.getProjectInfo(this).getNow(null);
            return JavaTextDocuments.isMicroProfileProject(projectInfo);
        }
    }
}

