/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileJavaProjectLabelsParams;
import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.MicroProfileTextDocumentService;
import com.redhat.microprofile.ls.MicroProfileWorkspaceService;
import com.redhat.microprofile.ls.api.MicroProfileJavaProjectLabelsProvider;
import com.redhat.microprofile.ls.api.MicroProfileLanguageClientAPI;
import com.redhat.microprofile.ls.api.MicroProfileLanguageServerAPI;
import com.redhat.microprofile.ls.commons.ParentProcessWatcher;
import com.redhat.microprofile.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.microprofile.ls.commons.client.InitializationOptionsExtendedClientCapabilities;
import com.redhat.microprofile.services.MicroProfileLanguageService;
import com.redhat.microprofile.settings.AllMicroProfileSettings;
import com.redhat.microprofile.settings.InitializationOptionsSettings;
import com.redhat.microprofile.settings.MicroProfileCodeLensSettings;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileGeneralClientSettings;
import com.redhat.microprofile.settings.MicroProfileSymbolSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.capabilities.MicroProfileCapabilityManager;
import com.redhat.microprofile.settings.capabilities.ServerCapabilitiesInitializer;
import com.redhat.microprofile.utils.VersionHelper;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class MicroProfileLanguageServer
implements LanguageServer,
ParentProcessWatcher.ProcessLanguageServer,
MicroProfileLanguageServerAPI,
MicroProfileJavaProjectLabelsProvider {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileLanguageServer.class.getName());
    private final MicroProfileLanguageService microProfileLanguageService = new MicroProfileLanguageService();
    private final MicroProfileTextDocumentService textDocumentService = new MicroProfileTextDocumentService(this);
    private final WorkspaceService workspaceService = new MicroProfileWorkspaceService(this);
    private Integer parentProcessId;
    private MicroProfileLanguageClientAPI languageClient;
    private MicroProfileCapabilityManager capabilityManager;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        LOGGER.info("Initializing MicroProfile server " + VersionHelper.getVersion() + " with " + System.getProperty("java.home"));
        this.parentProcessId = params.getProcessId();
        ExtendedClientCapabilities extendedClientCapabilities = InitializationOptionsExtendedClientCapabilities.getExtendedClientCapabilities(params);
        this.capabilityManager.setClientCapabilities(params.getCapabilities(), extendedClientCapabilities);
        this.updateSettings(InitializationOptionsSettings.getSettings(params));
        this.textDocumentService.updateClientCapabilities(params.getCapabilities(), extendedClientCapabilities);
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities(this.capabilityManager.getClientCapabilities());
        InitializeResult initializeResult = new InitializeResult(serverCapabilities);
        return CompletableFuture.completedFuture(initializeResult);
    }

    public void initialized(InitializedParams params) {
        this.capabilityManager.initializeCapabilities();
    }

    public synchronized void updateSettings(Object initializationOptionsSettings) {
        if (initializationOptionsSettings == null) {
            return;
        }
        MicroProfileGeneralClientSettings clientSettings = MicroProfileGeneralClientSettings.getGeneralMicroProfileSettings(initializationOptionsSettings = AllMicroProfileSettings.getMicroProfileToolsSettings(initializationOptionsSettings));
        if (clientSettings != null) {
            MicroProfileCodeLensSettings newCodeLens;
            MicroProfileFormattingSettings newFormatting;
            MicroProfileValidationSettings newValidation;
            MicroProfileSymbolSettings newSymbols = clientSettings.getSymbols();
            if (newSymbols != null) {
                this.textDocumentService.updateSymbolSettings(newSymbols);
            }
            if ((newValidation = clientSettings.getValidation()) != null) {
                this.textDocumentService.updateValidationSettings(newValidation);
            }
            if ((newFormatting = clientSettings.getFormatting()) != null) {
                this.textDocumentService.updateFormattingSettings(newFormatting);
            }
            if ((newCodeLens = clientSettings.getCodeLens()) != null) {
                this.textDocumentService.updateCodeLensSettings(newCodeLens);
            }
        }
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFutures.computeAsync(cc -> new Object());
    }

    public void exit() {
        this.exit(0);
    }

    @Override
    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public MicroProfileLanguageClientAPI getLanguageClient() {
        return this.languageClient;
    }

    public MicroProfileCapabilityManager getCapabilityManager() {
        return this.capabilityManager;
    }

    public void setClient(LanguageClient languageClient) {
        this.languageClient = (MicroProfileLanguageClientAPI)languageClient;
        this.capabilityManager = new MicroProfileCapabilityManager(languageClient);
    }

    @Override
    public long getParentProcessId() {
        return this.parentProcessId != null ? (long)this.parentProcessId.intValue() : 0L;
    }

    public MicroProfileLanguageService getMicroProfileLanguageService() {
        return this.microProfileLanguageService;
    }

    @Override
    public void propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        this.textDocumentService.propertiesChanged(event);
    }

    @Override
    public CompletableFuture<MicroProfileLanguageServerAPI.JsonSchemaForProjectInfo> getJsonSchemaForProjectInfo(MicroProfileProjectInfoParams params) {
        return this.textDocumentService.getJsonSchemaForProjectInfo(params);
    }

    @Override
    public CompletableFuture<ProjectLabelInfoEntry> getJavaProjectlabels(MicroProfileJavaProjectLabelsParams javaParams) {
        return this.getLanguageClient().getJavaProjectlabels(javaParams);
    }
}

