/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.commons.MicroProfilePropertiesScope;
import com.redhat.microprofile.commons.metadata.ItemBase;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.api.MicroProfileProjectInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class MicroProfileProjectInfoCache {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileProjectInfoCache.class.getName());
    private final Map<String, CompletableFuture<MicroProfileProjectInfo>> cache;
    private final MicroProfileProjectInfoProvider provider;

    public MicroProfileProjectInfoCache(MicroProfileProjectInfoProvider provider) {
        this.provider = provider;
        this.cache = new ConcurrentHashMap<String, CompletableFuture<MicroProfileProjectInfo>>();
    }

    public CompletableFuture<MicroProfileProjectInfo> getProjectInfo(MicroProfileProjectInfoParams params) {
        return this.getProjectInfoFromCache(params).exceptionally(ex -> {
            LOGGER.log(Level.WARNING, String.format("Error while getting MicroProfileProjectInfo (classpath) for '%s'", params.getUri()), (Throwable)ex);
            return MicroProfileProjectInfo.EMPTY_PROJECT_INFO;
        });
    }

    CompletableFuture<MicroProfileProjectInfo> getProjectInfoFromCache(MicroProfileProjectInfoParams params) {
        CompletableFuture<MicroProfileProjectInfo> projectInfo = this.cache.get(params.getUri());
        if (projectInfo == null || projectInfo.isCancelled() || projectInfo.isCompletedExceptionally()) {
            params.setScopes(MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
            CompletionStage future = this.provider.getProjectInfo(params).thenApply(info -> new MicroProfileProjectInfoWrapper((MicroProfileProjectInfo)info));
            this.cache.put(params.getUri(), (CompletableFuture<MicroProfileProjectInfo>)future);
            return future;
        }
        if (!projectInfo.isDone()) {
            return projectInfo;
        }
        MicroProfileProjectInfoWrapper wrapper = MicroProfileProjectInfoCache.getProjectInfoWrapper(projectInfo);
        if (wrapper.isReloadFromSource()) {
            params.setScopes(MicroProfilePropertiesScope.ONLY_SOURCES);
            return ((CompletableFuture)this.provider.getProjectInfo(params).exceptionally(ex -> {
                LOGGER.log(Level.WARNING, String.format("Error while getting MicroProfileProjectInfo (sources) for '%s'", params.getUri()), (Throwable)ex);
                return MicroProfileProjectInfo.EMPTY_PROJECT_INFO;
            })).thenApply(info -> {
                wrapper.update(info.getProperties(), info.getHints());
                return wrapper;
            });
        }
        return projectInfo;
    }

    private static MicroProfileProjectInfoWrapper getProjectInfoWrapper(CompletableFuture<MicroProfileProjectInfo> future) {
        return future != null ? (MicroProfileProjectInfoWrapper)future.getNow(null) : null;
    }

    public Collection<String> propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        List<MicroProfilePropertiesScope> scopes = event.getType();
        boolean changedOnlyInSources = MicroProfilePropertiesScope.isOnlySources(scopes);
        if (changedOnlyInSources) {
            return this.javaSourceChanged(event.getProjectURIs());
        }
        return this.classpathChanged(event.getProjectURIs());
    }

    private Collection<String> classpathChanged(Set<String> projectURIs) {
        List<String> applicationPropertiesURIs = this.getApplicationPropertiesURIs(projectURIs);
        applicationPropertiesURIs.forEach(this.cache::remove);
        return applicationPropertiesURIs;
    }

    private Collection<String> javaSourceChanged(Set<String> projectURIs) {
        List<String> applicationPropertiesURIs = this.getApplicationPropertiesURIs(projectURIs);
        for (String uri : applicationPropertiesURIs) {
            MicroProfileProjectInfoWrapper info = MicroProfileProjectInfoCache.getProjectInfoWrapper(this.cache.get(uri));
            if (info == null) continue;
            info.clearPropertiesFromSource();
        }
        return applicationPropertiesURIs;
    }

    private List<String> getApplicationPropertiesURIs(Set<String> projectURIs) {
        return this.cache.entrySet().stream().filter(entry -> {
            MicroProfileProjectInfoWrapper projectInfo = MicroProfileProjectInfoCache.getProjectInfoWrapper((CompletableFuture)entry.getValue());
            if (projectInfo != null) {
                return projectURIs.contains(projectInfo.getProjectURI());
            }
            return false;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static class MicroProfileProjectInfoWrapper
    extends MicroProfileProjectInfo {
        private boolean reloadFromSource;
        private List<ItemMetadata> dynamicProperties;
        private final Function<String, ItemHint> getHint = hint -> this.getHint((String)hint);

        public MicroProfileProjectInfoWrapper(MicroProfileProjectInfo delegate) {
            super.setProjectURI(delegate.getProjectURI());
            super.setHints(new CopyOnWriteArrayList<ItemHint>(delegate.getHints() != null ? delegate.getHints() : new ArrayList()));
            ArrayList<ItemMetadata> staticProperties = delegate.getProperties() != null ? delegate.getProperties() : new ArrayList<ItemMetadata>();
            List<ItemMetadata> dynamicProperties = MicroProfileProjectInfoWrapper.computeDynamicProperties(staticProperties);
            staticProperties.removeAll(dynamicProperties);
            MicroProfileProjectInfoWrapper.expandProperties(staticProperties, dynamicProperties, this.getHint);
            this.setDynamicProperties(new CopyOnWriteArrayList<ItemMetadata>(dynamicProperties));
            super.setProperties(new CopyOnWriteArrayList<ItemMetadata>(staticProperties));
            this.reloadFromSource = false;
        }

        public void clearPropertiesFromSource() {
            this.setReloadFromSource(true);
        }

        private static List<ItemMetadata> computeDynamicProperties(List<ItemMetadata> properties) {
            return properties.stream().filter(p -> p != null && p.getName().contains("${")).collect(Collectors.toList());
        }

        synchronized void update(List<ItemMetadata> propertiesFromJavaSource, List<ItemHint> hintsFromJavaSource) {
            if (hintsFromJavaSource != null) {
                MicroProfileProjectInfoWrapper.updateListFromPropertiesSources(this.getHints(), hintsFromJavaSource);
            }
            if (propertiesFromJavaSource != null) {
                List<ItemMetadata> staticProperties = propertiesFromJavaSource;
                List<ItemMetadata> dynamicProperties = MicroProfileProjectInfoWrapper.computeDynamicProperties(staticProperties);
                staticProperties.removeAll(dynamicProperties);
                MicroProfileProjectInfoWrapper.expandProperties(staticProperties, dynamicProperties, this.getHint);
                MicroProfileProjectInfoWrapper.updateListFromPropertiesSources(this.getProperties(), staticProperties);
                MicroProfileProjectInfoWrapper.updateListFromPropertiesSources(this.getDynamicProperties(), dynamicProperties);
            }
            this.setReloadFromSource(false);
        }

        private static <T extends ItemBase> void updateListFromPropertiesSources(List<T> allProperties, List<T> propertiesFromJavaSources) {
            List oldPropertiesFromJavaSources = allProperties.stream().filter(h -> h == null || !h.isBinary()).collect(Collectors.toList());
            allProperties.removeAll(oldPropertiesFromJavaSources);
            allProperties.addAll(propertiesFromJavaSources);
        }

        private static void expandProperties(List<ItemMetadata> allProperties, List<ItemMetadata> dynamicProperties, Function<String, ItemHint> getHint) {
            for (ItemMetadata metadata : dynamicProperties) {
                int start = metadata.getName().indexOf("${");
                int end = metadata.getName().indexOf("}", start);
                String hint = metadata.getName().substring(start, end + 1);
                ItemHint itemHint = getHint.apply(hint);
                if (itemHint == null) continue;
                for (ItemHint.ValueHint value : itemHint.getValues()) {
                    allProperties.add(new ComputedItemMetadata(metadata, itemHint, value));
                }
            }
        }

        private boolean isReloadFromSource() {
            return this.reloadFromSource;
        }

        private void setReloadFromSource(boolean reloadFromSource) {
            this.reloadFromSource = reloadFromSource;
        }

        private List<ItemMetadata> getDynamicProperties() {
            return this.dynamicProperties;
        }

        void setDynamicProperties(List<ItemMetadata> dynamicProperties) {
            this.dynamicProperties = dynamicProperties;
        }
    }

    private static class ComputedItemMetadata
    extends ItemMetadata {
        public ComputedItemMetadata(ItemMetadata metadata, ItemHint itemHint, ItemHint.ValueHint value) {
            String name = metadata.getName().replace(itemHint.getName(), value.getValue());
            super.setName(name);
            super.setSource(Boolean.TRUE);
            super.setType(metadata.getType());
            super.setDescription(metadata.getDescription());
            super.setSourceType(value.getSourceType());
        }
    }
}

