/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.api.MicroProfileLanguageClientAPI;
import com.redhat.microprofile.ls.commons.ParentProcessWatcher;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class MicroProfileServerLauncher {
    public static void main(String[] args) {
        MicroProfileLanguageServer server = new MicroProfileLanguageServer();
        Function<MessageConsumer, MessageConsumer> wrapper = it -> it;
        wrapper = "false".equals(System.getProperty("watchParentProcess")) ? it -> it : new ParentProcessWatcher(server);
        Launcher<LanguageClient> launcher = MicroProfileServerLauncher.createServerLauncher(server, System.in, System.out, Executors.newCachedThreadPool(), wrapper);
        server.setClient((LanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(MicroProfileLanguageClientAPI.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }
}

