/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls;

import com.redhat.microprofile.commons.MicroProfileProjectInfoParams;
import com.redhat.microprofile.commons.MicroProfilePropertiesChangeEvent;
import com.redhat.microprofile.ls.ApplicationPropertiesTextDocumentService;
import com.redhat.microprofile.ls.JavaTextDocumentService;
import com.redhat.microprofile.ls.MicroProfileLanguageServer;
import com.redhat.microprofile.ls.api.MicroProfileLanguageServerAPI;
import com.redhat.microprofile.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.microprofile.settings.MicroProfileCodeLensSettings;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.settings.MicroProfileSymbolSettings;
import com.redhat.microprofile.settings.MicroProfileValidationSettings;
import com.redhat.microprofile.settings.SharedSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class MicroProfileTextDocumentService
implements TextDocumentService {
    private final Map<String, TextDocumentService> textDocumentServicesMap = new HashMap<String, TextDocumentService>();
    private final ApplicationPropertiesTextDocumentService applicationPropertiesTextDocumentService;
    private final JavaTextDocumentService javaTextDocumentService;
    private SharedSettings sharedSettings = new SharedSettings();

    public MicroProfileTextDocumentService(MicroProfileLanguageServer quarkusLanguageServer) {
        this.applicationPropertiesTextDocumentService = new ApplicationPropertiesTextDocumentService(quarkusLanguageServer, this.sharedSettings);
        this.javaTextDocumentService = new JavaTextDocumentService(quarkusLanguageServer, this.sharedSettings);
        this.textDocumentServicesMap.put("properties", this.applicationPropertiesTextDocumentService);
        this.textDocumentServicesMap.put("java", this.javaTextDocumentService);
    }

    public void updateClientCapabilities(ClientCapabilities capabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
        if (textDocumentClientCapabilities != null) {
            this.sharedSettings.getCompletionSettings().setCapabilities(textDocumentClientCapabilities.getCompletion());
            this.sharedSettings.getHoverSettings().setCapabilities(textDocumentClientCapabilities.getHover());
        }
        if (extendedClientCapabilities != null) {
            this.sharedSettings.getCommandCapabilities().setCapabilities(extendedClientCapabilities.getCommands());
        }
        this.applicationPropertiesTextDocumentService.updateClientCapabilities(capabilities);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didOpen(params);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        TextDocumentService service = this.getTextDocumentService((TextDocumentIdentifier)params.getTextDocument());
        if (service != null) {
            service.didChange(params);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didClose(params);
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didSave(params);
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        TextDocumentService service = this.getTextDocumentService(position.getTextDocument());
        if (service != null) {
            return service.completion(position);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.hover(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.documentSymbol(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.definition(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.formatting(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.rangeFormatting(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.codeAction(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.codeLens(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void propertiesChanged(MicroProfilePropertiesChangeEvent event) {
        this.applicationPropertiesTextDocumentService.propertiesChanged(event);
        this.javaTextDocumentService.propertiesChanged(event);
    }

    public void updateSymbolSettings(MicroProfileSymbolSettings newSettings) {
        this.applicationPropertiesTextDocumentService.updateSymbolSettings(newSettings);
    }

    public void updateValidationSettings(MicroProfileValidationSettings newValidation) {
        this.applicationPropertiesTextDocumentService.updateValidationSettings(newValidation);
    }

    public void updateFormattingSettings(MicroProfileFormattingSettings newFormatting) {
        this.applicationPropertiesTextDocumentService.updateFormattingSettings(newFormatting);
    }

    public void updateCodeLensSettings(MicroProfileCodeLensSettings newCodeLens) {
        this.javaTextDocumentService.updateCodeLensSettings(newCodeLens);
    }

    private TextDocumentService getTextDocumentService(TextDocumentIdentifier document) {
        String fileExtension = MicroProfileTextDocumentService.getFileExtension(document);
        return fileExtension != null ? this.textDocumentServicesMap.get(fileExtension) : null;
    }

    private TextDocumentService getTextDocumentService(TextDocumentItem document) {
        String fileExtension = MicroProfileTextDocumentService.getFileExtension(document);
        return fileExtension != null ? this.textDocumentServicesMap.get(fileExtension) : null;
    }

    private static String getFileExtension(TextDocumentIdentifier document) {
        return MicroProfileTextDocumentService.getFileExtension(document.getUri());
    }

    private static String getFileExtension(TextDocumentItem document) {
        return MicroProfileTextDocumentService.getFileExtension(document.getUri());
    }

    private static String getFileExtension(String uri) {
        int index = uri != null ? uri.lastIndexOf(46) : -1;
        return index != -1 ? uri.substring(index + 1, uri.length()) : null;
    }

    public CompletableFuture<MicroProfileLanguageServerAPI.JsonSchemaForProjectInfo> getJsonSchemaForProjectInfo(MicroProfileProjectInfoParams params) {
        return this.applicationPropertiesTextDocumentService.getJsonSchemaForProjectInfo(params);
    }
}

