/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionFactory {
    public static CodeAction remove(String title, Range range, TextDocumentItem document, Diagnostic diagnostic) {
        return CodeActionFactory.replace(title, range, "", document, diagnostic);
    }

    public static CodeAction insert(String title, Position position, String insertText, TextDocumentItem document, Diagnostic diagnostic) {
        return CodeActionFactory.insert(title, position, insertText, document, Arrays.asList(diagnostic));
    }

    public static CodeAction insert(String title, Position position, String insertText, TextDocumentItem document, List<Diagnostic> diagnostics) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(diagnostics);
        TextEdit edit = new TextEdit(new Range(position, position), insertText);
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Collections.singletonList(edit));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static CodeAction replace(String title, Range range, String replaceText, TextDocumentItem document, Diagnostic diagnostic) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(Arrays.asList(diagnostic));
        TextEdit edit = new TextEdit(range, replaceText);
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Collections.singletonList(edit));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static boolean isDiagnosticCode(Either<String, Number> diagnosticCode, String code) {
        if (diagnosticCode == null || diagnosticCode.isRight()) {
            return false;
        }
        return code.equals(diagnosticCode.getLeft());
    }
}

