/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons.snippets;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import com.redhat.microprofile.ls.commons.snippets.Snippet;
import java.lang.reflect.Type;
import java.util.ArrayList;

class SnippetDeserializer
implements JsonDeserializer<Snippet> {
    private static final String PREFIX_ELT = "prefix";
    private static final String DESCRIPTION_ELT = "description";
    private static final String SCOPE_ELT = "scope";
    private static final String BODY_ELT = "body";
    private static final String CONTEXT_ELT = "context";
    private final TypeAdapter<? extends ISnippetContext<?>> contextDeserializer;

    public SnippetDeserializer(TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) {
        this.contextDeserializer = contextDeserializer;
    }

    public Snippet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement contextElt;
        JsonElement scopeElt;
        Snippet snippet = new Snippet();
        JsonObject snippetObj = json.getAsJsonObject();
        ArrayList<String> prefixes = new ArrayList<String>();
        JsonElement prefixElt = snippetObj.get(PREFIX_ELT);
        if (prefixElt != null) {
            if (prefixElt.isJsonArray()) {
                JsonArray prefixArray = (JsonArray)prefixElt;
                prefixArray.forEach(elt -> prefixes.add(elt.getAsString()));
            } else if (prefixElt.isJsonPrimitive()) {
                prefixes.add(prefixElt.getAsString());
            }
        }
        snippet.setPrefixes(prefixes);
        ArrayList<String> body = new ArrayList<String>();
        JsonElement bodyElt = snippetObj.get(BODY_ELT);
        if (bodyElt != null) {
            if (bodyElt.isJsonArray()) {
                JsonArray bodyArray = (JsonArray)bodyElt;
                bodyArray.forEach(elt -> body.add(elt.getAsString()));
            } else if (bodyElt.isJsonPrimitive()) {
                body.add(bodyElt.getAsString());
            }
        }
        snippet.setBody(body);
        JsonElement descriptionElt = snippetObj.get(DESCRIPTION_ELT);
        if (descriptionElt != null) {
            String description = descriptionElt.getAsString();
            snippet.setDescription(description);
        }
        if ((scopeElt = snippetObj.get(SCOPE_ELT)) != null) {
            String scope = scopeElt.getAsString();
            snippet.setScope(scope);
        }
        if (this.contextDeserializer != null && (contextElt = snippetObj.get(CONTEXT_ELT)) != null) {
            ISnippetContext snippetContext = (ISnippetContext)this.contextDeserializer.fromJsonTree(contextElt);
            snippet.setContext(snippetContext);
        }
        return snippet;
    }
}

