/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons.snippets;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import com.redhat.microprofile.ls.commons.snippets.ISnippetRegistryLoader;
import com.redhat.microprofile.ls.commons.snippets.Snippet;
import com.redhat.microprofile.ls.commons.snippets.SnippetDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SnippetRegistry {
    private static final Logger LOGGER = Logger.getLogger(SnippetRegistry.class.getName());
    private final List<Snippet> snippets = new ArrayList<Snippet>();

    public SnippetRegistry() {
        this(null);
    }

    public SnippetRegistry(String languageId) {
        ServiceLoader<ISnippetRegistryLoader> loaders = ServiceLoader.load(ISnippetRegistryLoader.class);
        loaders.forEach(loader -> {
            if (Objects.equals(languageId, loader.getLanguageId())) {
                try {
                    loader.load(this);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while consumming snippet loader " + loader.getClass().getName(), e);
                }
            }
        });
    }

    public void registerSnippet(Snippet snippet) {
        this.snippets.add(snippet);
    }

    public void registerSnippets(InputStream in) throws IOException {
        this.registerSnippets(in, null);
    }

    public void registerSnippets(InputStream in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(new InputStreamReader(in, StandardCharsets.UTF_8.name()), contextDeserializer);
    }

    public void registerSnippets(Reader in) throws IOException {
        this.registerSnippets(in, null);
    }

    public void registerSnippets(Reader in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        JsonReader reader = new JsonReader(in);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            Snippet snippet = SnippetRegistry.createSnippet(reader, contextDeserializer);
            if (snippet.getDescription() == null) {
                snippet.setDescription(name);
            }
            this.registerSnippet(snippet);
        }
        reader.endObject();
    }

    private static Snippet createSnippet(JsonReader reader, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws JsonIOException, JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Snippet.class, (Object)new SnippetDeserializer(contextDeserializer));
        return (Snippet)builder.create().fromJson(reader, Snippet.class);
    }

    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    public List<CompletionItem> getCompletionItem(Range replaceRange, String lineDelimiter, boolean canSupportMarkdown, Predicate<ISnippetContext<?>> contextFilter) {
        if (replaceRange == null) {
            return Collections.emptyList();
        }
        return this.getSnippets().stream().filter(snippet -> snippet.match(contextFilter)).map(snippet -> {
            String prefix;
            String label = prefix = snippet.getPrefixes().get(0);
            CompletionItem item = new CompletionItem();
            item.setLabel(label);
            item.setDetail(snippet.getDescription());
            String insertText = SnippetRegistry.getInsertText(snippet, false, lineDelimiter);
            item.setKind(CompletionItemKind.Snippet);
            item.setDocumentation(Either.forRight((Object)SnippetRegistry.createDocumentation(snippet, canSupportMarkdown, lineDelimiter)));
            item.setFilterText(prefix);
            item.setTextEdit(new TextEdit(replaceRange, insertText));
            item.setInsertTextFormat(InsertTextFormat.Snippet);
            return item;
        }).filter(item -> item != null).collect(Collectors.toList());
    }

    private static MarkupContent createDocumentation(Snippet snippet, boolean canSupportMarkdown, String lineDelimiter) {
        StringBuilder doc = new StringBuilder();
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            String scope = snippet.getScope();
            if (scope != null) {
                doc.append(scope);
            }
            doc.append(System.lineSeparator());
        }
        String insertText = SnippetRegistry.getInsertText(snippet, true, lineDelimiter);
        doc.append(insertText);
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            doc.append(System.lineSeparator());
        }
        return new MarkupContent(canSupportMarkdown ? "markdown" : "plaintext", doc.toString());
    }

    private static String getInsertText(Snippet snippet, boolean replace, String lineDelimiter) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        List<String> body = snippet.getBody();
        if (body != null) {
            for (String bodyLine : body) {
                if (i > 0) {
                    text.append(lineDelimiter);
                }
                if (replace) {
                    bodyLine = SnippetRegistry.replace(bodyLine);
                }
                text.append(bodyLine);
                ++i;
            }
        }
        return text.toString();
    }

    private static String replace(String line) {
        return SnippetRegistry.replace(line, 0, null);
    }

    private static String replace(String line, int offset, StringBuilder newLine) {
        int startExpr = line.indexOf("${", offset);
        if (startExpr == -1) {
            if (newLine == null) {
                return line;
            }
            newLine.append(line.substring(offset, line.length()));
            return newLine.toString();
        }
        int endExpr = line.indexOf("}", startExpr);
        if (endExpr == -1) {
            return line;
        }
        if (newLine == null) {
            newLine = new StringBuilder();
        }
        newLine.append(line.substring(offset, startExpr));
        int startParam = startExpr + 2;
        int endParam = endExpr;
        boolean startsWithNumber = true;
        for (int i = startParam; i < endParam; ++i) {
            char ch = line.charAt(i);
            if (!Character.isDigit(ch)) {
                if (ch == ':') {
                    if (!startsWithNumber) break;
                    startParam = i + 1;
                    break;
                }
                if (ch != '|' || !startsWithNumber) break;
                startParam = i + 1;
                int index = line.indexOf(44, startExpr);
                if (index == -1) break;
                endParam = index;
                break;
            }
            startsWithNumber = true;
        }
        newLine.append(line.substring(startParam, endParam));
        return SnippetRegistry.replace(line, endExpr + 1, newLine);
    }

    protected static String findExprBeforeAt(String text, int offset) {
        char ch;
        if (offset < 0 || offset > text.length()) {
            return null;
        }
        if (offset == 0) {
            return "";
        }
        StringBuilder expr = new StringBuilder();
        for (int i = offset - 1; i >= 0 && !Character.isWhitespace(ch = text.charAt(i)); --i) {
            expr.insert(0, ch);
        }
        return expr.toString();
    }
}

