/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.ls.commons.snippets;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import com.redhat.microprofile.ls.commons.snippets.SnippetRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Range;

public class TextDocumentSnippetRegistry
extends SnippetRegistry {
    private static final Logger LOGGER = Logger.getLogger(TextDocumentSnippetRegistry.class.getName());

    public TextDocumentSnippetRegistry() {
    }

    public TextDocumentSnippetRegistry(String languageId) {
        super(languageId);
    }

    public List<CompletionItem> getCompletionItems(TextDocument document, int completionOffset, boolean canSupportMarkdown, Predicate<ISnippetContext<?>> contextFilter) {
        try {
            String lineDelimiter = TextDocumentSnippetRegistry.getLineDelimiter(document, completionOffset);
            Range range = this.getReplaceRange(document, completionOffset);
            return super.getCompletionItem(range, lineDelimiter, canSupportMarkdown, contextFilter);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while computing snippet completion items", e);
            return Collections.emptyList();
        }
    }

    private static String getLineDelimiter(TextDocument document, int completionOffset) throws BadLocationException {
        int lineNumber = document.positionAt(completionOffset).getLine();
        return document.lineDelimiter(lineNumber);
    }

    public Range getReplaceRange(TextDocument document, int completionOffset) throws BadLocationException {
        String expr = this.getExpr(document, completionOffset);
        if (expr == null) {
            return null;
        }
        int startOffset = completionOffset - expr.length();
        int endOffset = completionOffset;
        return this.getReplaceRange(startOffset, endOffset, document);
    }

    protected String getExpr(TextDocument document, int completionOffset) {
        return TextDocumentSnippetRegistry.findExprBeforeAt(document.getText(), completionOffset);
    }

    protected Range getReplaceRange(int replaceStart, int replaceEnd, TextDocument document) throws BadLocationException {
        return new Range(document.positionAt(replaceStart), document.positionAt(replaceEnd));
    }
}

